/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for the rule violation in a security group when compared to the primary security group of the
 * Firewall Manager policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsVPCSecurityGroupViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsVPCSecurityGroupViolation.Builder, AwsVPCSecurityGroupViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(AwsVPCSecurityGroupViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<String> VIOLATION_TARGET_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ViolationTargetDescription")
            .getter(getter(AwsVPCSecurityGroupViolation::violationTargetDescription))
            .setter(setter(Builder::violationTargetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTargetDescription").build())
            .build();

    private static final SdkField<List<PartialMatch>> PARTIAL_MATCHES_FIELD = SdkField
            .<List<PartialMatch>> builder(MarshallingType.LIST)
            .memberName("PartialMatches")
            .getter(getter(AwsVPCSecurityGroupViolation::partialMatches))
            .setter(setter(Builder::partialMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartialMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartialMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SecurityGroupRemediationAction>> POSSIBLE_SECURITY_GROUP_REMEDIATION_ACTIONS_FIELD = SdkField
            .<List<SecurityGroupRemediationAction>> builder(MarshallingType.LIST)
            .memberName("PossibleSecurityGroupRemediationActions")
            .getter(getter(AwsVPCSecurityGroupViolation::possibleSecurityGroupRemediationActions))
            .setter(setter(Builder::possibleSecurityGroupRemediationActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PossibleSecurityGroupRemediationActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupRemediationAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupRemediationAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            VIOLATION_TARGET_DESCRIPTION_FIELD, PARTIAL_MATCHES_FIELD, POSSIBLE_SECURITY_GROUP_REMEDIATION_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final String violationTargetDescription;

    private final List<PartialMatch> partialMatches;

    private final List<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions;

    private AwsVPCSecurityGroupViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.violationTargetDescription = builder.violationTargetDescription;
        this.partialMatches = builder.partialMatches;
        this.possibleSecurityGroupRemediationActions = builder.possibleSecurityGroupRemediationActions;
    }

    /**
     * <p>
     * The security group rule that is being evaluated.
     * </p>
     * 
     * @return The security group rule that is being evaluated.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * <p>
     * A description of the security group that violates the policy.
     * </p>
     * 
     * @return A description of the security group that violates the policy.
     */
    public final String violationTargetDescription() {
        return violationTargetDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartialMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartialMatches() {
        return partialMatches != null && !(partialMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of rules specified in the security group of the Firewall Manager policy that partially match the
     * <code>ViolationTarget</code> rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartialMatches} method.
     * </p>
     * 
     * @return List of rules specified in the security group of the Firewall Manager policy that partially match the
     *         <code>ViolationTarget</code> rule.
     */
    public final List<PartialMatch> partialMatches() {
        return partialMatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the PossibleSecurityGroupRemediationActions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPossibleSecurityGroupRemediationActions() {
        return possibleSecurityGroupRemediationActions != null
                && !(possibleSecurityGroupRemediationActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remediation options for the rule specified in the <code>ViolationTarget</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasPossibleSecurityGroupRemediationActions} method.
     * </p>
     * 
     * @return Remediation options for the rule specified in the <code>ViolationTarget</code>.
     */
    public final List<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions() {
        return possibleSecurityGroupRemediationActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(violationTargetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartialMatches() ? partialMatches() : null);
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasPossibleSecurityGroupRemediationActions() ? possibleSecurityGroupRemediationActions()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsVPCSecurityGroupViolation)) {
            return false;
        }
        AwsVPCSecurityGroupViolation other = (AwsVPCSecurityGroupViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget())
                && Objects.equals(violationTargetDescription(), other.violationTargetDescription())
                && hasPartialMatches() == other.hasPartialMatches() && Objects.equals(partialMatches(), other.partialMatches())
                && hasPossibleSecurityGroupRemediationActions() == other.hasPossibleSecurityGroupRemediationActions()
                && Objects.equals(possibleSecurityGroupRemediationActions(), other.possibleSecurityGroupRemediationActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AwsVPCSecurityGroupViolation")
                .add("ViolationTarget", violationTarget())
                .add("ViolationTargetDescription", violationTargetDescription())
                .add("PartialMatches", hasPartialMatches() ? partialMatches() : null)
                .add("PossibleSecurityGroupRemediationActions",
                        hasPossibleSecurityGroupRemediationActions() ? possibleSecurityGroupRemediationActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "ViolationTargetDescription":
            return Optional.ofNullable(clazz.cast(violationTargetDescription()));
        case "PartialMatches":
            return Optional.ofNullable(clazz.cast(partialMatches()));
        case "PossibleSecurityGroupRemediationActions":
            return Optional.ofNullable(clazz.cast(possibleSecurityGroupRemediationActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsVPCSecurityGroupViolation, T> g) {
        return obj -> g.apply((AwsVPCSecurityGroupViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsVPCSecurityGroupViolation> {
        /**
         * <p>
         * The security group rule that is being evaluated.
         * </p>
         * 
         * @param violationTarget
         *        The security group rule that is being evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * A description of the security group that violates the policy.
         * </p>
         * 
         * @param violationTargetDescription
         *        A description of the security group that violates the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTargetDescription(String violationTargetDescription);

        /**
         * <p>
         * List of rules specified in the security group of the Firewall Manager policy that partially match the
         * <code>ViolationTarget</code> rule.
         * </p>
         * 
         * @param partialMatches
         *        List of rules specified in the security group of the Firewall Manager policy that partially match the
         *        <code>ViolationTarget</code> rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialMatches(Collection<PartialMatch> partialMatches);

        /**
         * <p>
         * List of rules specified in the security group of the Firewall Manager policy that partially match the
         * <code>ViolationTarget</code> rule.
         * </p>
         * 
         * @param partialMatches
         *        List of rules specified in the security group of the Firewall Manager policy that partially match the
         *        <code>ViolationTarget</code> rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialMatches(PartialMatch... partialMatches);

        /**
         * <p>
         * List of rules specified in the security group of the Firewall Manager policy that partially match the
         * <code>ViolationTarget</code> rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartialMatch>.Builder} avoiding the need to
         * create one manually via {@link List<PartialMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartialMatch>.Builder#build()} is called immediately and its
         * result is passed to {@link #partialMatches(List<PartialMatch>)}.
         * 
         * @param partialMatches
         *        a consumer that will call methods on {@link List<PartialMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partialMatches(List<PartialMatch>)
         */
        Builder partialMatches(Consumer<PartialMatch.Builder>... partialMatches);

        /**
         * <p>
         * Remediation options for the rule specified in the <code>ViolationTarget</code>.
         * </p>
         * 
         * @param possibleSecurityGroupRemediationActions
         *        Remediation options for the rule specified in the <code>ViolationTarget</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder possibleSecurityGroupRemediationActions(
                Collection<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions);

        /**
         * <p>
         * Remediation options for the rule specified in the <code>ViolationTarget</code>.
         * </p>
         * 
         * @param possibleSecurityGroupRemediationActions
         *        Remediation options for the rule specified in the <code>ViolationTarget</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder possibleSecurityGroupRemediationActions(SecurityGroupRemediationAction... possibleSecurityGroupRemediationActions);

        /**
         * <p>
         * Remediation options for the rule specified in the <code>ViolationTarget</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroupRemediationAction>.Builder}
         * avoiding the need to create one manually via {@link List<SecurityGroupRemediationAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroupRemediationAction>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #possibleSecurityGroupRemediationActions(List<SecurityGroupRemediationAction>)}.
         * 
         * @param possibleSecurityGroupRemediationActions
         *        a consumer that will call methods on {@link List<SecurityGroupRemediationAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #possibleSecurityGroupRemediationActions(List<SecurityGroupRemediationAction>)
         */
        Builder possibleSecurityGroupRemediationActions(
                Consumer<SecurityGroupRemediationAction.Builder>... possibleSecurityGroupRemediationActions);
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private String violationTargetDescription;

        private List<PartialMatch> partialMatches = DefaultSdkAutoConstructList.getInstance();

        private List<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsVPCSecurityGroupViolation model) {
            violationTarget(model.violationTarget);
            violationTargetDescription(model.violationTargetDescription);
            partialMatches(model.partialMatches);
            possibleSecurityGroupRemediationActions(model.possibleSecurityGroupRemediationActions);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        @Transient
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final String getViolationTargetDescription() {
            return violationTargetDescription;
        }

        public final void setViolationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
        }

        @Override
        @Transient
        public final Builder violationTargetDescription(String violationTargetDescription) {
            this.violationTargetDescription = violationTargetDescription;
            return this;
        }

        public final List<PartialMatch.Builder> getPartialMatches() {
            List<PartialMatch.Builder> result = PartialMatchesCopier.copyToBuilder(this.partialMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartialMatches(Collection<PartialMatch.BuilderImpl> partialMatches) {
            this.partialMatches = PartialMatchesCopier.copyFromBuilder(partialMatches);
        }

        @Override
        @Transient
        public final Builder partialMatches(Collection<PartialMatch> partialMatches) {
            this.partialMatches = PartialMatchesCopier.copy(partialMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partialMatches(PartialMatch... partialMatches) {
            partialMatches(Arrays.asList(partialMatches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partialMatches(Consumer<PartialMatch.Builder>... partialMatches) {
            partialMatches(Stream.of(partialMatches).map(c -> PartialMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SecurityGroupRemediationAction.Builder> getPossibleSecurityGroupRemediationActions() {
            List<SecurityGroupRemediationAction.Builder> result = SecurityGroupRemediationActionsCopier
                    .copyToBuilder(this.possibleSecurityGroupRemediationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPossibleSecurityGroupRemediationActions(
                Collection<SecurityGroupRemediationAction.BuilderImpl> possibleSecurityGroupRemediationActions) {
            this.possibleSecurityGroupRemediationActions = SecurityGroupRemediationActionsCopier
                    .copyFromBuilder(possibleSecurityGroupRemediationActions);
        }

        @Override
        @Transient
        public final Builder possibleSecurityGroupRemediationActions(
                Collection<SecurityGroupRemediationAction> possibleSecurityGroupRemediationActions) {
            this.possibleSecurityGroupRemediationActions = SecurityGroupRemediationActionsCopier
                    .copy(possibleSecurityGroupRemediationActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder possibleSecurityGroupRemediationActions(
                SecurityGroupRemediationAction... possibleSecurityGroupRemediationActions) {
            possibleSecurityGroupRemediationActions(Arrays.asList(possibleSecurityGroupRemediationActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder possibleSecurityGroupRemediationActions(
                Consumer<SecurityGroupRemediationAction.Builder>... possibleSecurityGroupRemediationActions) {
            possibleSecurityGroupRemediationActions(Stream.of(possibleSecurityGroupRemediationActions)
                    .map(c -> SecurityGroupRemediationAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsVPCSecurityGroupViolation build() {
            return new AwsVPCSecurityGroupViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
