/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the resource sets used in a policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSetSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSetSummary.Builder, ResourceSetSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResourceSetSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResourceSetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ResourceSetSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(ResourceSetSummary::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> RESOURCE_SET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetStatus").getter(getter(ResourceSetSummary::resourceSetStatusAsString))
            .setter(setter(Builder::resourceSetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, LAST_UPDATE_TIME_FIELD, RESOURCE_SET_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final Instant lastUpdateTime;

    private final String resourceSetStatus;

    private ResourceSetSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.resourceSetStatus = builder.resourceSetStatus;
    }

    /**
     * <p>
     * A unique identifier for the resource set. This ID is returned in the responses to create and list commands. You
     * provide it to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the resource set. This ID is returned in the responses to create and list
     *         commands. You provide it to operations like update and delete.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The descriptive name of the resource set. You can't change the name of a resource set after you create it.
     * </p>
     * 
     * @return The descriptive name of the resource set. You can't change the name of a resource set after you create
     *         it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the resource set.
     * </p>
     * 
     * @return A description of the resource set.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The last time that the resource set was changed.
     * </p>
     * 
     * @return The last time that the resource set was changed.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * Indicates whether the resource set is in or out of an admin's Region scope.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The administrator can manage and delete the resource set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or delete the
     * resource set. Existing protections stay in place. Any new resource that come into scope of the resource set won't
     * be protected.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceSetStatus}
     * will return {@link ResourceSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceSetStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the resource set is in or out of an admin's Region scope.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The administrator can manage and delete the resource set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or
     *         delete the resource set. Existing protections stay in place. Any new resource that come into scope of the
     *         resource set won't be protected.
     *         </p>
     *         </li>
     * @see ResourceSetStatus
     */
    public final ResourceSetStatus resourceSetStatus() {
        return ResourceSetStatus.fromValue(resourceSetStatus);
    }

    /**
     * <p>
     * Indicates whether the resource set is in or out of an admin's Region scope.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The administrator can manage and delete the resource set.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or delete the
     * resource set. Existing protections stay in place. Any new resource that come into scope of the resource set won't
     * be protected.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceSetStatus}
     * will return {@link ResourceSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceSetStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the resource set is in or out of an admin's Region scope.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The administrator can manage and delete the resource set.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or
     *         delete the resource set. Existing protections stay in place. Any new resource that come into scope of the
     *         resource set won't be protected.
     *         </p>
     *         </li>
     * @see ResourceSetStatus
     */
    public final String resourceSetStatusAsString() {
        return resourceSetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSetSummary)) {
            return false;
        }
        ResourceSetSummary other = (ResourceSetSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(resourceSetStatusAsString(), other.resourceSetStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSetSummary").add("Id", id()).add("Name", name()).add("Description", description())
                .add("LastUpdateTime", lastUpdateTime()).add("ResourceSetStatus", resourceSetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "ResourceSetStatus":
            return Optional.ofNullable(clazz.cast(resourceSetStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSetSummary, T> g) {
        return obj -> g.apply((ResourceSetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSetSummary> {
        /**
         * <p>
         * A unique identifier for the resource set. This ID is returned in the responses to create and list commands.
         * You provide it to operations like update and delete.
         * </p>
         * 
         * @param id
         *        A unique identifier for the resource set. This ID is returned in the responses to create and list
         *        commands. You provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The descriptive name of the resource set. You can't change the name of a resource set after you create it.
         * </p>
         * 
         * @param name
         *        The descriptive name of the resource set. You can't change the name of a resource set after you create
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the resource set.
         * </p>
         * 
         * @param description
         *        A description of the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The last time that the resource set was changed.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time that the resource set was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * Indicates whether the resource set is in or out of an admin's Region scope.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The administrator can manage and delete the resource set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or delete
         * the resource set. Existing protections stay in place. Any new resource that come into scope of the resource
         * set won't be protected.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceSetStatus
         *        Indicates whether the resource set is in or out of an admin's Region scope.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The administrator can manage and delete the resource set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or
         *        delete the resource set. Existing protections stay in place. Any new resource that come into scope of
         *        the resource set won't be protected.
         *        </p>
         *        </li>
         * @see ResourceSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSetStatus
         */
        Builder resourceSetStatus(String resourceSetStatus);

        /**
         * <p>
         * Indicates whether the resource set is in or out of an admin's Region scope.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The administrator can manage and delete the resource set.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or delete
         * the resource set. Existing protections stay in place. Any new resource that come into scope of the resource
         * set won't be protected.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceSetStatus
         *        Indicates whether the resource set is in or out of an admin's Region scope.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The administrator can manage and delete the resource set.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUT_OF_ADMIN_SCOPE</code> - The administrator can view the resource set, but they can't edit or
         *        delete the resource set. Existing protections stay in place. Any new resource that come into scope of
         *        the resource set won't be protected.
         *        </p>
         *        </li>
         * @see ResourceSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSetStatus
         */
        Builder resourceSetStatus(ResourceSetStatus resourceSetStatus);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Instant lastUpdateTime;

        private String resourceSetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSetSummary model) {
            id(model.id);
            name(model.name);
            description(model.description);
            lastUpdateTime(model.lastUpdateTime);
            resourceSetStatus(model.resourceSetStatus);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getResourceSetStatus() {
            return resourceSetStatus;
        }

        public final void setResourceSetStatus(String resourceSetStatus) {
            this.resourceSetStatus = resourceSetStatus;
        }

        @Override
        public final Builder resourceSetStatus(String resourceSetStatus) {
            this.resourceSetStatus = resourceSetStatus;
            return this;
        }

        @Override
        public final Builder resourceSetStatus(ResourceSetStatus resourceSetStatus) {
            this.resourceSetStatus(resourceSetStatus == null ? null : resourceSetStatus.toString());
            return this;
        }

        @Override
        public ResourceSetSummary build() {
            return new ResourceSetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
