/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of resources to include in a policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSet implements SdkPojo, Serializable, ToCopyableBuilder<ResourceSet.Builder, ResourceSet> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResourceSet::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResourceSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ResourceSet::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(ResourceSet::updateToken)).setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypeList")
            .getter(getter(ResourceSet::resourceTypeList))
            .setter(setter(Builder::resourceTypeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(ResourceSet::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, UPDATE_TOKEN_FIELD, RESOURCE_TYPE_LIST_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String updateToken;

    private final List<String> resourceTypeList;

    private final Instant lastUpdateTime;

    private ResourceSet(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.updateToken = builder.updateToken;
        this.resourceTypeList = builder.resourceTypeList;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * A unique identifier for the resource set. This ID is returned in the responses to create and list commands. You
     * provide it to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the resource set. This ID is returned in the responses to create and list
     *         commands. You provide it to operations like update and delete.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The descriptive name of the resource set. You can't change the name of a resource set after you create it.
     * </p>
     * 
     * @return The descriptive name of the resource set. You can't change the name of a resource set after you create
     *         it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the resource set.
     * </p>
     * 
     * @return A description of the resource set.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An optional token that you can use for optimistic locking. Firewall Manager returns a token to your requests that
     * access the resource set. The token marks the state of the resource set resource at the time of the request.
     * Update tokens are not allowed when creating a resource set. After creation, each subsequent update call to the
     * resource set requires the update token.
     * </p>
     * <p>
     * To make an unconditional change to the resource set, omit the token in your update request. Without the token,
     * Firewall Manager performs your updates regardless of whether the resource set has changed since you last
     * retrieved it.
     * </p>
     * <p>
     * To make a conditional change to the resource set, provide the token in your update request. Firewall Manager uses
     * the token to ensure that the resource set hasn't changed since you last retrieved it. If it has changed, the
     * operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the resource set again to
     * get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the
     * new token.
     * </p>
     * 
     * @return An optional token that you can use for optimistic locking. Firewall Manager returns a token to your
     *         requests that access the resource set. The token marks the state of the resource set resource at the time
     *         of the request. Update tokens are not allowed when creating a resource set. After creation, each
     *         subsequent update call to the resource set requires the update token. </p>
     *         <p>
     *         To make an unconditional change to the resource set, omit the token in your update request. Without the
     *         token, Firewall Manager performs your updates regardless of whether the resource set has changed since
     *         you last retrieved it.
     *         </p>
     *         <p>
     *         To make a conditional change to the resource set, provide the token in your update request. Firewall
     *         Manager uses the token to ensure that the resource set hasn't changed since you last retrieved it. If it
     *         has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve
     *         the resource set again to get a current copy of it with a new token. Reapply your changes as needed, then
     *         try the operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypeList() {
        return resourceTypeList != null && !(resourceTypeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the resources that can be associated to the resource set. Depending on your setting for max results
     * and the number of resource sets, a single call might not return the full list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeList} method.
     * </p>
     * 
     * @return Determines the resources that can be associated to the resource set. Depending on your setting for max
     *         results and the number of resource sets, a single call might not return the full list.
     */
    public final List<String> resourceTypeList() {
        return resourceTypeList;
    }

    /**
     * <p>
     * The last time that the resource set was changed.
     * </p>
     * 
     * @return The last time that the resource set was changed.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypeList() ? resourceTypeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSet)) {
            return false;
        }
        ResourceSet other = (ResourceSet) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(updateToken(), other.updateToken())
                && hasResourceTypeList() == other.hasResourceTypeList()
                && Objects.equals(resourceTypeList(), other.resourceTypeList())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSet").add("Id", id()).add("Name", name()).add("Description", description())
                .add("UpdateToken", updateToken()).add("ResourceTypeList", hasResourceTypeList() ? resourceTypeList() : null)
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "ResourceTypeList":
            return Optional.ofNullable(clazz.cast(resourceTypeList()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSet, T> g) {
        return obj -> g.apply((ResourceSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSet> {
        /**
         * <p>
         * A unique identifier for the resource set. This ID is returned in the responses to create and list commands.
         * You provide it to operations like update and delete.
         * </p>
         * 
         * @param id
         *        A unique identifier for the resource set. This ID is returned in the responses to create and list
         *        commands. You provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The descriptive name of the resource set. You can't change the name of a resource set after you create it.
         * </p>
         * 
         * @param name
         *        The descriptive name of the resource set. You can't change the name of a resource set after you create
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the resource set.
         * </p>
         * 
         * @param description
         *        A description of the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An optional token that you can use for optimistic locking. Firewall Manager returns a token to your requests
         * that access the resource set. The token marks the state of the resource set resource at the time of the
         * request. Update tokens are not allowed when creating a resource set. After creation, each subsequent update
         * call to the resource set requires the update token.
         * </p>
         * <p>
         * To make an unconditional change to the resource set, omit the token in your update request. Without the
         * token, Firewall Manager performs your updates regardless of whether the resource set has changed since you
         * last retrieved it.
         * </p>
         * <p>
         * To make a conditional change to the resource set, provide the token in your update request. Firewall Manager
         * uses the token to ensure that the resource set hasn't changed since you last retrieved it. If it has changed,
         * the operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the resource set
         * again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation
         * again using the new token.
         * </p>
         * 
         * @param updateToken
         *        An optional token that you can use for optimistic locking. Firewall Manager returns a token to your
         *        requests that access the resource set. The token marks the state of the resource set resource at the
         *        time of the request. Update tokens are not allowed when creating a resource set. After creation, each
         *        subsequent update call to the resource set requires the update token. </p>
         *        <p>
         *        To make an unconditional change to the resource set, omit the token in your update request. Without
         *        the token, Firewall Manager performs your updates regardless of whether the resource set has changed
         *        since you last retrieved it.
         *        </p>
         *        <p>
         *        To make a conditional change to the resource set, provide the token in your update request. Firewall
         *        Manager uses the token to ensure that the resource set hasn't changed since you last retrieved it. If
         *        it has changed, the operation fails with an <code>InvalidTokenException</code>. If this happens,
         *        retrieve the resource set again to get a current copy of it with a new token. Reapply your changes as
         *        needed, then try the operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * Determines the resources that can be associated to the resource set. Depending on your setting for max
         * results and the number of resource sets, a single call might not return the full list.
         * </p>
         * 
         * @param resourceTypeList
         *        Determines the resources that can be associated to the resource set. Depending on your setting for max
         *        results and the number of resource sets, a single call might not return the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeList(Collection<String> resourceTypeList);

        /**
         * <p>
         * Determines the resources that can be associated to the resource set. Depending on your setting for max
         * results and the number of resource sets, a single call might not return the full list.
         * </p>
         * 
         * @param resourceTypeList
         *        Determines the resources that can be associated to the resource set. Depending on your setting for max
         *        results and the number of resource sets, a single call might not return the full list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeList(String... resourceTypeList);

        /**
         * <p>
         * The last time that the resource set was changed.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time that the resource set was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String updateToken;

        private List<String> resourceTypeList = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSet model) {
            id(model.id);
            name(model.name);
            description(model.description);
            updateToken(model.updateToken);
            resourceTypeList(model.resourceTypeList);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final Collection<String> getResourceTypeList() {
            if (resourceTypeList instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypeList;
        }

        public final void setResourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
        }

        @Override
        public final Builder resourceTypeList(Collection<String> resourceTypeList) {
            this.resourceTypeList = ResourceTypeListCopier.copy(resourceTypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeList(String... resourceTypeList) {
            resourceTypeList(Arrays.asList(resourceTypeList));
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public ResourceSet build() {
            return new ResourceSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
