/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateResourceResponse extends FmsResponse implements
        ToCopyableBuilder<BatchDisassociateResourceResponse.Builder, BatchDisassociateResourceResponse> {
    private static final SdkField<String> RESOURCE_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetIdentifier").getter(getter(BatchDisassociateResourceResponse::resourceSetIdentifier))
            .setter(setter(Builder::resourceSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSetIdentifier").build())
            .build();

    private static final SdkField<List<FailedItem>> FAILED_ITEMS_FIELD = SdkField
            .<List<FailedItem>> builder(MarshallingType.LIST)
            .memberName("FailedItems")
            .getter(getter(BatchDisassociateResourceResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SET_IDENTIFIER_FIELD,
            FAILED_ITEMS_FIELD));

    private final String resourceSetIdentifier;

    private final List<FailedItem> failedItems;

    private BatchDisassociateResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceSetIdentifier = builder.resourceSetIdentifier;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * A unique identifier for the resource set, used in a request to refer to the resource set.
     * </p>
     * 
     * @return A unique identifier for the resource set, used in a request to refer to the resource set.
     */
    public final String resourceSetIdentifier() {
        return resourceSetIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources that failed to disassociate from the resource set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedItems} method.
     * </p>
     * 
     * @return The resources that failed to disassociate from the resource set.
     */
    public final List<FailedItem> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedItems() ? failedItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateResourceResponse)) {
            return false;
        }
        BatchDisassociateResourceResponse other = (BatchDisassociateResourceResponse) obj;
        return Objects.equals(resourceSetIdentifier(), other.resourceSetIdentifier())
                && hasFailedItems() == other.hasFailedItems() && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDisassociateResourceResponse").add("ResourceSetIdentifier", resourceSetIdentifier())
                .add("FailedItems", hasFailedItems() ? failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceSetIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSetIdentifier()));
        case "FailedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateResourceResponse, T> g) {
        return obj -> g.apply((BatchDisassociateResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDisassociateResourceResponse> {
        /**
         * <p>
         * A unique identifier for the resource set, used in a request to refer to the resource set.
         * </p>
         * 
         * @param resourceSetIdentifier
         *        A unique identifier for the resource set, used in a request to refer to the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSetIdentifier(String resourceSetIdentifier);

        /**
         * <p>
         * The resources that failed to disassociate from the resource set.
         * </p>
         * 
         * @param failedItems
         *        The resources that failed to disassociate from the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Collection<FailedItem> failedItems);

        /**
         * <p>
         * The resources that failed to disassociate from the resource set.
         * </p>
         * 
         * @param failedItems
         *        The resources that failed to disassociate from the resource set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(FailedItem... failedItems);

        /**
         * <p>
         * The resources that failed to disassociate from the resource set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.FailedItem.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.fms.model.FailedItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.FailedItem.Builder#build()} is called immediately and its
         * result is passed to {@link #failedItems(List<FailedItem>)}.
         * 
         * @param failedItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.FailedItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedItems(java.util.Collection<FailedItem>)
         */
        Builder failedItems(Consumer<FailedItem.Builder>... failedItems);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private String resourceSetIdentifier;

        private List<FailedItem> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateResourceResponse model) {
            super(model);
            resourceSetIdentifier(model.resourceSetIdentifier);
            failedItems(model.failedItems);
        }

        public final String getResourceSetIdentifier() {
            return resourceSetIdentifier;
        }

        public final void setResourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
        }

        @Override
        public final Builder resourceSetIdentifier(String resourceSetIdentifier) {
            this.resourceSetIdentifier = resourceSetIdentifier;
            return this;
        }

        public final List<FailedItem.Builder> getFailedItems() {
            List<FailedItem.Builder> result = FailedItemListCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Collection<FailedItem.BuilderImpl> failedItems) {
            this.failedItems = FailedItemListCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Collection<FailedItem> failedItems) {
            this.failedItems = FailedItemListCopier.copy(failedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(FailedItem... failedItems) {
            failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(Consumer<FailedItem.Builder>... failedItems) {
            failedItems(Stream.of(failedItems).map(c -> FailedItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateResourceResponse build() {
            return new BatchDisassociateResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
