/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The violation details for a web ACL that's associated with at least one resource that's out of scope of the Firewall
 * Manager policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebACLHasOutOfScopeResourcesViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<WebACLHasOutOfScopeResourcesViolation.Builder, WebACLHasOutOfScopeResourcesViolation> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLArn").getter(getter(WebACLHasOutOfScopeResourcesViolation::webACLArn))
            .setter(setter(Builder::webACLArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLArn").build()).build();

    private static final SdkField<List<String>> OUT_OF_SCOPE_RESOURCE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OutOfScopeResourceList")
            .getter(getter(WebACLHasOutOfScopeResourcesViolation::outOfScopeResourceList))
            .setter(setter(Builder::outOfScopeResourceList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutOfScopeResourceList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD,
            OUT_OF_SCOPE_RESOURCE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String webACLArn;

    private final List<String> outOfScopeResourceList;

    private WebACLHasOutOfScopeResourcesViolation(BuilderImpl builder) {
        this.webACLArn = builder.webACLArn;
        this.outOfScopeResourceList = builder.outOfScopeResourceList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the web ACL.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the web ACL.
     */
    public final String webACLArn() {
        return webACLArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutOfScopeResourceList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOutOfScopeResourceList() {
        return outOfScopeResourceList != null && !(outOfScopeResourceList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Name (ARN) for the resources that are out of scope of the policy and are associated
     * with the web ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutOfScopeResourceList} method.
     * </p>
     * 
     * @return An array of Amazon Resource Name (ARN) for the resources that are out of scope of the policy and are
     *         associated with the web ACL.
     */
    public final List<String> outOfScopeResourceList() {
        return outOfScopeResourceList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webACLArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutOfScopeResourceList() ? outOfScopeResourceList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLHasOutOfScopeResourcesViolation)) {
            return false;
        }
        WebACLHasOutOfScopeResourcesViolation other = (WebACLHasOutOfScopeResourcesViolation) obj;
        return Objects.equals(webACLArn(), other.webACLArn()) && hasOutOfScopeResourceList() == other.hasOutOfScopeResourceList()
                && Objects.equals(outOfScopeResourceList(), other.outOfScopeResourceList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebACLHasOutOfScopeResourcesViolation").add("WebACLArn", webACLArn())
                .add("OutOfScopeResourceList", hasOutOfScopeResourceList() ? outOfScopeResourceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLArn":
            return Optional.ofNullable(clazz.cast(webACLArn()));
        case "OutOfScopeResourceList":
            return Optional.ofNullable(clazz.cast(outOfScopeResourceList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebACLHasOutOfScopeResourcesViolation, T> g) {
        return obj -> g.apply((WebACLHasOutOfScopeResourcesViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebACLHasOutOfScopeResourcesViolation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the web ACL.
         * </p>
         * 
         * @param webACLArn
         *        The Amazon Resource Name (ARN) of the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLArn(String webACLArn);

        /**
         * <p>
         * An array of Amazon Resource Name (ARN) for the resources that are out of scope of the policy and are
         * associated with the web ACL.
         * </p>
         * 
         * @param outOfScopeResourceList
         *        An array of Amazon Resource Name (ARN) for the resources that are out of scope of the policy and are
         *        associated with the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outOfScopeResourceList(Collection<String> outOfScopeResourceList);

        /**
         * <p>
         * An array of Amazon Resource Name (ARN) for the resources that are out of scope of the policy and are
         * associated with the web ACL.
         * </p>
         * 
         * @param outOfScopeResourceList
         *        An array of Amazon Resource Name (ARN) for the resources that are out of scope of the policy and are
         *        associated with the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outOfScopeResourceList(String... outOfScopeResourceList);
    }

    static final class BuilderImpl implements Builder {
        private String webACLArn;

        private List<String> outOfScopeResourceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLHasOutOfScopeResourcesViolation model) {
            webACLArn(model.webACLArn);
            outOfScopeResourceList(model.outOfScopeResourceList);
        }

        public final String getWebACLArn() {
            return webACLArn;
        }

        public final void setWebACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
        }

        @Override
        public final Builder webACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
            return this;
        }

        public final Collection<String> getOutOfScopeResourceList() {
            if (outOfScopeResourceList instanceof SdkAutoConstructList) {
                return null;
            }
            return outOfScopeResourceList;
        }

        public final void setOutOfScopeResourceList(Collection<String> outOfScopeResourceList) {
            this.outOfScopeResourceList = ResourceArnListCopier.copy(outOfScopeResourceList);
        }

        @Override
        public final Builder outOfScopeResourceList(Collection<String> outOfScopeResourceList) {
            this.outOfScopeResourceList = ResourceArnListCopier.copy(outOfScopeResourceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outOfScopeResourceList(String... outOfScopeResourceList) {
            outOfScopeResourceList(Arrays.asList(outOfScopeResourceList));
            return this;
        }

        @Override
        public WebACLHasOutOfScopeResourcesViolation build() {
            return new WebACLHasOutOfScopeResourcesViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
