/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.ActionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2CreateRouteAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2CreateRouteAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::description)).setter(EC2CreateRouteAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::destinationCidrBlock)).setter(EC2CreateRouteAction.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefixListId").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::destinationPrefixListId)).setter(EC2CreateRouteAction.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").build()}).build();
    private static final SdkField<String> DESTINATION_IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationIpv6CidrBlock").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::destinationIpv6CidrBlock)).setter(EC2CreateRouteAction.setter(Builder::destinationIpv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpv6CidrBlock").build()}).build();
    private static final SdkField<ActionTarget> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcEndpointId").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::vpcEndpointId)).setter(EC2CreateRouteAction.setter(Builder::vpcEndpointId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<ActionTarget> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GatewayId").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::gatewayId)).setter(EC2CreateRouteAction.setter(Builder::gatewayId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<ActionTarget> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteTableId").getter(EC2CreateRouteAction.getter(EC2CreateRouteAction::routeTableId)).setter(EC2CreateRouteAction.setter(Builder::routeTableId)).constructor(ActionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD, DESTINATION_IPV6_CIDR_BLOCK_FIELD, VPC_ENDPOINT_ID_FIELD, GATEWAY_ID_FIELD, ROUTE_TABLE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
            this.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
            this.put("DestinationIpv6CidrBlock", DESTINATION_IPV6_CIDR_BLOCK_FIELD);
            this.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
            this.put("GatewayId", GATEWAY_ID_FIELD);
            this.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String destinationCidrBlock;
    private final String destinationPrefixListId;
    private final String destinationIpv6CidrBlock;
    private final ActionTarget vpcEndpointId;
    private final ActionTarget gatewayId;
    private final ActionTarget routeTableId;

    private EC2CreateRouteAction(BuilderImpl builder) {
        this.description = builder.description;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.gatewayId = builder.gatewayId;
        this.routeTableId = builder.routeTableId;
    }

    public final String description() {
        return this.description;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    public final String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public final ActionTarget vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final ActionTarget gatewayId() {
        return this.gatewayId;
    }

    public final ActionTarget routeTableId() {
        return this.routeTableId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2CreateRouteAction)) {
            return false;
        }
        EC2CreateRouteAction other = (EC2CreateRouteAction)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId()) && Objects.equals(this.destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.routeTableId(), other.routeTableId());
    }

    public final String toString() {
        return ToString.builder((String)"EC2CreateRouteAction").add("Description", (Object)this.description()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).add("DestinationIpv6CidrBlock", (Object)this.destinationIpv6CidrBlock()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("GatewayId", (Object)this.gatewayId()).add("RouteTableId", (Object)this.routeTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EC2CreateRouteAction, T> g) {
        return obj -> g.apply((EC2CreateRouteAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String destinationCidrBlock;
        private String destinationPrefixListId;
        private String destinationIpv6CidrBlock;
        private ActionTarget vpcEndpointId;
        private ActionTarget gatewayId;
        private ActionTarget routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2CreateRouteAction model) {
            this.description(model.description);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationPrefixListId(model.destinationPrefixListId);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.vpcEndpointId(model.vpcEndpointId);
            this.gatewayId(model.gatewayId);
            this.routeTableId(model.routeTableId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final ActionTarget.Builder getVpcEndpointId() {
            return this.vpcEndpointId != null ? this.vpcEndpointId.toBuilder() : null;
        }

        public final void setVpcEndpointId(ActionTarget.BuilderImpl vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId != null ? vpcEndpointId.build() : null;
        }

        @Override
        public final Builder vpcEndpointId(ActionTarget vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final ActionTarget.Builder getGatewayId() {
            return this.gatewayId != null ? this.gatewayId.toBuilder() : null;
        }

        public final void setGatewayId(ActionTarget.BuilderImpl gatewayId) {
            this.gatewayId = gatewayId != null ? gatewayId.build() : null;
        }

        @Override
        public final Builder gatewayId(ActionTarget gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final ActionTarget.Builder getRouteTableId() {
            return this.routeTableId != null ? this.routeTableId.toBuilder() : null;
        }

        public final void setRouteTableId(ActionTarget.BuilderImpl routeTableId) {
            this.routeTableId = routeTableId != null ? routeTableId.build() : null;
        }

        @Override
        public final Builder routeTableId(ActionTarget routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public EC2CreateRouteAction build() {
            return new EC2CreateRouteAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2CreateRouteAction> {
        public Builder description(String var1);

        public Builder destinationCidrBlock(String var1);

        public Builder destinationPrefixListId(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder vpcEndpointId(ActionTarget var1);

        default public Builder vpcEndpointId(Consumer<ActionTarget.Builder> vpcEndpointId) {
            return this.vpcEndpointId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(vpcEndpointId)).build());
        }

        public Builder gatewayId(ActionTarget var1);

        default public Builder gatewayId(Consumer<ActionTarget.Builder> gatewayId) {
            return this.gatewayId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(gatewayId)).build());
        }

        public Builder routeTableId(ActionTarget var1);

        default public Builder routeTableId(Consumer<ActionTarget.Builder> routeTableId) {
            return this.routeTableId((ActionTarget)((ActionTarget.Builder)ActionTarget.builder().applyMutation(routeTableId)).build());
        }
    }
}

