/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the accounts within the administrator's Organizations organization that the specified Firewall Manager
 * administrator can apply policies to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountScope implements SdkPojo, Serializable, ToCopyableBuilder<AccountScope.Builder, AccountScope> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Accounts")
            .getter(getter(AccountScope::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALL_ACCOUNTS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllAccountsEnabled").getter(getter(AccountScope::allAccountsEnabled))
            .setter(setter(Builder::allAccountsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllAccountsEnabled").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_SPECIFIED_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeSpecifiedAccounts").getter(getter(AccountScope::excludeSpecifiedAccounts))
            .setter(setter(Builder::excludeSpecifiedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeSpecifiedAccounts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD,
            ALL_ACCOUNTS_ENABLED_FIELD, EXCLUDE_SPECIFIED_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accounts;

    private final Boolean allAccountsEnabled;

    private final Boolean excludeSpecifiedAccounts;

    private AccountScope(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.allAccountsEnabled = builder.allAccountsEnabled;
        this.excludeSpecifiedAccounts = builder.excludeSpecifiedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of accounts within the organization that the specified Firewall Manager administrator either can or
     * cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If
     * <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager administrator can
     * apply policies to all members of the organization except for the accounts in this list. If
     * <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager administrator can
     * only apply policies to the accounts in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return The list of accounts within the organization that the specified Firewall Manager administrator either can
     *         or cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If
     *         <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager
     *         administrator can apply policies to all members of the organization except for the accounts in this list.
     *         If <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager
     *         administrator can only apply policies to the accounts in this list.
     */
    public final List<String> accounts() {
        return accounts;
    }

    /**
     * <p>
     * A boolean value that indicates if the administrator can apply policies to all accounts within an organization. If
     * true, the administrator can apply policies to all accounts within the organization. You can either enable
     * management of all accounts through this operation, or you can specify a list of accounts to manage in
     * <code>AccountScope$Accounts</code>. You cannot specify both.
     * </p>
     * 
     * @return A boolean value that indicates if the administrator can apply policies to all accounts within an
     *         organization. If true, the administrator can apply policies to all accounts within the organization. You
     *         can either enable management of all accounts through this operation, or you can specify a list of
     *         accounts to manage in <code>AccountScope$Accounts</code>. You cannot specify both.
     */
    public final Boolean allAccountsEnabled() {
        return allAccountsEnabled;
    }

    /**
     * <p>
     * A boolean value that excludes the accounts in <code>AccountScope$Accounts</code> from the administrator's scope.
     * If true, the Firewall Manager administrator can apply policies to all members of the organization except for the
     * accounts listed in <code>AccountScope$Accounts</code>. You can either specify a list of accounts to exclude by
     * <code>AccountScope$Accounts</code>, or you can enable management of all accounts by
     * <code>AccountScope$AllAccountsEnabled</code>. You cannot specify both.
     * </p>
     * 
     * @return A boolean value that excludes the accounts in <code>AccountScope$Accounts</code> from the administrator's
     *         scope. If true, the Firewall Manager administrator can apply policies to all members of the organization
     *         except for the accounts listed in <code>AccountScope$Accounts</code>. You can either specify a list of
     *         accounts to exclude by <code>AccountScope$Accounts</code>, or you can enable management of all accounts
     *         by <code>AccountScope$AllAccountsEnabled</code>. You cannot specify both.
     */
    public final Boolean excludeSpecifiedAccounts() {
        return excludeSpecifiedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allAccountsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(excludeSpecifiedAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountScope)) {
            return false;
        }
        AccountScope other = (AccountScope) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && Objects.equals(allAccountsEnabled(), other.allAccountsEnabled())
                && Objects.equals(excludeSpecifiedAccounts(), other.excludeSpecifiedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountScope").add("Accounts", hasAccounts() ? accounts() : null)
                .add("AllAccountsEnabled", allAccountsEnabled()).add("ExcludeSpecifiedAccounts", excludeSpecifiedAccounts())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "AllAccountsEnabled":
            return Optional.ofNullable(clazz.cast(allAccountsEnabled()));
        case "ExcludeSpecifiedAccounts":
            return Optional.ofNullable(clazz.cast(excludeSpecifiedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accounts", ACCOUNTS_FIELD);
        map.put("AllAccountsEnabled", ALL_ACCOUNTS_ENABLED_FIELD);
        map.put("ExcludeSpecifiedAccounts", EXCLUDE_SPECIFIED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountScope, T> g) {
        return obj -> g.apply((AccountScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountScope> {
        /**
         * <p>
         * The list of accounts within the organization that the specified Firewall Manager administrator either can or
         * cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If
         * <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager administrator
         * can apply policies to all members of the organization except for the accounts in this list. If
         * <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager administrator
         * can only apply policies to the accounts in this list.
         * </p>
         * 
         * @param accounts
         *        The list of accounts within the organization that the specified Firewall Manager administrator either
         *        can or cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If
         *        <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager
         *        administrator can apply policies to all members of the organization except for the accounts in this
         *        list. If <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager
         *        administrator can only apply policies to the accounts in this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * The list of accounts within the organization that the specified Firewall Manager administrator either can or
         * cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If
         * <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager administrator
         * can apply policies to all members of the organization except for the accounts in this list. If
         * <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager administrator
         * can only apply policies to the accounts in this list.
         * </p>
         * 
         * @param accounts
         *        The list of accounts within the organization that the specified Firewall Manager administrator either
         *        can or cannot apply policies to, based on the value of <code>ExcludeSpecifiedAccounts</code>. If
         *        <code>ExcludeSpecifiedAccounts</code> is set to <code>true</code>, then the Firewall Manager
         *        administrator can apply policies to all members of the organization except for the accounts in this
         *        list. If <code>ExcludeSpecifiedAccounts</code> is set to <code>false</code>, then the Firewall Manager
         *        administrator can only apply policies to the accounts in this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * A boolean value that indicates if the administrator can apply policies to all accounts within an
         * organization. If true, the administrator can apply policies to all accounts within the organization. You can
         * either enable management of all accounts through this operation, or you can specify a list of accounts to
         * manage in <code>AccountScope$Accounts</code>. You cannot specify both.
         * </p>
         * 
         * @param allAccountsEnabled
         *        A boolean value that indicates if the administrator can apply policies to all accounts within an
         *        organization. If true, the administrator can apply policies to all accounts within the organization.
         *        You can either enable management of all accounts through this operation, or you can specify a list of
         *        accounts to manage in <code>AccountScope$Accounts</code>. You cannot specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allAccountsEnabled(Boolean allAccountsEnabled);

        /**
         * <p>
         * A boolean value that excludes the accounts in <code>AccountScope$Accounts</code> from the administrator's
         * scope. If true, the Firewall Manager administrator can apply policies to all members of the organization
         * except for the accounts listed in <code>AccountScope$Accounts</code>. You can either specify a list of
         * accounts to exclude by <code>AccountScope$Accounts</code>, or you can enable management of all accounts by
         * <code>AccountScope$AllAccountsEnabled</code>. You cannot specify both.
         * </p>
         * 
         * @param excludeSpecifiedAccounts
         *        A boolean value that excludes the accounts in <code>AccountScope$Accounts</code> from the
         *        administrator's scope. If true, the Firewall Manager administrator can apply policies to all members
         *        of the organization except for the accounts listed in <code>AccountScope$Accounts</code>. You can
         *        either specify a list of accounts to exclude by <code>AccountScope$Accounts</code>, or you can enable
         *        management of all accounts by <code>AccountScope$AllAccountsEnabled</code>. You cannot specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private Boolean allAccountsEnabled;

        private Boolean excludeSpecifiedAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountScope model) {
            accounts(model.accounts);
            allAccountsEnabled(model.allAccountsEnabled);
            excludeSpecifiedAccounts(model.excludeSpecifiedAccounts);
        }

        public final Collection<String> getAccounts() {
            if (accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return accounts;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountIdListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final Boolean getAllAccountsEnabled() {
            return allAccountsEnabled;
        }

        public final void setAllAccountsEnabled(Boolean allAccountsEnabled) {
            this.allAccountsEnabled = allAccountsEnabled;
        }

        @Override
        public final Builder allAccountsEnabled(Boolean allAccountsEnabled) {
            this.allAccountsEnabled = allAccountsEnabled;
            return this;
        }

        public final Boolean getExcludeSpecifiedAccounts() {
            return excludeSpecifiedAccounts;
        }

        public final void setExcludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts) {
            this.excludeSpecifiedAccounts = excludeSpecifiedAccounts;
        }

        @Override
        public final Builder excludeSpecifiedAccounts(Boolean excludeSpecifiedAccounts) {
            this.excludeSpecifiedAccounts = excludeSpecifiedAccounts;
            return this;
        }

        @Override
        public AccountScope build() {
            return new AccountScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
