/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains high level information about the Firewall Manager administrator account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminAccountSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AdminAccountSummary.Builder, AdminAccountSummary> {
    private static final SdkField<String> ADMIN_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminAccount").getter(getter(AdminAccountSummary::adminAccount)).setter(setter(Builder::adminAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccount").build()).build();

    private static final SdkField<Boolean> DEFAULT_ADMIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultAdmin").getter(getter(AdminAccountSummary::defaultAdmin)).setter(setter(Builder::defaultAdmin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAdmin").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AdminAccountSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_FIELD,
            DEFAULT_ADMIN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adminAccount;

    private final Boolean defaultAdmin;

    private final String status;

    private AdminAccountSummary(BuilderImpl builder) {
        this.adminAccount = builder.adminAccount;
        this.defaultAdmin = builder.defaultAdmin;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the Firewall Manager administrator's account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the Firewall Manager administrator's account.
     */
    public final String adminAccount() {
        return adminAccount;
    }

    /**
     * <p>
     * A boolean value that indicates if the administrator is the default administrator. If true, then this is the
     * default administrator account. The default administrator can manage third-party firewalls and has full
     * administrative scope. There is only one default administrator account per organization. For information about
     * Firewall Manager default administrator accounts, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall Manager
     * administrators</a> in the <i>Firewall Manager Developer Guide</i>.
     * </p>
     * 
     * @return A boolean value that indicates if the administrator is the default administrator. If true, then this is
     *         the default administrator account. The default administrator can manage third-party firewalls and has
     *         full administrative scope. There is only one default administrator account per organization. For
     *         information about Firewall Manager default administrator accounts, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall
     *         Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.
     */
    public final Boolean defaultAdmin() {
        return defaultAdmin;
    }

    /**
     * <p>
     * The current status of the request to onboard a member account as an Firewall Manager administrator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the request to onboard a member account as an Firewall Manager administrator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     *         administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     * @see OrganizationStatus
     */
    public final OrganizationStatus status() {
        return OrganizationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the request to onboard a member account as an Firewall Manager administrator.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OrganizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the request to onboard a member account as an Firewall Manager administrator.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
     *         administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
     *         </p>
     *         </li>
     * @see OrganizationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminAccount());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAdmin());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminAccountSummary)) {
            return false;
        }
        AdminAccountSummary other = (AdminAccountSummary) obj;
        return Objects.equals(adminAccount(), other.adminAccount()) && Objects.equals(defaultAdmin(), other.defaultAdmin())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminAccountSummary").add("AdminAccount", adminAccount()).add("DefaultAdmin", defaultAdmin())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminAccount":
            return Optional.ofNullable(clazz.cast(adminAccount()));
        case "DefaultAdmin":
            return Optional.ofNullable(clazz.cast(defaultAdmin()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdminAccount", ADMIN_ACCOUNT_FIELD);
        map.put("DefaultAdmin", DEFAULT_ADMIN_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdminAccountSummary, T> g) {
        return obj -> g.apply((AdminAccountSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdminAccountSummary> {
        /**
         * <p>
         * The Amazon Web Services account ID of the Firewall Manager administrator's account.
         * </p>
         * 
         * @param adminAccount
         *        The Amazon Web Services account ID of the Firewall Manager administrator's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccount(String adminAccount);

        /**
         * <p>
         * A boolean value that indicates if the administrator is the default administrator. If true, then this is the
         * default administrator account. The default administrator can manage third-party firewalls and has full
         * administrative scope. There is only one default administrator account per organization. For information about
         * Firewall Manager default administrator accounts, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall
         * Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.
         * </p>
         * 
         * @param defaultAdmin
         *        A boolean value that indicates if the administrator is the default administrator. If true, then this
         *        is the default administrator account. The default administrator can manage third-party firewalls and
         *        has full administrative scope. There is only one default administrator account per organization. For
         *        information about Firewall Manager default administrator accounts, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall
         *        Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAdmin(Boolean defaultAdmin);

        /**
         * <p>
         * The current status of the request to onboard a member account as an Firewall Manager administrator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the request to onboard a member account as an Firewall Manager
         *        administrator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         *        administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         * @see OrganizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the request to onboard a member account as an Firewall Manager administrator.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         * administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the request to onboard a member account as an Firewall Manager
         *        administrator.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONBOARDING</code> - The account is onboarding to Firewall Manager as an administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONBOARDING_COMPLETE</code> - Firewall Manager The account is onboarded to Firewall Manager as an
         *        administrator, and can perform actions on the resources defined in their <a>AdminScope</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING</code> - The account is being removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING_COMPLETE</code> - The account has been removed as an Firewall Manager administrator.
         *        </p>
         *        </li>
         * @see OrganizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationStatus
         */
        Builder status(OrganizationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String adminAccount;

        private Boolean defaultAdmin;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminAccountSummary model) {
            adminAccount(model.adminAccount);
            defaultAdmin(model.defaultAdmin);
            status(model.status);
        }

        public final String getAdminAccount() {
            return adminAccount;
        }

        public final void setAdminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
        }

        @Override
        public final Builder adminAccount(String adminAccount) {
            this.adminAccount = adminAccount;
            return this;
        }

        public final Boolean getDefaultAdmin() {
            return defaultAdmin;
        }

        public final void setDefaultAdmin(Boolean defaultAdmin) {
            this.defaultAdmin = defaultAdmin;
        }

        @Override
        public final Builder defaultAdmin(Boolean defaultAdmin) {
            this.defaultAdmin = defaultAdmin;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AdminAccountSummary build() {
            return new AdminAccountSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
