/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the resources that the Firewall Manager administrator can manage. For more information about administrative
 * scope, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-administrators.html">Managing Firewall
 * Manager administrators</a> in the <i>Firewall Manager Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminScope implements SdkPojo, Serializable, ToCopyableBuilder<AdminScope.Builder, AdminScope> {
    private static final SdkField<AccountScope> ACCOUNT_SCOPE_FIELD = SdkField.<AccountScope> builder(MarshallingType.SDK_POJO)
            .memberName("AccountScope").getter(getter(AdminScope::accountScope)).setter(setter(Builder::accountScope))
            .constructor(AccountScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()).build();

    private static final SdkField<OrganizationalUnitScope> ORGANIZATIONAL_UNIT_SCOPE_FIELD = SdkField
            .<OrganizationalUnitScope> builder(MarshallingType.SDK_POJO).memberName("OrganizationalUnitScope")
            .getter(getter(AdminScope::organizationalUnitScope)).setter(setter(Builder::organizationalUnitScope))
            .constructor(OrganizationalUnitScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitScope").build())
            .build();

    private static final SdkField<RegionScope> REGION_SCOPE_FIELD = SdkField.<RegionScope> builder(MarshallingType.SDK_POJO)
            .memberName("RegionScope").getter(getter(AdminScope::regionScope)).setter(setter(Builder::regionScope))
            .constructor(RegionScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionScope").build()).build();

    private static final SdkField<PolicyTypeScope> POLICY_TYPE_SCOPE_FIELD = SdkField
            .<PolicyTypeScope> builder(MarshallingType.SDK_POJO).memberName("PolicyTypeScope")
            .getter(getter(AdminScope::policyTypeScope)).setter(setter(Builder::policyTypeScope))
            .constructor(PolicyTypeScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            ORGANIZATIONAL_UNIT_SCOPE_FIELD, REGION_SCOPE_FIELD, POLICY_TYPE_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccountScope accountScope;

    private final OrganizationalUnitScope organizationalUnitScope;

    private final RegionScope regionScope;

    private final PolicyTypeScope policyTypeScope;

    private AdminScope(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.organizationalUnitScope = builder.organizationalUnitScope;
        this.regionScope = builder.regionScope;
        this.policyTypeScope = builder.policyTypeScope;
    }

    /**
     * <p>
     * Defines the accounts that the specified Firewall Manager administrator can apply policies to.
     * </p>
     * 
     * @return Defines the accounts that the specified Firewall Manager administrator can apply policies to.
     */
    public final AccountScope accountScope() {
        return accountScope;
    }

    /**
     * <p>
     * Defines the Organizations organizational units that the specified Firewall Manager administrator can apply
     * policies to. For more information about OUs in Organizations, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing organizational
     * units (OUs) </a> in the <i>Organizations User Guide</i>.
     * </p>
     * 
     * @return Defines the Organizations organizational units that the specified Firewall Manager administrator can
     *         apply policies to. For more information about OUs in Organizations, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing
     *         organizational units (OUs) </a> in the <i>Organizations User Guide</i>.
     */
    public final OrganizationalUnitScope organizationalUnitScope() {
        return organizationalUnitScope;
    }

    /**
     * <p>
     * Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions in.
     * </p>
     * 
     * @return Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can perform
     *         actions in.
     */
    public final RegionScope regionScope() {
        return regionScope;
    }

    /**
     * <p>
     * Defines the Firewall Manager policy types that the specified Firewall Manager administrator can create and
     * manage.
     * </p>
     * 
     * @return Defines the Firewall Manager policy types that the specified Firewall Manager administrator can create
     *         and manage.
     */
    public final PolicyTypeScope policyTypeScope() {
        return policyTypeScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScope());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitScope());
        hashCode = 31 * hashCode + Objects.hashCode(regionScope());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminScope)) {
            return false;
        }
        AdminScope other = (AdminScope) obj;
        return Objects.equals(accountScope(), other.accountScope())
                && Objects.equals(organizationalUnitScope(), other.organizationalUnitScope())
                && Objects.equals(regionScope(), other.regionScope())
                && Objects.equals(policyTypeScope(), other.policyTypeScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminScope").add("AccountScope", accountScope())
                .add("OrganizationalUnitScope", organizationalUnitScope()).add("RegionScope", regionScope())
                .add("PolicyTypeScope", policyTypeScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountScope":
            return Optional.ofNullable(clazz.cast(accountScope()));
        case "OrganizationalUnitScope":
            return Optional.ofNullable(clazz.cast(organizationalUnitScope()));
        case "RegionScope":
            return Optional.ofNullable(clazz.cast(regionScope()));
        case "PolicyTypeScope":
            return Optional.ofNullable(clazz.cast(policyTypeScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountScope", ACCOUNT_SCOPE_FIELD);
        map.put("OrganizationalUnitScope", ORGANIZATIONAL_UNIT_SCOPE_FIELD);
        map.put("RegionScope", REGION_SCOPE_FIELD);
        map.put("PolicyTypeScope", POLICY_TYPE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdminScope, T> g) {
        return obj -> g.apply((AdminScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdminScope> {
        /**
         * <p>
         * Defines the accounts that the specified Firewall Manager administrator can apply policies to.
         * </p>
         * 
         * @param accountScope
         *        Defines the accounts that the specified Firewall Manager administrator can apply policies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountScope(AccountScope accountScope);

        /**
         * <p>
         * Defines the accounts that the specified Firewall Manager administrator can apply policies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountScope.Builder} avoiding the need
         * to create one manually via {@link AccountScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountScope.Builder#build()} is called immediately and its
         * result is passed to {@link #accountScope(AccountScope)}.
         * 
         * @param accountScope
         *        a consumer that will call methods on {@link AccountScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountScope(AccountScope)
         */
        default Builder accountScope(Consumer<AccountScope.Builder> accountScope) {
            return accountScope(AccountScope.builder().applyMutation(accountScope).build());
        }

        /**
         * <p>
         * Defines the Organizations organizational units that the specified Firewall Manager administrator can apply
         * policies to. For more information about OUs in Organizations, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing
         * organizational units (OUs) </a> in the <i>Organizations User Guide</i>.
         * </p>
         * 
         * @param organizationalUnitScope
         *        Defines the Organizations organizational units that the specified Firewall Manager administrator can
         *        apply policies to. For more information about OUs in Organizations, see <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing
         *        organizational units (OUs) </a> in the <i>Organizations User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitScope(OrganizationalUnitScope organizationalUnitScope);

        /**
         * <p>
         * Defines the Organizations organizational units that the specified Firewall Manager administrator can apply
         * policies to. For more information about OUs in Organizations, see <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing
         * organizational units (OUs) </a> in the <i>Organizations User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationalUnitScope.Builder} avoiding
         * the need to create one manually via {@link OrganizationalUnitScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationalUnitScope.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationalUnitScope(OrganizationalUnitScope)}.
         * 
         * @param organizationalUnitScope
         *        a consumer that will call methods on {@link OrganizationalUnitScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationalUnitScope(OrganizationalUnitScope)
         */
        default Builder organizationalUnitScope(Consumer<OrganizationalUnitScope.Builder> organizationalUnitScope) {
            return organizationalUnitScope(OrganizationalUnitScope.builder().applyMutation(organizationalUnitScope).build());
        }

        /**
         * <p>
         * Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions
         * in.
         * </p>
         * 
         * @param regionScope
         *        Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can perform
         *        actions in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionScope(RegionScope regionScope);

        /**
         * <p>
         * Defines the Amazon Web Services Regions that the specified Firewall Manager administrator can perform actions
         * in.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegionScope.Builder} avoiding the need to
         * create one manually via {@link RegionScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegionScope.Builder#build()} is called immediately and its result
         * is passed to {@link #regionScope(RegionScope)}.
         * 
         * @param regionScope
         *        a consumer that will call methods on {@link RegionScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionScope(RegionScope)
         */
        default Builder regionScope(Consumer<RegionScope.Builder> regionScope) {
            return regionScope(RegionScope.builder().applyMutation(regionScope).build());
        }

        /**
         * <p>
         * Defines the Firewall Manager policy types that the specified Firewall Manager administrator can create and
         * manage.
         * </p>
         * 
         * @param policyTypeScope
         *        Defines the Firewall Manager policy types that the specified Firewall Manager administrator can create
         *        and manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeScope(PolicyTypeScope policyTypeScope);

        /**
         * <p>
         * Defines the Firewall Manager policy types that the specified Firewall Manager administrator can create and
         * manage.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyTypeScope.Builder} avoiding the
         * need to create one manually via {@link PolicyTypeScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyTypeScope.Builder#build()} is called immediately and its
         * result is passed to {@link #policyTypeScope(PolicyTypeScope)}.
         * 
         * @param policyTypeScope
         *        a consumer that will call methods on {@link PolicyTypeScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyTypeScope(PolicyTypeScope)
         */
        default Builder policyTypeScope(Consumer<PolicyTypeScope.Builder> policyTypeScope) {
            return policyTypeScope(PolicyTypeScope.builder().applyMutation(policyTypeScope).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountScope accountScope;

        private OrganizationalUnitScope organizationalUnitScope;

        private RegionScope regionScope;

        private PolicyTypeScope policyTypeScope;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminScope model) {
            accountScope(model.accountScope);
            organizationalUnitScope(model.organizationalUnitScope);
            regionScope(model.regionScope);
            policyTypeScope(model.policyTypeScope);
        }

        public final AccountScope.Builder getAccountScope() {
            return accountScope != null ? accountScope.toBuilder() : null;
        }

        public final void setAccountScope(AccountScope.BuilderImpl accountScope) {
            this.accountScope = accountScope != null ? accountScope.build() : null;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        public final OrganizationalUnitScope.Builder getOrganizationalUnitScope() {
            return organizationalUnitScope != null ? organizationalUnitScope.toBuilder() : null;
        }

        public final void setOrganizationalUnitScope(OrganizationalUnitScope.BuilderImpl organizationalUnitScope) {
            this.organizationalUnitScope = organizationalUnitScope != null ? organizationalUnitScope.build() : null;
        }

        @Override
        public final Builder organizationalUnitScope(OrganizationalUnitScope organizationalUnitScope) {
            this.organizationalUnitScope = organizationalUnitScope;
            return this;
        }

        public final RegionScope.Builder getRegionScope() {
            return regionScope != null ? regionScope.toBuilder() : null;
        }

        public final void setRegionScope(RegionScope.BuilderImpl regionScope) {
            this.regionScope = regionScope != null ? regionScope.build() : null;
        }

        @Override
        public final Builder regionScope(RegionScope regionScope) {
            this.regionScope = regionScope;
            return this;
        }

        public final PolicyTypeScope.Builder getPolicyTypeScope() {
            return policyTypeScope != null ? policyTypeScope.toBuilder() : null;
        }

        public final void setPolicyTypeScope(PolicyTypeScope.BuilderImpl policyTypeScope) {
            this.policyTypeScope = policyTypeScope != null ? policyTypeScope.build() : null;
        }

        @Override
        public final Builder policyTypeScope(PolicyTypeScope policyTypeScope) {
            this.policyTypeScope = policyTypeScope;
            return this;
        }

        @Override
        public AdminScope build() {
            return new AdminScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
