/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppsListRequest extends FmsRequest implements
        ToCopyableBuilder<DeleteAppsListRequest.Builder, DeleteAppsListRequest> {
    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListId")
            .getter(getter(DeleteAppsListRequest::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String listId;

    private DeleteAppsListRequest(BuilderImpl builder) {
        super(builder);
        this.listId = builder.listId;
    }

    /**
     * <p>
     * The ID of the applications list that you want to delete. You can retrieve this ID from <code>PutAppsList</code>,
     * <code>ListAppsLists</code>, and <code>GetAppsList</code>.
     * </p>
     * 
     * @return The ID of the applications list that you want to delete. You can retrieve this ID from
     *         <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.
     */
    public final String listId() {
        return listId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppsListRequest)) {
            return false;
        }
        DeleteAppsListRequest other = (DeleteAppsListRequest) obj;
        return Objects.equals(listId(), other.listId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAppsListRequest").add("ListId", listId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ListId", LIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppsListRequest, T> g) {
        return obj -> g.apply((DeleteAppsListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAppsListRequest> {
        /**
         * <p>
         * The ID of the applications list that you want to delete. You can retrieve this ID from
         * <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.
         * </p>
         * 
         * @param listId
         *        The ID of the applications list that you want to delete. You can retrieve this ID from
         *        <code>PutAppsList</code>, <code>ListAppsLists</code>, and <code>GetAppsList</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String listId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppsListRequest model) {
            super(model);
            listId(model.listId);
        }

        public final String getListId() {
            return listId;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppsListRequest build() {
            return new DeleteAppsListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
