/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action of associating an EC2 resource, such as a subnet or internet gateway, with a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2AssociateRouteTableAction implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2AssociateRouteTableAction.Builder, EC2AssociateRouteTableAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EC2AssociateRouteTableAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ActionTarget> ROUTE_TABLE_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("RouteTableId").getter(getter(EC2AssociateRouteTableAction::routeTableId))
            .setter(setter(Builder::routeTableId)).constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<ActionTarget> SUBNET_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("SubnetId").getter(getter(EC2AssociateRouteTableAction::subnetId)).setter(setter(Builder::subnetId))
            .constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<ActionTarget> GATEWAY_ID_FIELD = SdkField.<ActionTarget> builder(MarshallingType.SDK_POJO)
            .memberName("GatewayId").getter(getter(EC2AssociateRouteTableAction::gatewayId)).setter(setter(Builder::gatewayId))
            .constructor(ActionTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ROUTE_TABLE_ID_FIELD, SUBNET_ID_FIELD, GATEWAY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTarget routeTableId;

    private final ActionTarget subnetId;

    private final ActionTarget gatewayId;

    private EC2AssociateRouteTableAction(BuilderImpl builder) {
        this.description = builder.description;
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
        this.gatewayId = builder.gatewayId;
    }

    /**
     * <p>
     * A description of the EC2 route table that is associated with the remediation action.
     * </p>
     * 
     * @return A description of the EC2 route table that is associated with the remediation action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the EC2 route table that is associated with the remediation action.
     * </p>
     * 
     * @return The ID of the EC2 route table that is associated with the remediation action.
     */
    public final ActionTarget routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The ID of the subnet for the EC2 route table that is associated with the remediation action.
     * </p>
     * 
     * @return The ID of the subnet for the EC2 route table that is associated with the remediation action.
     */
    public final ActionTarget subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.
     * </p>
     * 
     * @return The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.
     */
    public final ActionTarget gatewayId() {
        return gatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2AssociateRouteTableAction)) {
            return false;
        }
        EC2AssociateRouteTableAction other = (EC2AssociateRouteTableAction) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(routeTableId(), other.routeTableId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(gatewayId(), other.gatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2AssociateRouteTableAction").add("Description", description())
                .add("RouteTableId", routeTableId()).add("SubnetId", subnetId()).add("GatewayId", gatewayId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("GatewayId", GATEWAY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2AssociateRouteTableAction, T> g) {
        return obj -> g.apply((EC2AssociateRouteTableAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2AssociateRouteTableAction> {
        /**
         * <p>
         * A description of the EC2 route table that is associated with the remediation action.
         * </p>
         * 
         * @param description
         *        A description of the EC2 route table that is associated with the remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the EC2 route table that is associated with the remediation action.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the EC2 route table that is associated with the remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(ActionTarget routeTableId);

        /**
         * <p>
         * The ID of the EC2 route table that is associated with the remediation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #routeTableId(ActionTarget)}.
         * 
         * @param routeTableId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeTableId(ActionTarget)
         */
        default Builder routeTableId(Consumer<ActionTarget.Builder> routeTableId) {
            return routeTableId(ActionTarget.builder().applyMutation(routeTableId).build());
        }

        /**
         * <p>
         * The ID of the subnet for the EC2 route table that is associated with the remediation action.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet for the EC2 route table that is associated with the remediation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(ActionTarget subnetId);

        /**
         * <p>
         * The ID of the subnet for the EC2 route table that is associated with the remediation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #subnetId(ActionTarget)}.
         * 
         * @param subnetId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetId(ActionTarget)
         */
        default Builder subnetId(Consumer<ActionTarget.Builder> subnetId) {
            return subnetId(ActionTarget.builder().applyMutation(subnetId).build());
        }

        /**
         * <p>
         * The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway to be used with the EC2 route table that is associated with the remediation
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(ActionTarget gatewayId);

        /**
         * <p>
         * The ID of the gateway to be used with the EC2 route table that is associated with the remediation action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTarget.Builder} avoiding the need
         * to create one manually via {@link ActionTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #gatewayId(ActionTarget)}.
         * 
         * @param gatewayId
         *        a consumer that will call methods on {@link ActionTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayId(ActionTarget)
         */
        default Builder gatewayId(Consumer<ActionTarget.Builder> gatewayId) {
            return gatewayId(ActionTarget.builder().applyMutation(gatewayId).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTarget routeTableId;

        private ActionTarget subnetId;

        private ActionTarget gatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2AssociateRouteTableAction model) {
            description(model.description);
            routeTableId(model.routeTableId);
            subnetId(model.subnetId);
            gatewayId(model.gatewayId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTarget.Builder getRouteTableId() {
            return routeTableId != null ? routeTableId.toBuilder() : null;
        }

        public final void setRouteTableId(ActionTarget.BuilderImpl routeTableId) {
            this.routeTableId = routeTableId != null ? routeTableId.build() : null;
        }

        @Override
        public final Builder routeTableId(ActionTarget routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final ActionTarget.Builder getSubnetId() {
            return subnetId != null ? subnetId.toBuilder() : null;
        }

        public final void setSubnetId(ActionTarget.BuilderImpl subnetId) {
            this.subnetId = subnetId != null ? subnetId.build() : null;
        }

        @Override
        public final Builder subnetId(ActionTarget subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final ActionTarget.Builder getGatewayId() {
            return gatewayId != null ? gatewayId.toBuilder() : null;
        }

        public final void setGatewayId(ActionTarget.BuilderImpl gatewayId) {
            this.gatewayId = gatewayId != null ? gatewayId.build() : null;
        }

        @Override
        public final Builder gatewayId(ActionTarget gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        @Override
        public EC2AssociateRouteTableAction build() {
            return new EC2AssociateRouteTableAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
