/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The violation details for a firewall subnet's VPC endpoint that's deleted or missing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallSubnetMissingVPCEndpointViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallSubnetMissingVPCEndpointViolation.Builder, FirewallSubnetMissingVPCEndpointViolation> {
    private static final SdkField<String> FIREWALL_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallSubnetId").getter(getter(FirewallSubnetMissingVPCEndpointViolation::firewallSubnetId))
            .setter(setter(Builder::firewallSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(FirewallSubnetMissingVPCEndpointViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetAvailabilityZone")
            .getter(getter(FirewallSubnetMissingVPCEndpointViolation::subnetAvailabilityZone))
            .setter(setter(Builder::subnetAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build())
            .build();

    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetAvailabilityZoneId")
            .getter(getter(FirewallSubnetMissingVPCEndpointViolation::subnetAvailabilityZoneId))
            .setter(setter(Builder::subnetAvailabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZoneId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_SUBNET_ID_FIELD,
            VPC_ID_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, SUBNET_AVAILABILITY_ZONE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String firewallSubnetId;

    private final String vpcId;

    private final String subnetAvailabilityZone;

    private final String subnetAvailabilityZoneId;

    private FirewallSubnetMissingVPCEndpointViolation(BuilderImpl builder) {
        this.firewallSubnetId = builder.firewallSubnetId;
        this.vpcId = builder.vpcId;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetAvailabilityZoneId = builder.subnetAvailabilityZoneId;
    }

    /**
     * <p>
     * The ID of the firewall that this VPC endpoint is associated with.
     * </p>
     * 
     * @return The ID of the firewall that this VPC endpoint is associated with.
     */
    public final String firewallSubnetId() {
        return firewallSubnetId;
    }

    /**
     * <p>
     * The resource ID of the VPC associated with the deleted VPC subnet.
     * </p>
     * 
     * @return The resource ID of the VPC associated with the deleted VPC subnet.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the Availability Zone of the deleted VPC subnet.
     * </p>
     * 
     * @return The name of the Availability Zone of the deleted VPC subnet.
     */
    public final String subnetAvailabilityZone() {
        return subnetAvailabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone of the deleted VPC subnet.
     * </p>
     * 
     * @return The ID of the Availability Zone of the deleted VPC subnet.
     */
    public final String subnetAvailabilityZoneId() {
        return subnetAvailabilityZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZoneId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallSubnetMissingVPCEndpointViolation)) {
            return false;
        }
        FirewallSubnetMissingVPCEndpointViolation other = (FirewallSubnetMissingVPCEndpointViolation) obj;
        return Objects.equals(firewallSubnetId(), other.firewallSubnetId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(subnetAvailabilityZone(), other.subnetAvailabilityZone())
                && Objects.equals(subnetAvailabilityZoneId(), other.subnetAvailabilityZoneId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallSubnetMissingVPCEndpointViolation").add("FirewallSubnetId", firewallSubnetId())
                .add("VpcId", vpcId()).add("SubnetAvailabilityZone", subnetAvailabilityZone())
                .add("SubnetAvailabilityZoneId", subnetAvailabilityZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallSubnetId":
            return Optional.ofNullable(clazz.cast(firewallSubnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetAvailabilityZone":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZone()));
        case "SubnetAvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZoneId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallSubnetId", FIREWALL_SUBNET_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("SubnetAvailabilityZoneId", SUBNET_AVAILABILITY_ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallSubnetMissingVPCEndpointViolation, T> g) {
        return obj -> g.apply((FirewallSubnetMissingVPCEndpointViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallSubnetMissingVPCEndpointViolation> {
        /**
         * <p>
         * The ID of the firewall that this VPC endpoint is associated with.
         * </p>
         * 
         * @param firewallSubnetId
         *        The ID of the firewall that this VPC endpoint is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallSubnetId(String firewallSubnetId);

        /**
         * <p>
         * The resource ID of the VPC associated with the deleted VPC subnet.
         * </p>
         * 
         * @param vpcId
         *        The resource ID of the VPC associated with the deleted VPC subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the Availability Zone of the deleted VPC subnet.
         * </p>
         * 
         * @param subnetAvailabilityZone
         *        The name of the Availability Zone of the deleted VPC subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZone(String subnetAvailabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone of the deleted VPC subnet.
         * </p>
         * 
         * @param subnetAvailabilityZoneId
         *        The ID of the Availability Zone of the deleted VPC subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZoneId(String subnetAvailabilityZoneId);
    }

    static final class BuilderImpl implements Builder {
        private String firewallSubnetId;

        private String vpcId;

        private String subnetAvailabilityZone;

        private String subnetAvailabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallSubnetMissingVPCEndpointViolation model) {
            firewallSubnetId(model.firewallSubnetId);
            vpcId(model.vpcId);
            subnetAvailabilityZone(model.subnetAvailabilityZone);
            subnetAvailabilityZoneId(model.subnetAvailabilityZoneId);
        }

        public final String getFirewallSubnetId() {
            return firewallSubnetId;
        }

        public final void setFirewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
        }

        @Override
        public final Builder firewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getSubnetAvailabilityZoneId() {
            return subnetAvailabilityZoneId;
        }

        public final void setSubnetAvailabilityZoneId(String subnetAvailabilityZoneId) {
            this.subnetAvailabilityZoneId = subnetAvailabilityZoneId;
        }

        @Override
        public final Builder subnetAvailabilityZoneId(String subnetAvailabilityZoneId) {
            this.subnetAvailabilityZoneId = subnetAvailabilityZoneId;
            return this;
        }

        @Override
        public FirewallSubnetMissingVPCEndpointViolation build() {
            return new FirewallSubnetMissingVPCEndpointViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
