/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAppsListResponse extends FmsResponse implements
        ToCopyableBuilder<GetAppsListResponse.Builder, GetAppsListResponse> {
    private static final SdkField<AppsListData> APPS_LIST_FIELD = SdkField.<AppsListData> builder(MarshallingType.SDK_POJO)
            .memberName("AppsList").getter(getter(GetAppsListResponse::appsList)).setter(setter(Builder::appsList))
            .constructor(AppsListData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsList").build()).build();

    private static final SdkField<String> APPS_LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppsListArn").getter(getter(GetAppsListResponse::appsListArn)).setter(setter(Builder::appsListArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsListArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_LIST_FIELD,
            APPS_LIST_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppsListData appsList;

    private final String appsListArn;

    private GetAppsListResponse(BuilderImpl builder) {
        super(builder);
        this.appsList = builder.appsList;
        this.appsListArn = builder.appsListArn;
    }

    /**
     * <p>
     * Information about the specified Firewall Manager applications list.
     * </p>
     * 
     * @return Information about the specified Firewall Manager applications list.
     */
    public final AppsListData appsList() {
        return appsList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the applications list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the applications list.
     */
    public final String appsListArn() {
        return appsListArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appsList());
        hashCode = 31 * hashCode + Objects.hashCode(appsListArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppsListResponse)) {
            return false;
        }
        GetAppsListResponse other = (GetAppsListResponse) obj;
        return Objects.equals(appsList(), other.appsList()) && Objects.equals(appsListArn(), other.appsListArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAppsListResponse").add("AppsList", appsList()).add("AppsListArn", appsListArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppsList":
            return Optional.ofNullable(clazz.cast(appsList()));
        case "AppsListArn":
            return Optional.ofNullable(clazz.cast(appsListArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppsList", APPS_LIST_FIELD);
        map.put("AppsListArn", APPS_LIST_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAppsListResponse, T> g) {
        return obj -> g.apply((GetAppsListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAppsListResponse> {
        /**
         * <p>
         * Information about the specified Firewall Manager applications list.
         * </p>
         * 
         * @param appsList
         *        Information about the specified Firewall Manager applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsList(AppsListData appsList);

        /**
         * <p>
         * Information about the specified Firewall Manager applications list.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppsListData.Builder} avoiding the need
         * to create one manually via {@link AppsListData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppsListData.Builder#build()} is called immediately and its
         * result is passed to {@link #appsList(AppsListData)}.
         * 
         * @param appsList
         *        a consumer that will call methods on {@link AppsListData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appsList(AppsListData)
         */
        default Builder appsList(Consumer<AppsListData.Builder> appsList) {
            return appsList(AppsListData.builder().applyMutation(appsList).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the applications list.
         * </p>
         * 
         * @param appsListArn
         *        The Amazon Resource Name (ARN) of the applications list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsListArn(String appsListArn);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private AppsListData appsList;

        private String appsListArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppsListResponse model) {
            super(model);
            appsList(model.appsList);
            appsListArn(model.appsListArn);
        }

        public final AppsListData.Builder getAppsList() {
            return appsList != null ? appsList.toBuilder() : null;
        }

        public final void setAppsList(AppsListData.BuilderImpl appsList) {
            this.appsList = appsList != null ? appsList.build() : null;
        }

        @Override
        public final Builder appsList(AppsListData appsList) {
            this.appsList = appsList;
            return this;
        }

        public final String getAppsListArn() {
            return appsListArn;
        }

        public final void setAppsListArn(String appsListArn) {
            this.appsListArn = appsListArn;
        }

        @Override
        public final Builder appsListArn(String appsListArn) {
            this.appsListArn = appsListArn;
            return this;
        }

        @Override
        public GetAppsListResponse build() {
            return new GetAppsListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
