/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDiscoveredResourcesRequest extends FmsRequest implements
        ToCopyableBuilder<ListDiscoveredResourcesRequest.Builder, ListDiscoveredResourcesRequest> {
    private static final SdkField<List<String>> MEMBER_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MemberAccountIds")
            .getter(getter(ListDiscoveredResourcesRequest::memberAccountIds))
            .setter(setter(Builder::memberAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListDiscoveredResourcesRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDiscoveredResourcesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDiscoveredResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_IDS_FIELD,
            RESOURCE_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> memberAccountIds;

    private final String resourceType;

    private final Integer maxResults;

    private final String nextToken;

    private ListDiscoveredResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountIds = builder.memberAccountIds;
        this.resourceType = builder.resourceType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberAccountIds() {
        return memberAccountIds != null && !(memberAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account IDs to discover resources in. Only one account is supported per request. The
     * account must be a member of your organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAccountIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account IDs to discover resources in. Only one account is supported per request.
     *         The account must be a member of your organization.
     */
    public final List<String> memberAccountIds() {
        return memberAccountIds;
    }

    /**
     * <p>
     * The type of resources to discover.
     * </p>
     * 
     * @return The type of resources to discover.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The maximum number of objects that you want Firewall Manager to return for this request. If more objects are
     * available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a
     * subsequent call to get the next batch of objects.
     * </p>
     * 
     * @return The maximum number of objects that you want Firewall Manager to return for this request. If more objects
     *         are available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use
     *         in a subsequent call to get the next batch of objects.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Firewall Manager returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberAccountIds() ? memberAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest) obj;
        return hasMemberAccountIds() == other.hasMemberAccountIds()
                && Objects.equals(memberAccountIds(), other.memberAccountIds())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDiscoveredResourcesRequest")
                .add("MemberAccountIds", hasMemberAccountIds() ? memberAccountIds() : null).add("ResourceType", resourceType())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberAccountIds":
            return Optional.ofNullable(clazz.cast(memberAccountIds()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MemberAccountIds", MEMBER_ACCOUNT_IDS_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoveredResourcesRequest, T> g) {
        return obj -> g.apply((ListDiscoveredResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDiscoveredResourcesRequest> {
        /**
         * <p>
         * The Amazon Web Services account IDs to discover resources in. Only one account is supported per request. The
         * account must be a member of your organization.
         * </p>
         * 
         * @param memberAccountIds
         *        The Amazon Web Services account IDs to discover resources in. Only one account is supported per
         *        request. The account must be a member of your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountIds(Collection<String> memberAccountIds);

        /**
         * <p>
         * The Amazon Web Services account IDs to discover resources in. Only one account is supported per request. The
         * account must be a member of your organization.
         * </p>
         * 
         * @param memberAccountIds
         *        The Amazon Web Services account IDs to discover resources in. Only one account is supported per
         *        request. The account must be a member of your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountIds(String... memberAccountIds);

        /**
         * <p>
         * The type of resources to discover.
         * </p>
         * 
         * @param resourceType
         *        The type of resources to discover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The maximum number of objects that you want Firewall Manager to return for this request. If more objects are
         * available, in the response, Firewall Manager provides a <code>NextToken</code> value that you can use in a
         * subsequent call to get the next batch of objects.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that you want Firewall Manager to return for this request. If more
         *        objects are available, in the response, Firewall Manager provides a <code>NextToken</code> value that
         *        you can use in a subsequent call to get the next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Firewall Manager returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private List<String> memberAccountIds = DefaultSdkAutoConstructList.getInstance();

        private String resourceType;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveredResourcesRequest model) {
            super(model);
            memberAccountIds(model.memberAccountIds);
            resourceType(model.resourceType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getMemberAccountIds() {
            if (memberAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return memberAccountIds;
        }

        public final void setMemberAccountIds(Collection<String> memberAccountIds) {
            this.memberAccountIds = AWSAccountIdListCopier.copy(memberAccountIds);
        }

        @Override
        public final Builder memberAccountIds(Collection<String> memberAccountIds) {
            this.memberAccountIds = AWSAccountIdListCopier.copy(memberAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAccountIds(String... memberAccountIds) {
            memberAccountIds(Arrays.asList(memberAccountIds));
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDiscoveredResourcesRequest build() {
            return new ListDiscoveredResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
