/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for Network Firewall for a firewall policy that has a different
 * <a>NetworkFirewallPolicyDescription</a> than is required by the Firewall Manager policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallPolicyModifiedViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFirewallPolicyModifiedViolation.Builder, NetworkFirewallPolicyModifiedViolation> {
    private static final SdkField<String> VIOLATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViolationTarget").getter(getter(NetworkFirewallPolicyModifiedViolation::violationTarget))
            .setter(setter(Builder::violationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolationTarget").build()).build();

    private static final SdkField<NetworkFirewallPolicyDescription> CURRENT_POLICY_DESCRIPTION_FIELD = SdkField
            .<NetworkFirewallPolicyDescription> builder(MarshallingType.SDK_POJO).memberName("CurrentPolicyDescription")
            .getter(getter(NetworkFirewallPolicyModifiedViolation::currentPolicyDescription))
            .setter(setter(Builder::currentPolicyDescription)).constructor(NetworkFirewallPolicyDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPolicyDescription").build())
            .build();

    private static final SdkField<NetworkFirewallPolicyDescription> EXPECTED_POLICY_DESCRIPTION_FIELD = SdkField
            .<NetworkFirewallPolicyDescription> builder(MarshallingType.SDK_POJO).memberName("ExpectedPolicyDescription")
            .getter(getter(NetworkFirewallPolicyModifiedViolation::expectedPolicyDescription))
            .setter(setter(Builder::expectedPolicyDescription)).constructor(NetworkFirewallPolicyDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedPolicyDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIOLATION_TARGET_FIELD,
            CURRENT_POLICY_DESCRIPTION_FIELD, EXPECTED_POLICY_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String violationTarget;

    private final NetworkFirewallPolicyDescription currentPolicyDescription;

    private final NetworkFirewallPolicyDescription expectedPolicyDescription;

    private NetworkFirewallPolicyModifiedViolation(BuilderImpl builder) {
        this.violationTarget = builder.violationTarget;
        this.currentPolicyDescription = builder.currentPolicyDescription;
        this.expectedPolicyDescription = builder.expectedPolicyDescription;
    }

    /**
     * <p>
     * The ID of the Network Firewall or VPC resource that's in violation.
     * </p>
     * 
     * @return The ID of the Network Firewall or VPC resource that's in violation.
     */
    public final String violationTarget() {
        return violationTarget;
    }

    /**
     * <p>
     * The policy that's currently in use in the individual account.
     * </p>
     * 
     * @return The policy that's currently in use in the individual account.
     */
    public final NetworkFirewallPolicyDescription currentPolicyDescription() {
        return currentPolicyDescription;
    }

    /**
     * <p>
     * The policy that should be in use in the individual account in order to be compliant.
     * </p>
     * 
     * @return The policy that should be in use in the individual account in order to be compliant.
     */
    public final NetworkFirewallPolicyDescription expectedPolicyDescription() {
        return expectedPolicyDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(violationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(currentPolicyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(expectedPolicyDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallPolicyModifiedViolation)) {
            return false;
        }
        NetworkFirewallPolicyModifiedViolation other = (NetworkFirewallPolicyModifiedViolation) obj;
        return Objects.equals(violationTarget(), other.violationTarget())
                && Objects.equals(currentPolicyDescription(), other.currentPolicyDescription())
                && Objects.equals(expectedPolicyDescription(), other.expectedPolicyDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallPolicyModifiedViolation").add("ViolationTarget", violationTarget())
                .add("CurrentPolicyDescription", currentPolicyDescription())
                .add("ExpectedPolicyDescription", expectedPolicyDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ViolationTarget":
            return Optional.ofNullable(clazz.cast(violationTarget()));
        case "CurrentPolicyDescription":
            return Optional.ofNullable(clazz.cast(currentPolicyDescription()));
        case "ExpectedPolicyDescription":
            return Optional.ofNullable(clazz.cast(expectedPolicyDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ViolationTarget", VIOLATION_TARGET_FIELD);
        map.put("CurrentPolicyDescription", CURRENT_POLICY_DESCRIPTION_FIELD);
        map.put("ExpectedPolicyDescription", EXPECTED_POLICY_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallPolicyModifiedViolation, T> g) {
        return obj -> g.apply((NetworkFirewallPolicyModifiedViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallPolicyModifiedViolation> {
        /**
         * <p>
         * The ID of the Network Firewall or VPC resource that's in violation.
         * </p>
         * 
         * @param violationTarget
         *        The ID of the Network Firewall or VPC resource that's in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violationTarget(String violationTarget);

        /**
         * <p>
         * The policy that's currently in use in the individual account.
         * </p>
         * 
         * @param currentPolicyDescription
         *        The policy that's currently in use in the individual account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPolicyDescription(NetworkFirewallPolicyDescription currentPolicyDescription);

        /**
         * <p>
         * The policy that's currently in use in the individual account.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkFirewallPolicyDescription.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallPolicyDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkFirewallPolicyDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #currentPolicyDescription(NetworkFirewallPolicyDescription)}.
         * 
         * @param currentPolicyDescription
         *        a consumer that will call methods on {@link NetworkFirewallPolicyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentPolicyDescription(NetworkFirewallPolicyDescription)
         */
        default Builder currentPolicyDescription(Consumer<NetworkFirewallPolicyDescription.Builder> currentPolicyDescription) {
            return currentPolicyDescription(NetworkFirewallPolicyDescription.builder().applyMutation(currentPolicyDescription)
                    .build());
        }

        /**
         * <p>
         * The policy that should be in use in the individual account in order to be compliant.
         * </p>
         * 
         * @param expectedPolicyDescription
         *        The policy that should be in use in the individual account in order to be compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedPolicyDescription(NetworkFirewallPolicyDescription expectedPolicyDescription);

        /**
         * <p>
         * The policy that should be in use in the individual account in order to be compliant.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkFirewallPolicyDescription.Builder}
         * avoiding the need to create one manually via {@link NetworkFirewallPolicyDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkFirewallPolicyDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #expectedPolicyDescription(NetworkFirewallPolicyDescription)}.
         * 
         * @param expectedPolicyDescription
         *        a consumer that will call methods on {@link NetworkFirewallPolicyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expectedPolicyDescription(NetworkFirewallPolicyDescription)
         */
        default Builder expectedPolicyDescription(Consumer<NetworkFirewallPolicyDescription.Builder> expectedPolicyDescription) {
            return expectedPolicyDescription(NetworkFirewallPolicyDescription.builder().applyMutation(expectedPolicyDescription)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String violationTarget;

        private NetworkFirewallPolicyDescription currentPolicyDescription;

        private NetworkFirewallPolicyDescription expectedPolicyDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallPolicyModifiedViolation model) {
            violationTarget(model.violationTarget);
            currentPolicyDescription(model.currentPolicyDescription);
            expectedPolicyDescription(model.expectedPolicyDescription);
        }

        public final String getViolationTarget() {
            return violationTarget;
        }

        public final void setViolationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
        }

        @Override
        public final Builder violationTarget(String violationTarget) {
            this.violationTarget = violationTarget;
            return this;
        }

        public final NetworkFirewallPolicyDescription.Builder getCurrentPolicyDescription() {
            return currentPolicyDescription != null ? currentPolicyDescription.toBuilder() : null;
        }

        public final void setCurrentPolicyDescription(NetworkFirewallPolicyDescription.BuilderImpl currentPolicyDescription) {
            this.currentPolicyDescription = currentPolicyDescription != null ? currentPolicyDescription.build() : null;
        }

        @Override
        public final Builder currentPolicyDescription(NetworkFirewallPolicyDescription currentPolicyDescription) {
            this.currentPolicyDescription = currentPolicyDescription;
            return this;
        }

        public final NetworkFirewallPolicyDescription.Builder getExpectedPolicyDescription() {
            return expectedPolicyDescription != null ? expectedPolicyDescription.toBuilder() : null;
        }

        public final void setExpectedPolicyDescription(NetworkFirewallPolicyDescription.BuilderImpl expectedPolicyDescription) {
            this.expectedPolicyDescription = expectedPolicyDescription != null ? expectedPolicyDescription.build() : null;
        }

        @Override
        public final Builder expectedPolicyDescription(NetworkFirewallPolicyDescription expectedPolicyDescription) {
            this.expectedPolicyDescription = expectedPolicyDescription;
            return this;
        }

        @Override
        public NetworkFirewallPolicyModifiedViolation build() {
            return new NetworkFirewallPolicyModifiedViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
