/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Organizations organizational units (OUs) that the specified Firewall Manager administrator can apply
 * policies to. For more information about OUs in Organizations, see <a
 * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html">Managing organizational units
 * (OUs) </a> in the <i>Organizations User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationalUnitScope implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationalUnitScope.Builder, OrganizationalUnitScope> {
    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnits")
            .getter(getter(OrganizationalUnitScope::organizationalUnits))
            .setter(setter(Builder::organizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALL_ORGANIZATIONAL_UNITS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllOrganizationalUnitsEnabled")
            .getter(getter(OrganizationalUnitScope::allOrganizationalUnitsEnabled))
            .setter(setter(Builder::allOrganizationalUnitsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllOrganizationalUnitsEnabled")
                    .build()).build();

    private static final SdkField<Boolean> EXCLUDE_SPECIFIED_ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeSpecifiedOrganizationalUnits")
            .getter(getter(OrganizationalUnitScope::excludeSpecifiedOrganizationalUnits))
            .setter(setter(Builder::excludeSpecifiedOrganizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ExcludeSpecifiedOrganizationalUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATIONAL_UNITS_FIELD,
            ALL_ORGANIZATIONAL_UNITS_ENABLED_FIELD, EXCLUDE_SPECIFIED_ORGANIZATIONAL_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> organizationalUnits;

    private final Boolean allOrganizationalUnitsEnabled;

    private final Boolean excludeSpecifiedOrganizationalUnits;

    private OrganizationalUnitScope(BuilderImpl builder) {
        this.organizationalUnits = builder.organizationalUnits;
        this.allOrganizationalUnitsEnabled = builder.allOrganizationalUnitsEnabled;
        this.excludeSpecifiedOrganizationalUnits = builder.excludeSpecifiedOrganizationalUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnits property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrganizationalUnits() {
        return organizationalUnits != null && !(organizationalUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of OUs within the organization that the specified Firewall Manager administrator either can or cannot
     * apply policies to, based on the value of <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>
     * . If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>, then
     * the Firewall Manager administrator can apply policies to all OUs in the organization except for the OUs in this
     * list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>false</code>,
     * then the Firewall Manager administrator can only apply policies to the OUs in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnits} method.
     * </p>
     * 
     * @return The list of OUs within the organization that the specified Firewall Manager administrator either can or
     *         cannot apply policies to, based on the value of
     *         <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>. If
     *         <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>,
     *         then the Firewall Manager administrator can apply policies to all OUs in the organization except for the
     *         OUs in this list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to
     *         <code>false</code>, then the Firewall Manager administrator can only apply policies to the OUs in this
     *         list.
     */
    public final List<String> organizationalUnits() {
        return organizationalUnits;
    }

    /**
     * <p>
     * A boolean value that indicates if the administrator can apply policies to all OUs within an organization. If
     * true, the administrator can manage all OUs within the organization. You can either enable management of all OUs
     * through this operation, or you can specify OUs to manage in
     * <code>OrganizationalUnitScope$OrganizationalUnits</code>. You cannot specify both.
     * </p>
     * 
     * @return A boolean value that indicates if the administrator can apply policies to all OUs within an organization.
     *         If true, the administrator can manage all OUs within the organization. You can either enable management
     *         of all OUs through this operation, or you can specify OUs to manage in
     *         <code>OrganizationalUnitScope$OrganizationalUnits</code>. You cannot specify both.
     */
    public final Boolean allOrganizationalUnitsEnabled() {
        return allOrganizationalUnitsEnabled;
    }

    /**
     * <p>
     * A boolean value that excludes the OUs in <code>OrganizationalUnitScope$OrganizationalUnits</code> from the
     * administrator's scope. If true, the Firewall Manager administrator can apply policies to all OUs in the
     * organization except for the OUs listed in <code>OrganizationalUnitScope$OrganizationalUnits</code>. You can
     * either specify a list of OUs to exclude by <code>OrganizationalUnitScope$OrganizationalUnits</code>, or you can
     * enable management of all OUs by <code>OrganizationalUnitScope$AllOrganizationalUnitsEnabled</code>. You cannot
     * specify both.
     * </p>
     * 
     * @return A boolean value that excludes the OUs in <code>OrganizationalUnitScope$OrganizationalUnits</code> from
     *         the administrator's scope. If true, the Firewall Manager administrator can apply policies to all OUs in
     *         the organization except for the OUs listed in <code>OrganizationalUnitScope$OrganizationalUnits</code>.
     *         You can either specify a list of OUs to exclude by
     *         <code>OrganizationalUnitScope$OrganizationalUnits</code>, or you can enable management of all OUs by
     *         <code>OrganizationalUnitScope$AllOrganizationalUnitsEnabled</code>. You cannot specify both.
     */
    public final Boolean excludeSpecifiedOrganizationalUnits() {
        return excludeSpecifiedOrganizationalUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnits() ? organizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allOrganizationalUnitsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(excludeSpecifiedOrganizationalUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationalUnitScope)) {
            return false;
        }
        OrganizationalUnitScope other = (OrganizationalUnitScope) obj;
        return hasOrganizationalUnits() == other.hasOrganizationalUnits()
                && Objects.equals(organizationalUnits(), other.organizationalUnits())
                && Objects.equals(allOrganizationalUnitsEnabled(), other.allOrganizationalUnitsEnabled())
                && Objects.equals(excludeSpecifiedOrganizationalUnits(), other.excludeSpecifiedOrganizationalUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationalUnitScope")
                .add("OrganizationalUnits", hasOrganizationalUnits() ? organizationalUnits() : null)
                .add("AllOrganizationalUnitsEnabled", allOrganizationalUnitsEnabled())
                .add("ExcludeSpecifiedOrganizationalUnits", excludeSpecifiedOrganizationalUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationalUnits":
            return Optional.ofNullable(clazz.cast(organizationalUnits()));
        case "AllOrganizationalUnitsEnabled":
            return Optional.ofNullable(clazz.cast(allOrganizationalUnitsEnabled()));
        case "ExcludeSpecifiedOrganizationalUnits":
            return Optional.ofNullable(clazz.cast(excludeSpecifiedOrganizationalUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationalUnits", ORGANIZATIONAL_UNITS_FIELD);
        map.put("AllOrganizationalUnitsEnabled", ALL_ORGANIZATIONAL_UNITS_ENABLED_FIELD);
        map.put("ExcludeSpecifiedOrganizationalUnits", EXCLUDE_SPECIFIED_ORGANIZATIONAL_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationalUnitScope, T> g) {
        return obj -> g.apply((OrganizationalUnitScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationalUnitScope> {
        /**
         * <p>
         * The list of OUs within the organization that the specified Firewall Manager administrator either can or
         * cannot apply policies to, based on the value of
         * <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>. If
         * <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>, then
         * the Firewall Manager administrator can apply policies to all OUs in the organization except for the OUs in
         * this list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to
         * <code>false</code>, then the Firewall Manager administrator can only apply policies to the OUs in this list.
         * </p>
         * 
         * @param organizationalUnits
         *        The list of OUs within the organization that the specified Firewall Manager administrator either can
         *        or cannot apply policies to, based on the value of
         *        <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>. If
         *        <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>,
         *        then the Firewall Manager administrator can apply policies to all OUs in the organization except for
         *        the OUs in this list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is
         *        set to <code>false</code>, then the Firewall Manager administrator can only apply policies to the OUs
         *        in this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(Collection<String> organizationalUnits);

        /**
         * <p>
         * The list of OUs within the organization that the specified Firewall Manager administrator either can or
         * cannot apply policies to, based on the value of
         * <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>. If
         * <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>, then
         * the Firewall Manager administrator can apply policies to all OUs in the organization except for the OUs in
         * this list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to
         * <code>false</code>, then the Firewall Manager administrator can only apply policies to the OUs in this list.
         * </p>
         * 
         * @param organizationalUnits
         *        The list of OUs within the organization that the specified Firewall Manager administrator either can
         *        or cannot apply policies to, based on the value of
         *        <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code>. If
         *        <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is set to <code>true</code>,
         *        then the Firewall Manager administrator can apply policies to all OUs in the organization except for
         *        the OUs in this list. If <code>OrganizationalUnitScope$ExcludeSpecifiedOrganizationalUnits</code> is
         *        set to <code>false</code>, then the Firewall Manager administrator can only apply policies to the OUs
         *        in this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(String... organizationalUnits);

        /**
         * <p>
         * A boolean value that indicates if the administrator can apply policies to all OUs within an organization. If
         * true, the administrator can manage all OUs within the organization. You can either enable management of all
         * OUs through this operation, or you can specify OUs to manage in
         * <code>OrganizationalUnitScope$OrganizationalUnits</code>. You cannot specify both.
         * </p>
         * 
         * @param allOrganizationalUnitsEnabled
         *        A boolean value that indicates if the administrator can apply policies to all OUs within an
         *        organization. If true, the administrator can manage all OUs within the organization. You can either
         *        enable management of all OUs through this operation, or you can specify OUs to manage in
         *        <code>OrganizationalUnitScope$OrganizationalUnits</code>. You cannot specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allOrganizationalUnitsEnabled(Boolean allOrganizationalUnitsEnabled);

        /**
         * <p>
         * A boolean value that excludes the OUs in <code>OrganizationalUnitScope$OrganizationalUnits</code> from the
         * administrator's scope. If true, the Firewall Manager administrator can apply policies to all OUs in the
         * organization except for the OUs listed in <code>OrganizationalUnitScope$OrganizationalUnits</code>. You can
         * either specify a list of OUs to exclude by <code>OrganizationalUnitScope$OrganizationalUnits</code>, or you
         * can enable management of all OUs by <code>OrganizationalUnitScope$AllOrganizationalUnitsEnabled</code>. You
         * cannot specify both.
         * </p>
         * 
         * @param excludeSpecifiedOrganizationalUnits
         *        A boolean value that excludes the OUs in <code>OrganizationalUnitScope$OrganizationalUnits</code> from
         *        the administrator's scope. If true, the Firewall Manager administrator can apply policies to all OUs
         *        in the organization except for the OUs listed in
         *        <code>OrganizationalUnitScope$OrganizationalUnits</code>. You can either specify a list of OUs to
         *        exclude by <code>OrganizationalUnitScope$OrganizationalUnits</code>, or you can enable management of
         *        all OUs by <code>OrganizationalUnitScope$AllOrganizationalUnitsEnabled</code>. You cannot specify
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeSpecifiedOrganizationalUnits(Boolean excludeSpecifiedOrganizationalUnits);
    }

    static final class BuilderImpl implements Builder {
        private List<String> organizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private Boolean allOrganizationalUnitsEnabled;

        private Boolean excludeSpecifiedOrganizationalUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationalUnitScope model) {
            organizationalUnits(model.organizationalUnits);
            allOrganizationalUnitsEnabled(model.allOrganizationalUnitsEnabled);
            excludeSpecifiedOrganizationalUnits(model.excludeSpecifiedOrganizationalUnits);
        }

        public final Collection<String> getOrganizationalUnits() {
            if (organizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnits;
        }

        public final void setOrganizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitIdListCopier.copy(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitIdListCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(String... organizationalUnits) {
            organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        public final Boolean getAllOrganizationalUnitsEnabled() {
            return allOrganizationalUnitsEnabled;
        }

        public final void setAllOrganizationalUnitsEnabled(Boolean allOrganizationalUnitsEnabled) {
            this.allOrganizationalUnitsEnabled = allOrganizationalUnitsEnabled;
        }

        @Override
        public final Builder allOrganizationalUnitsEnabled(Boolean allOrganizationalUnitsEnabled) {
            this.allOrganizationalUnitsEnabled = allOrganizationalUnitsEnabled;
            return this;
        }

        public final Boolean getExcludeSpecifiedOrganizationalUnits() {
            return excludeSpecifiedOrganizationalUnits;
        }

        public final void setExcludeSpecifiedOrganizationalUnits(Boolean excludeSpecifiedOrganizationalUnits) {
            this.excludeSpecifiedOrganizationalUnits = excludeSpecifiedOrganizationalUnits;
        }

        @Override
        public final Builder excludeSpecifiedOrganizationalUnits(Boolean excludeSpecifiedOrganizationalUnits) {
            this.excludeSpecifiedOrganizationalUnits = excludeSpecifiedOrganizationalUnits;
            return this;
        }

        @Override
        public OrganizationalUnitScope build() {
            return new OrganizationalUnitScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
