/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Firewall Manager protocols list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtocolsListDataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtocolsListDataSummary.Builder, ProtocolsListDataSummary> {
    private static final SdkField<String> LIST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListArn").getter(getter(ProtocolsListDataSummary::listArn)).setter(setter(Builder::listArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListArn").build()).build();

    private static final SdkField<String> LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ListId")
            .getter(getter(ProtocolsListDataSummary::listId)).setter(setter(Builder::listId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListId").build()).build();

    private static final SdkField<String> LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListName").getter(getter(ProtocolsListDataSummary::listName)).setter(setter(Builder::listName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListName").build()).build();

    private static final SdkField<List<String>> PROTOCOLS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtocolsList")
            .getter(getter(ProtocolsListDataSummary::protocolsList))
            .setter(setter(Builder::protocolsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_ARN_FIELD, LIST_ID_FIELD,
            LIST_NAME_FIELD, PROTOCOLS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String listArn;

    private final String listId;

    private final String listName;

    private final List<String> protocolsList;

    private ProtocolsListDataSummary(BuilderImpl builder) {
        this.listArn = builder.listArn;
        this.listId = builder.listId;
        this.listName = builder.listName;
        this.protocolsList = builder.protocolsList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified protocols list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified protocols list.
     */
    public final String listArn() {
        return listArn;
    }

    /**
     * <p>
     * The ID of the specified protocols list.
     * </p>
     * 
     * @return The ID of the specified protocols list.
     */
    public final String listId() {
        return listId;
    }

    /**
     * <p>
     * The name of the specified protocols list.
     * </p>
     * 
     * @return The name of the specified protocols list.
     */
    public final String listName() {
        return listName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtocolsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtocolsList() {
        return protocolsList != null && !(protocolsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of protocols in the Firewall Manager protocols list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocolsList} method.
     * </p>
     * 
     * @return An array of protocols in the Firewall Manager protocols list.
     */
    public final List<String> protocolsList() {
        return protocolsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listArn());
        hashCode = 31 * hashCode + Objects.hashCode(listId());
        hashCode = 31 * hashCode + Objects.hashCode(listName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocolsList() ? protocolsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolsListDataSummary)) {
            return false;
        }
        ProtocolsListDataSummary other = (ProtocolsListDataSummary) obj;
        return Objects.equals(listArn(), other.listArn()) && Objects.equals(listId(), other.listId())
                && Objects.equals(listName(), other.listName()) && hasProtocolsList() == other.hasProtocolsList()
                && Objects.equals(protocolsList(), other.protocolsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtocolsListDataSummary").add("ListArn", listArn()).add("ListId", listId())
                .add("ListName", listName()).add("ProtocolsList", hasProtocolsList() ? protocolsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListArn":
            return Optional.ofNullable(clazz.cast(listArn()));
        case "ListId":
            return Optional.ofNullable(clazz.cast(listId()));
        case "ListName":
            return Optional.ofNullable(clazz.cast(listName()));
        case "ProtocolsList":
            return Optional.ofNullable(clazz.cast(protocolsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ListArn", LIST_ARN_FIELD);
        map.put("ListId", LIST_ID_FIELD);
        map.put("ListName", LIST_NAME_FIELD);
        map.put("ProtocolsList", PROTOCOLS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtocolsListDataSummary, T> g) {
        return obj -> g.apply((ProtocolsListDataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtocolsListDataSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified protocols list.
         * </p>
         * 
         * @param listArn
         *        The Amazon Resource Name (ARN) of the specified protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listArn(String listArn);

        /**
         * <p>
         * The ID of the specified protocols list.
         * </p>
         * 
         * @param listId
         *        The ID of the specified protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listId(String listId);

        /**
         * <p>
         * The name of the specified protocols list.
         * </p>
         * 
         * @param listName
         *        The name of the specified protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listName(String listName);

        /**
         * <p>
         * An array of protocols in the Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        An array of protocols in the Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(Collection<String> protocolsList);

        /**
         * <p>
         * An array of protocols in the Firewall Manager protocols list.
         * </p>
         * 
         * @param protocolsList
         *        An array of protocols in the Firewall Manager protocols list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsList(String... protocolsList);
    }

    static final class BuilderImpl implements Builder {
        private String listArn;

        private String listId;

        private String listName;

        private List<String> protocolsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolsListDataSummary model) {
            listArn(model.listArn);
            listId(model.listId);
            listName(model.listName);
            protocolsList(model.protocolsList);
        }

        public final String getListArn() {
            return listArn;
        }

        public final void setListArn(String listArn) {
            this.listArn = listArn;
        }

        @Override
        public final Builder listArn(String listArn) {
            this.listArn = listArn;
            return this;
        }

        public final String getListId() {
            return listId;
        }

        public final void setListId(String listId) {
            this.listId = listId;
        }

        @Override
        public final Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public final String getListName() {
            return listName;
        }

        public final void setListName(String listName) {
            this.listName = listName;
        }

        @Override
        public final Builder listName(String listName) {
            this.listName = listName;
            return this;
        }

        public final Collection<String> getProtocolsList() {
            if (protocolsList instanceof SdkAutoConstructList) {
                return null;
            }
            return protocolsList;
        }

        public final void setProtocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
        }

        @Override
        public final Builder protocolsList(Collection<String> protocolsList) {
            this.protocolsList = ProtocolsListCopier.copy(protocolsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsList(String... protocolsList) {
            protocolsList(Arrays.asList(protocolsList));
            return this;
        }

        @Override
        public ProtocolsListDataSummary build() {
            return new ProtocolsListDataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
