/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Remediation option for the rule specified in the <code>ViolationTarget</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupRemediationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupRemediationAction.Builder, SecurityGroupRemediationAction> {
    private static final SdkField<String> REMEDIATION_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemediationActionType").getter(getter(SecurityGroupRemediationAction::remediationActionTypeAsString))
            .setter(setter(Builder::remediationActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationActionType").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SecurityGroupRemediationAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<SecurityGroupRuleDescription> REMEDIATION_RESULT_FIELD = SdkField
            .<SecurityGroupRuleDescription> builder(MarshallingType.SDK_POJO).memberName("RemediationResult")
            .getter(getter(SecurityGroupRemediationAction::remediationResult)).setter(setter(Builder::remediationResult))
            .constructor(SecurityGroupRuleDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationResult").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_ACTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultAction").getter(getter(SecurityGroupRemediationAction::isDefaultAction))
            .setter(setter(Builder::isDefaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_ACTION_TYPE_FIELD,
            DESCRIPTION_FIELD, REMEDIATION_RESULT_FIELD, IS_DEFAULT_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String remediationActionType;

    private final String description;

    private final SecurityGroupRuleDescription remediationResult;

    private final Boolean isDefaultAction;

    private SecurityGroupRemediationAction(BuilderImpl builder) {
        this.remediationActionType = builder.remediationActionType;
        this.description = builder.description;
        this.remediationResult = builder.remediationResult;
        this.isDefaultAction = builder.isDefaultAction;
    }

    /**
     * <p>
     * The remediation action that will be performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #remediationActionType} will return {@link RemediationActionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #remediationActionTypeAsString}.
     * </p>
     * 
     * @return The remediation action that will be performed.
     * @see RemediationActionType
     */
    public final RemediationActionType remediationActionType() {
        return RemediationActionType.fromValue(remediationActionType);
    }

    /**
     * <p>
     * The remediation action that will be performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #remediationActionType} will return {@link RemediationActionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #remediationActionTypeAsString}.
     * </p>
     * 
     * @return The remediation action that will be performed.
     * @see RemediationActionType
     */
    public final String remediationActionTypeAsString() {
        return remediationActionType;
    }

    /**
     * <p>
     * Brief description of the action that will be performed.
     * </p>
     * 
     * @return Brief description of the action that will be performed.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.
     * </p>
     * 
     * @return The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.
     */
    public final SecurityGroupRuleDescription remediationResult() {
        return remediationResult;
    }

    /**
     * <p>
     * Indicates if the current action is the default action.
     * </p>
     * 
     * @return Indicates if the current action is the default action.
     */
    public final Boolean isDefaultAction() {
        return isDefaultAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remediationActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(remediationResult());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRemediationAction)) {
            return false;
        }
        SecurityGroupRemediationAction other = (SecurityGroupRemediationAction) obj;
        return Objects.equals(remediationActionTypeAsString(), other.remediationActionTypeAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(remediationResult(), other.remediationResult())
                && Objects.equals(isDefaultAction(), other.isDefaultAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroupRemediationAction").add("RemediationActionType", remediationActionTypeAsString())
                .add("Description", description()).add("RemediationResult", remediationResult())
                .add("IsDefaultAction", isDefaultAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RemediationActionType":
            return Optional.ofNullable(clazz.cast(remediationActionTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RemediationResult":
            return Optional.ofNullable(clazz.cast(remediationResult()));
        case "IsDefaultAction":
            return Optional.ofNullable(clazz.cast(isDefaultAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RemediationActionType", REMEDIATION_ACTION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RemediationResult", REMEDIATION_RESULT_FIELD);
        map.put("IsDefaultAction", IS_DEFAULT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRemediationAction, T> g) {
        return obj -> g.apply((SecurityGroupRemediationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupRemediationAction> {
        /**
         * <p>
         * The remediation action that will be performed.
         * </p>
         * 
         * @param remediationActionType
         *        The remediation action that will be performed.
         * @see RemediationActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationActionType
         */
        Builder remediationActionType(String remediationActionType);

        /**
         * <p>
         * The remediation action that will be performed.
         * </p>
         * 
         * @param remediationActionType
         *        The remediation action that will be performed.
         * @see RemediationActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RemediationActionType
         */
        Builder remediationActionType(RemediationActionType remediationActionType);

        /**
         * <p>
         * Brief description of the action that will be performed.
         * </p>
         * 
         * @param description
         *        Brief description of the action that will be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.
         * </p>
         * 
         * @param remediationResult
         *        The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationResult(SecurityGroupRuleDescription remediationResult);

        /**
         * <p>
         * The final state of the rule specified in the <code>ViolationTarget</code> after it is remediated.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityGroupRuleDescription.Builder}
         * avoiding the need to create one manually via {@link SecurityGroupRuleDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityGroupRuleDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #remediationResult(SecurityGroupRuleDescription)}.
         * 
         * @param remediationResult
         *        a consumer that will call methods on {@link SecurityGroupRuleDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediationResult(SecurityGroupRuleDescription)
         */
        default Builder remediationResult(Consumer<SecurityGroupRuleDescription.Builder> remediationResult) {
            return remediationResult(SecurityGroupRuleDescription.builder().applyMutation(remediationResult).build());
        }

        /**
         * <p>
         * Indicates if the current action is the default action.
         * </p>
         * 
         * @param isDefaultAction
         *        Indicates if the current action is the default action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultAction(Boolean isDefaultAction);
    }

    static final class BuilderImpl implements Builder {
        private String remediationActionType;

        private String description;

        private SecurityGroupRuleDescription remediationResult;

        private Boolean isDefaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRemediationAction model) {
            remediationActionType(model.remediationActionType);
            description(model.description);
            remediationResult(model.remediationResult);
            isDefaultAction(model.isDefaultAction);
        }

        public final String getRemediationActionType() {
            return remediationActionType;
        }

        public final void setRemediationActionType(String remediationActionType) {
            this.remediationActionType = remediationActionType;
        }

        @Override
        public final Builder remediationActionType(String remediationActionType) {
            this.remediationActionType = remediationActionType;
            return this;
        }

        @Override
        public final Builder remediationActionType(RemediationActionType remediationActionType) {
            this.remediationActionType(remediationActionType == null ? null : remediationActionType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SecurityGroupRuleDescription.Builder getRemediationResult() {
            return remediationResult != null ? remediationResult.toBuilder() : null;
        }

        public final void setRemediationResult(SecurityGroupRuleDescription.BuilderImpl remediationResult) {
            this.remediationResult = remediationResult != null ? remediationResult.build() : null;
        }

        @Override
        public final Builder remediationResult(SecurityGroupRuleDescription remediationResult) {
            this.remediationResult = remediationResult;
            return this;
        }

        public final Boolean getIsDefaultAction() {
            return isDefaultAction;
        }

        public final void setIsDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
        }

        @Override
        public final Builder isDefaultAction(Boolean isDefaultAction) {
            this.isDefaultAction = isDefaultAction;
            return this;
        }

        @Override
        public SecurityGroupRemediationAction build() {
            return new SecurityGroupRemediationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
