/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The violation details for a web ACL whose configuration is incompatible with the Firewall Manager policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebACLHasIncompatibleConfigurationViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<WebACLHasIncompatibleConfigurationViolation.Builder, WebACLHasIncompatibleConfigurationViolation> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebACLArn").getter(getter(WebACLHasIncompatibleConfigurationViolation::webACLArn))
            .setter(setter(Builder::webACLArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WebACLHasIncompatibleConfigurationViolation::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String webACLArn;

    private final String description;

    private WebACLHasIncompatibleConfigurationViolation(BuilderImpl builder) {
        this.webACLArn = builder.webACLArn;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the web ACL.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the web ACL.
     */
    public final String webACLArn() {
        return webACLArn;
    }

    /**
     * <p>
     * Information about the problems that Firewall Manager encountered with the web ACL configuration.
     * </p>
     * 
     * @return Information about the problems that Firewall Manager encountered with the web ACL configuration.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webACLArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLHasIncompatibleConfigurationViolation)) {
            return false;
        }
        WebACLHasIncompatibleConfigurationViolation other = (WebACLHasIncompatibleConfigurationViolation) obj;
        return Objects.equals(webACLArn(), other.webACLArn()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebACLHasIncompatibleConfigurationViolation").add("WebACLArn", webACLArn())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebACLArn":
            return Optional.ofNullable(clazz.cast(webACLArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebACLArn", WEB_ACL_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebACLHasIncompatibleConfigurationViolation, T> g) {
        return obj -> g.apply((WebACLHasIncompatibleConfigurationViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebACLHasIncompatibleConfigurationViolation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the web ACL.
         * </p>
         * 
         * @param webACLArn
         *        The Amazon Resource Name (ARN) of the web ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLArn(String webACLArn);

        /**
         * <p>
         * Information about the problems that Firewall Manager encountered with the web ACL configuration.
         * </p>
         * 
         * @param description
         *        Information about the problems that Firewall Manager encountered with the web ACL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String webACLArn;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLHasIncompatibleConfigurationViolation model) {
            webACLArn(model.webACLArn);
            description(model.description);
        }

        public final String getWebACLArn() {
            return webACLArn;
        }

        public final void setWebACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
        }

        @Override
        public final Builder webACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public WebACLHasIncompatibleConfigurationViolation build() {
            return new WebACLHasIncompatibleConfigurationViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
