/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the actions that you can take to remediate scope violations caused by your policy's
 * <code>FirewallCreationConfig</code>. <code>FirewallCreationConfig</code> is an optional configuration that you can
 * use to choose which Availability Zones Firewall Manager creates Network Firewall endpoints in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FMSPolicyUpdateFirewallCreationConfigAction implements SdkPojo, Serializable,
        ToCopyableBuilder<FMSPolicyUpdateFirewallCreationConfigAction.Builder, FMSPolicyUpdateFirewallCreationConfigAction> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(FMSPolicyUpdateFirewallCreationConfigAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FIREWALL_CREATION_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallCreationConfig")
            .getter(getter(FMSPolicyUpdateFirewallCreationConfigAction::firewallCreationConfig))
            .setter(setter(Builder::firewallCreationConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallCreationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            FIREWALL_CREATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String firewallCreationConfig;

    private FMSPolicyUpdateFirewallCreationConfigAction(BuilderImpl builder) {
        this.description = builder.description;
        this.firewallCreationConfig = builder.firewallCreationConfig;
    }

    /**
     * <p>
     * Describes the remedial action.
     * </p>
     * 
     * @return Describes the remedial action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A <code>FirewallCreationConfig</code> that you can copy into your current policy's <a
     * href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html"
     * >SecurityServiceData</a> in order to remedy scope violations.
     * </p>
     * 
     * @return A <code>FirewallCreationConfig</code> that you can copy into your current policy's <a
     *         href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html"
     *         >SecurityServiceData</a> in order to remedy scope violations.
     */
    public final String firewallCreationConfig() {
        return firewallCreationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(firewallCreationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FMSPolicyUpdateFirewallCreationConfigAction)) {
            return false;
        }
        FMSPolicyUpdateFirewallCreationConfigAction other = (FMSPolicyUpdateFirewallCreationConfigAction) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(firewallCreationConfig(), other.firewallCreationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FMSPolicyUpdateFirewallCreationConfigAction").add("Description", description())
                .add("FirewallCreationConfig", firewallCreationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FirewallCreationConfig":
            return Optional.ofNullable(clazz.cast(firewallCreationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("FirewallCreationConfig", FIREWALL_CREATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FMSPolicyUpdateFirewallCreationConfigAction, T> g) {
        return obj -> g.apply((FMSPolicyUpdateFirewallCreationConfigAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FMSPolicyUpdateFirewallCreationConfigAction> {
        /**
         * <p>
         * Describes the remedial action.
         * </p>
         * 
         * @param description
         *        Describes the remedial action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A <code>FirewallCreationConfig</code> that you can copy into your current policy's <a
         * href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html"
         * >SecurityServiceData</a> in order to remedy scope violations.
         * </p>
         * 
         * @param firewallCreationConfig
         *        A <code>FirewallCreationConfig</code> that you can copy into your current policy's <a
         *        href="https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html"
         *        >SecurityServiceData</a> in order to remedy scope violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallCreationConfig(String firewallCreationConfig);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String firewallCreationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FMSPolicyUpdateFirewallCreationConfigAction model) {
            description(model.description);
            firewallCreationConfig(model.firewallCreationConfig);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFirewallCreationConfig() {
            return firewallCreationConfig;
        }

        public final void setFirewallCreationConfig(String firewallCreationConfig) {
            this.firewallCreationConfig = firewallCreationConfig;
        }

        @Override
        public final Builder firewallCreationConfig(String firewallCreationConfig) {
            this.firewallCreationConfig = firewallCreationConfig;
            return this;
        }

        @Override
        public FMSPolicyUpdateFirewallCreationConfigAction build() {
            return new FMSPolicyUpdateFirewallCreationConfigAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
