/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for an unexpected gateway route that’s present in a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFirewallUnexpectedGatewayRoutesViolation
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<NetworkFirewallUnexpectedGatewayRoutesViolation.Builder, NetworkFirewallUnexpectedGatewayRoutesViolation> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayId").getter(getter(NetworkFirewallUnexpectedGatewayRoutesViolation::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("ViolatingRoutes")
            .getter(getter(NetworkFirewallUnexpectedGatewayRoutesViolation::violatingRoutes))
            .setter(setter(Builder::violatingRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(NetworkFirewallUnexpectedGatewayRoutesViolation::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(NetworkFirewallUnexpectedGatewayRoutesViolation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            VIOLATING_ROUTES_FIELD, ROUTE_TABLE_ID_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayId;

    private final List<Route> violatingRoutes;

    private final String routeTableId;

    private final String vpcId;

    private NetworkFirewallUnexpectedGatewayRoutesViolation(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.violatingRoutes = builder.violatingRoutes;
        this.routeTableId = builder.routeTableId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Information about the gateway ID.
     * </p>
     * 
     * @return Information about the gateway ID.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolatingRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolatingRoutes() {
        return violatingRoutes != null && !(violatingRoutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes that are in violation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolatingRoutes} method.
     * </p>
     * 
     * @return The routes that are in violation.
     */
    public final List<Route> violatingRoutes() {
        return violatingRoutes;
    }

    /**
     * <p>
     * Information about the route table.
     * </p>
     * 
     * @return Information about the route table.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * Information about the VPC ID.
     * </p>
     * 
     * @return Information about the VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolatingRoutes() ? violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallUnexpectedGatewayRoutesViolation)) {
            return false;
        }
        NetworkFirewallUnexpectedGatewayRoutesViolation other = (NetworkFirewallUnexpectedGatewayRoutesViolation) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && hasViolatingRoutes() == other.hasViolatingRoutes()
                && Objects.equals(violatingRoutes(), other.violatingRoutes())
                && Objects.equals(routeTableId(), other.routeTableId()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFirewallUnexpectedGatewayRoutesViolation").add("GatewayId", gatewayId())
                .add("ViolatingRoutes", hasViolatingRoutes() ? violatingRoutes() : null).add("RouteTableId", routeTableId())
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "ViolatingRoutes":
            return Optional.ofNullable(clazz.cast(violatingRoutes()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallUnexpectedGatewayRoutesViolation, T> g) {
        return obj -> g.apply((NetworkFirewallUnexpectedGatewayRoutesViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFirewallUnexpectedGatewayRoutesViolation> {
        /**
         * <p>
         * Information about the gateway ID.
         * </p>
         * 
         * @param gatewayId
         *        Information about the gateway ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The routes that are in violation.
         * </p>
         * 
         * @param violatingRoutes
         *        The routes that are in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Collection<Route> violatingRoutes);

        /**
         * <p>
         * The routes that are in violation.
         * </p>
         * 
         * @param violatingRoutes
         *        The routes that are in violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatingRoutes(Route... violatingRoutes);

        /**
         * <p>
         * The routes that are in violation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.Route.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fms.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fms.model.Route.Builder#build()}
         * is called immediately and its result is passed to {@link #violatingRoutes(List<Route>)}.
         * 
         * @param violatingRoutes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fms.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatingRoutes(java.util.Collection<Route>)
         */
        Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes);

        /**
         * <p>
         * Information about the route table.
         * </p>
         * 
         * @param routeTableId
         *        Information about the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * Information about the VPC ID.
         * </p>
         * 
         * @param vpcId
         *        Information about the VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayId;

        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();

        private String routeTableId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallUnexpectedGatewayRoutesViolation model) {
            gatewayId(model.gatewayId);
            violatingRoutes(model.violatingRoutes);
            routeTableId(model.routeTableId);
            vpcId(model.vpcId);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route... violatingRoutes) {
            violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder>... violatingRoutes) {
            violatingRoutes(Stream.of(violatingRoutes).map(c -> Route.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public NetworkFirewallUnexpectedGatewayRoutesViolation build() {
            return new NetworkFirewallUnexpectedGatewayRoutesViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
