/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the security service that is being used to protect the resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityServicePolicyData implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityServicePolicyData.Builder, SecurityServicePolicyData> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SecurityServicePolicyData::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> MANAGED_SERVICE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SecurityServicePolicyData::managedServiceData)).setter(setter(Builder::managedServiceData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedServiceData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            MANAGED_SERVICE_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String managedServiceData;

    private SecurityServicePolicyData(BuilderImpl builder) {
        this.type = builder.type;
        this.managedServiceData = builder.managedServiceData;
    }

    /**
     * <p>
     * The service that the policy is using to protect the resources. This specifies the type of policy that is created,
     * either a WAF policy or Shield Advanced policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The service that the policy is using to protect the resources. This specifies the type of policy that is
     *         created, either a WAF policy or Shield Advanced policy.
     * @see SecurityServiceType
     */
    public SecurityServiceType type() {
        return SecurityServiceType.fromValue(type);
    }

    /**
     * <p>
     * The service that the policy is using to protect the resources. This specifies the type of policy that is created,
     * either a WAF policy or Shield Advanced policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The service that the policy is using to protect the resources. This specifies the type of policy that is
     *         created, either a WAF policy or Shield Advanced policy.
     * @see SecurityServiceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details about the service. This contains <code>WAF</code> data in JSON format, as shown in the following example:
     * </p>
     * <p>
     * <code>ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}</code>
     * </p>
     * <p>
     * If this is a Shield Advanced policy, this string will be empty.
     * </p>
     * 
     * @return Details about the service. This contains <code>WAF</code> data in JSON format, as shown in the following
     *         example:</p>
     *         <p>
     *         <code>ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}</code>
     *         </p>
     *         <p>
     *         If this is a Shield Advanced policy, this string will be empty.
     */
    public String managedServiceData() {
        return managedServiceData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedServiceData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityServicePolicyData)) {
            return false;
        }
        SecurityServicePolicyData other = (SecurityServicePolicyData) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(managedServiceData(), other.managedServiceData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SecurityServicePolicyData").add("Type", typeAsString())
                .add("ManagedServiceData", managedServiceData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ManagedServiceData":
            return Optional.ofNullable(clazz.cast(managedServiceData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityServicePolicyData, T> g) {
        return obj -> g.apply((SecurityServicePolicyData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityServicePolicyData> {
        /**
         * <p>
         * The service that the policy is using to protect the resources. This specifies the type of policy that is
         * created, either a WAF policy or Shield Advanced policy.
         * </p>
         * 
         * @param type
         *        The service that the policy is using to protect the resources. This specifies the type of policy that
         *        is created, either a WAF policy or Shield Advanced policy.
         * @see SecurityServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityServiceType
         */
        Builder type(String type);

        /**
         * <p>
         * The service that the policy is using to protect the resources. This specifies the type of policy that is
         * created, either a WAF policy or Shield Advanced policy.
         * </p>
         * 
         * @param type
         *        The service that the policy is using to protect the resources. This specifies the type of policy that
         *        is created, either a WAF policy or Shield Advanced policy.
         * @see SecurityServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityServiceType
         */
        Builder type(SecurityServiceType type);

        /**
         * <p>
         * Details about the service. This contains <code>WAF</code> data in JSON format, as shown in the following
         * example:
         * </p>
         * <p>
         * <code>ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}</code>
         * </p>
         * <p>
         * If this is a Shield Advanced policy, this string will be empty.
         * </p>
         * 
         * @param managedServiceData
         *        Details about the service. This contains <code>WAF</code> data in JSON format, as shown in the
         *        following example:</p>
         *        <p>
         *        <code>ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\": \"BLOCK\"}}</code>
         *        </p>
         *        <p>
         *        If this is a Shield Advanced policy, this string will be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedServiceData(String managedServiceData);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String managedServiceData;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityServicePolicyData model) {
            type(model.type);
            managedServiceData(model.managedServiceData);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityServiceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getManagedServiceData() {
            return managedServiceData;
        }

        @Override
        public final Builder managedServiceData(String managedServiceData) {
            this.managedServiceData = managedServiceData;
            return this;
        }

        public final void setManagedServiceData(String managedServiceData) {
            this.managedServiceData = managedServiceData;
        }

        @Override
        public SecurityServicePolicyData build() {
            return new SecurityServicePolicyData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
