/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForecastSummary> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ForecastSummary.getter(ForecastSummary::forecastArn)).setter(ForecastSummary.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ForecastSummary.getter(ForecastSummary::forecastName)).setter(ForecastSummary.setter(Builder::forecastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()}).build();
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ForecastSummary.getter(ForecastSummary::predictorArn)).setter(ForecastSummary.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ForecastSummary.getter(ForecastSummary::datasetGroupArn)).setter(ForecastSummary.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ForecastSummary.getter(ForecastSummary::status)).setter(ForecastSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ForecastSummary.getter(ForecastSummary::message)).setter(ForecastSummary.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ForecastSummary.getter(ForecastSummary::creationTime)).setter(ForecastSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ForecastSummary.getter(ForecastSummary::lastModificationTime)).setter(ForecastSummary.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD, FORECAST_NAME_FIELD, PREDICTOR_ARN_FIELD, DATASET_GROUP_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String forecastArn;
    private final String forecastName;
    private final String predictorArn;
    private final String datasetGroupArn;
    private final String status;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private ForecastSummary(BuilderImpl builder) {
        this.forecastArn = builder.forecastArn;
        this.forecastName = builder.forecastName;
        this.predictorArn = builder.predictorArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public String forecastArn() {
        return this.forecastArn;
    }

    public String forecastName() {
        return this.forecastName;
    }

    public String predictorArn() {
        return this.predictorArn;
    }

    public String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastSummary)) {
            return false;
        }
        ForecastSummary other = (ForecastSummary)obj;
        return Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.forecastName(), other.forecastName()) && Objects.equals(this.predictorArn(), other.predictorArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public String toString() {
        return ToString.builder((String)"ForecastSummary").add("ForecastArn", (Object)this.forecastArn()).add("ForecastName", (Object)this.forecastName()).add("PredictorArn", (Object)this.predictorArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("Status", (Object)this.status()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "ForecastName": {
                return Optional.ofNullable(clazz.cast(this.forecastName()));
            }
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
            case "DatasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ForecastSummary, T> g) {
        return obj -> g.apply((ForecastSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String forecastArn;
        private String forecastName;
        private String predictorArn;
        private String datasetGroupArn;
        private String status;
        private String message;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastSummary model) {
            this.forecastArn(model.forecastArn);
            this.forecastName(model.forecastName);
            this.predictorArn(model.predictorArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.status(model.status);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        public final String getForecastName() {
            return this.forecastName;
        }

        @Override
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        public ForecastSummary build() {
            return new ForecastSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForecastSummary> {
        public Builder forecastArn(String var1);

        public Builder forecastName(String var1);

        public Builder predictorArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder status(String var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

