/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides metrics that are used to evaluate the performance of a predictor. This object is part of the
 * <a>WindowSummary</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metrics implements SdkPojo, Serializable, ToCopyableBuilder<Metrics.Builder, Metrics> {
    private static final SdkField<Double> RMSE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Metrics::rmse)).setter(setter(Builder::rmse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RMSE").build()).build();

    private static final SdkField<List<WeightedQuantileLoss>> WEIGHTED_QUANTILE_LOSSES_FIELD = SdkField
            .<List<WeightedQuantileLoss>> builder(MarshallingType.LIST)
            .getter(getter(Metrics::weightedQuantileLosses))
            .setter(setter(Builder::weightedQuantileLosses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedQuantileLosses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WeightedQuantileLoss> builder(MarshallingType.SDK_POJO)
                                            .constructor(WeightedQuantileLoss::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RMSE_FIELD,
            WEIGHTED_QUANTILE_LOSSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double rmse;

    private final List<WeightedQuantileLoss> weightedQuantileLosses;

    private Metrics(BuilderImpl builder) {
        this.rmse = builder.rmse;
        this.weightedQuantileLosses = builder.weightedQuantileLosses;
    }

    /**
     * <p>
     * The root mean square error (RMSE).
     * </p>
     * 
     * @return The root mean square error (RMSE).
     */
    public Double rmse() {
        return rmse;
    }

    /**
     * <p>
     * An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal
     * probability. The distribution in this case is the loss function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal
     *         probability. The distribution in this case is the loss function.
     */
    public List<WeightedQuantileLoss> weightedQuantileLosses() {
        return weightedQuantileLosses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rmse());
        hashCode = 31 * hashCode + Objects.hashCode(weightedQuantileLosses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics) obj;
        return Objects.equals(rmse(), other.rmse()) && Objects.equals(weightedQuantileLosses(), other.weightedQuantileLosses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Metrics").add("RMSE", rmse()).add("WeightedQuantileLosses", weightedQuantileLosses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RMSE":
            return Optional.ofNullable(clazz.cast(rmse()));
        case "WeightedQuantileLosses":
            return Optional.ofNullable(clazz.cast(weightedQuantileLosses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metrics, T> g) {
        return obj -> g.apply((Metrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metrics> {
        /**
         * <p>
         * The root mean square error (RMSE).
         * </p>
         * 
         * @param rmse
         *        The root mean square error (RMSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rmse(Double rmse);

        /**
         * <p>
         * An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal
         * probability. The distribution in this case is the loss function.
         * </p>
         * 
         * @param weightedQuantileLosses
         *        An array of weighted quantile losses. Quantiles divide a probability distribution into regions of
         *        equal probability. The distribution in this case is the loss function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedQuantileLosses(Collection<WeightedQuantileLoss> weightedQuantileLosses);

        /**
         * <p>
         * An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal
         * probability. The distribution in this case is the loss function.
         * </p>
         * 
         * @param weightedQuantileLosses
         *        An array of weighted quantile losses. Quantiles divide a probability distribution into regions of
         *        equal probability. The distribution in this case is the loss function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedQuantileLosses(WeightedQuantileLoss... weightedQuantileLosses);

        /**
         * <p>
         * An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal
         * probability. The distribution in this case is the loss function.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WeightedQuantileLoss>.Builder} avoiding the
         * need to create one manually via {@link List<WeightedQuantileLoss>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WeightedQuantileLoss>.Builder#build()} is called immediately
         * and its result is passed to {@link #weightedQuantileLosses(List<WeightedQuantileLoss>)}.
         * 
         * @param weightedQuantileLosses
         *        a consumer that will call methods on {@link List<WeightedQuantileLoss>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weightedQuantileLosses(List<WeightedQuantileLoss>)
         */
        Builder weightedQuantileLosses(Consumer<WeightedQuantileLoss.Builder>... weightedQuantileLosses);
    }

    static final class BuilderImpl implements Builder {
        private Double rmse;

        private List<WeightedQuantileLoss> weightedQuantileLosses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            rmse(model.rmse);
            weightedQuantileLosses(model.weightedQuantileLosses);
        }

        public final Double getRmse() {
            return rmse;
        }

        @Override
        public final Builder rmse(Double rmse) {
            this.rmse = rmse;
            return this;
        }

        public final void setRmse(Double rmse) {
            this.rmse = rmse;
        }

        public final Collection<WeightedQuantileLoss.Builder> getWeightedQuantileLosses() {
            return weightedQuantileLosses != null ? weightedQuantileLosses.stream().map(WeightedQuantileLoss::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder weightedQuantileLosses(Collection<WeightedQuantileLoss> weightedQuantileLosses) {
            this.weightedQuantileLosses = WeightedQuantileLossesCopier.copy(weightedQuantileLosses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedQuantileLosses(WeightedQuantileLoss... weightedQuantileLosses) {
            weightedQuantileLosses(Arrays.asList(weightedQuantileLosses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedQuantileLosses(Consumer<WeightedQuantileLoss.Builder>... weightedQuantileLosses) {
            weightedQuantileLosses(Stream.of(weightedQuantileLosses)
                    .map(c -> WeightedQuantileLoss.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWeightedQuantileLosses(Collection<WeightedQuantileLoss.BuilderImpl> weightedQuantileLosses) {
            this.weightedQuantileLosses = WeightedQuantileLossesCopier.copyFromBuilder(weightedQuantileLosses);
        }

        @Override
        public Metrics build() {
            return new Metrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
