/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetGroupRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateDatasetGroupRequest.Builder, CreateDatasetGroupRequest> {
    private static final SdkField<String> DATASET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetGroupRequest::datasetGroupName)).setter(setter(Builder::datasetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupName").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetGroupRequest::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<List<String>> DATASET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDatasetGroupRequest::datasetArns))
            .setter(setter(Builder::datasetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_NAME_FIELD,
            DOMAIN_FIELD, DATASET_ARNS_FIELD));

    private final String datasetGroupName;

    private final String domain;

    private final List<String> datasetArns;

    private CreateDatasetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.datasetGroupName = builder.datasetGroupName;
        this.domain = builder.domain;
        this.datasetArns = builder.datasetArns;
    }

    /**
     * <p>
     * A name for the dataset group.
     * </p>
     * 
     * @return A name for the dataset group.
     */
    public String datasetGroupName() {
        return datasetGroupName;
    }

    /**
     * <p>
     * The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value
     * specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.
     * </p>
     * <p>
     * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be present in
     * training data that you import to a dataset. For example, if you choose the <code>RETAIL</code> domain and
     * <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that
     * <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data. For more
     * information, see <a>howitworks-datasets-groups</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset group. When you add a dataset to a dataset group, this value and
     *         the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must
     *         match.</p>
     *         <p>
     *         The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
     *         present in training data that you import to a dataset. For example, if you choose the <code>RETAIL</code>
     *         domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that
     *         <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data.
     *         For more information, see <a>howitworks-datasets-groups</a>.
     * @see Domain
     */
    public Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value
     * specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.
     * </p>
     * <p>
     * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be present in
     * training data that you import to a dataset. For example, if you choose the <code>RETAIL</code> domain and
     * <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that
     * <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data. For more
     * information, see <a>howitworks-datasets-groups</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset group. When you add a dataset to a dataset group, this value and
     *         the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must
     *         match.</p>
     *         <p>
     *         The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
     *         present in training data that you import to a dataset. For example, if you choose the <code>RETAIL</code>
     *         domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that
     *         <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data.
     *         For more information, see <a>howitworks-datasets-groups</a>.
     * @see Domain
     */
    public String domainAsString() {
        return domain;
    }

    /**
     * Returns true if the DatasetArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDatasetArns() {
        return datasetArns != null && !(datasetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDatasetArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
     */
    public List<String> datasetArns() {
        return datasetArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetGroupRequest)) {
            return false;
        }
        CreateDatasetGroupRequest other = (CreateDatasetGroupRequest) obj;
        return Objects.equals(datasetGroupName(), other.datasetGroupName())
                && Objects.equals(domainAsString(), other.domainAsString()) && Objects.equals(datasetArns(), other.datasetArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDatasetGroupRequest").add("DatasetGroupName", datasetGroupName())
                .add("Domain", domainAsString()).add("DatasetArns", datasetArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetGroupName":
            return Optional.ofNullable(clazz.cast(datasetGroupName()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "DatasetArns":
            return Optional.ofNullable(clazz.cast(datasetArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetGroupRequest, T> g) {
        return obj -> g.apply((CreateDatasetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetGroupRequest> {
        /**
         * <p>
         * A name for the dataset group.
         * </p>
         * 
         * @param datasetGroupName
         *        A name for the dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupName(String datasetGroupName);

        /**
         * <p>
         * The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the
         * value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.
         * </p>
         * <p>
         * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         * present in training data that you import to a dataset. For example, if you choose the <code>RETAIL</code>
         * domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that
         * <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data. For
         * more information, see <a>howitworks-datasets-groups</a>.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset group. When you add a dataset to a dataset group, this value
         *        and the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation
         *        must match.</p>
         *        <p>
         *        The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         *        present in training data that you import to a dataset. For example, if you choose the
         *        <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
         *        Forecast requires that <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields
         *        are present in your data. For more information, see <a>howitworks-datasets-groups</a>.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the
         * value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.
         * </p>
         * <p>
         * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         * present in training data that you import to a dataset. For example, if you choose the <code>RETAIL</code>
         * domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that
         * <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data. For
         * more information, see <a>howitworks-datasets-groups</a>.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset group. When you add a dataset to a dataset group, this value
         *        and the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation
         *        must match.</p>
         *        <p>
         *        The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         *        present in training data that you import to a dataset. For example, if you choose the
         *        <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
         *        Forecast requires that <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields
         *        are present in your data. For more information, see <a>howitworks-datasets-groups</a>.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
         * </p>
         * 
         * @param datasetArns
         *        An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArns(Collection<String> datasetArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
         * </p>
         * 
         * @param datasetArns
         *        An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArns(String... datasetArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String datasetGroupName;

        private String domain;

        private List<String> datasetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetGroupRequest model) {
            super(model);
            datasetGroupName(model.datasetGroupName);
            domain(model.domain);
            datasetArns(model.datasetArns);
        }

        public final String getDatasetGroupName() {
            return datasetGroupName;
        }

        @Override
        public final Builder datasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
            return this;
        }

        public final void setDatasetGroupName(String datasetGroupName) {
            this.datasetGroupName = datasetGroupName;
        }

        public final String getDomainAsString() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final Collection<String> getDatasetArns() {
            return datasetArns;
        }

        @Override
        public final Builder datasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetArns(String... datasetArns) {
            datasetArns(Arrays.asList(datasetArns));
            return this;
        }

        public final void setDatasetArns(Collection<String> datasetArns) {
            this.datasetArns = ArnListCopier.copy(datasetArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetGroupRequest build() {
            return new CreateDatasetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
