/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss;
import software.amazon.awssdk.services.forecast.model.WeightedQuantileLossesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metrics> {
    private static final SdkField<Double> RMSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Metrics.getter(Metrics::rmse)).setter(Metrics.setter(Builder::rmse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RMSE").build()}).build();
    private static final SdkField<List<WeightedQuantileLoss>> WEIGHTED_QUANTILE_LOSSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Metrics.getter(Metrics::weightedQuantileLosses)).setter(Metrics.setter(Builder::weightedQuantileLosses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedQuantileLosses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WeightedQuantileLoss::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RMSE_FIELD, WEIGHTED_QUANTILE_LOSSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double rmse;
    private final List<WeightedQuantileLoss> weightedQuantileLosses;

    private Metrics(BuilderImpl builder) {
        this.rmse = builder.rmse;
        this.weightedQuantileLosses = builder.weightedQuantileLosses;
    }

    public Double rmse() {
        return this.rmse;
    }

    public boolean hasWeightedQuantileLosses() {
        return this.weightedQuantileLosses != null && !(this.weightedQuantileLosses instanceof SdkAutoConstructList);
    }

    public List<WeightedQuantileLoss> weightedQuantileLosses() {
        return this.weightedQuantileLosses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rmse());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedQuantileLosses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)obj;
        return Objects.equals(this.rmse(), other.rmse()) && Objects.equals(this.weightedQuantileLosses(), other.weightedQuantileLosses());
    }

    public String toString() {
        return ToString.builder((String)"Metrics").add("RMSE", (Object)this.rmse()).add("WeightedQuantileLosses", this.weightedQuantileLosses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RMSE": {
                return Optional.ofNullable(clazz.cast(this.rmse()));
            }
            case "WeightedQuantileLosses": {
                return Optional.ofNullable(clazz.cast(this.weightedQuantileLosses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metrics, T> g) {
        return obj -> g.apply((Metrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double rmse;
        private List<WeightedQuantileLoss> weightedQuantileLosses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            this.rmse(model.rmse);
            this.weightedQuantileLosses(model.weightedQuantileLosses);
        }

        public final Double getRmse() {
            return this.rmse;
        }

        @Override
        public final Builder rmse(Double rmse) {
            this.rmse = rmse;
            return this;
        }

        public final void setRmse(Double rmse) {
            this.rmse = rmse;
        }

        public final Collection<WeightedQuantileLoss.Builder> getWeightedQuantileLosses() {
            return this.weightedQuantileLosses != null ? (Collection)this.weightedQuantileLosses.stream().map(WeightedQuantileLoss::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder weightedQuantileLosses(Collection<WeightedQuantileLoss> weightedQuantileLosses) {
            this.weightedQuantileLosses = WeightedQuantileLossesCopier.copy(weightedQuantileLosses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedQuantileLosses(WeightedQuantileLoss ... weightedQuantileLosses) {
            this.weightedQuantileLosses(Arrays.asList(weightedQuantileLosses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedQuantileLosses(Consumer<WeightedQuantileLoss.Builder> ... weightedQuantileLosses) {
            this.weightedQuantileLosses(Stream.of(weightedQuantileLosses).map(c -> (WeightedQuantileLoss)((WeightedQuantileLoss.Builder)WeightedQuantileLoss.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWeightedQuantileLosses(Collection<WeightedQuantileLoss.BuilderImpl> weightedQuantileLosses) {
            this.weightedQuantileLosses = WeightedQuantileLossesCopier.copyFromBuilder(weightedQuantileLosses);
        }

        public Metrics build() {
            return new Metrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metrics> {
        public Builder rmse(Double var1);

        public Builder weightedQuantileLosses(Collection<WeightedQuantileLoss> var1);

        public Builder weightedQuantileLosses(WeightedQuantileLoss ... var1);

        public Builder weightedQuantileLosses(Consumer<WeightedQuantileLoss.Builder> ... var1);
    }
}

