/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attribute of a schema, which defines a dataset field. A schema attribute is required for every field in a dataset.
 * The <a>Schema</a> object contains an array of <code>SchemaAttribute</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaAttribute implements SdkPojo, Serializable, ToCopyableBuilder<SchemaAttribute.Builder, SchemaAttribute> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SchemaAttribute::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SchemaAttribute::attributeTypeAsString)).setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ATTRIBUTE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String attributeType;

    private SchemaAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
    }

    /**
     * <p>
     * The name of the dataset field.
     * </p>
     * 
     * @return The name of the dataset field.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The data type of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The data type of the field.
     * @see AttributeType
     */
    public AttributeType attributeType() {
        return AttributeType.fromValue(attributeType);
    }

    /**
     * <p>
     * The data type of the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The data type of the field.
     * @see AttributeType
     */
    public String attributeTypeAsString() {
        return attributeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaAttribute)) {
            return false;
        }
        SchemaAttribute other = (SchemaAttribute) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeTypeAsString(), other.attributeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SchemaAttribute").add("AttributeName", attributeName())
                .add("AttributeType", attributeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaAttribute, T> g) {
        return obj -> g.apply((SchemaAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaAttribute> {
        /**
         * <p>
         * The name of the dataset field.
         * </p>
         * 
         * @param attributeName
         *        The name of the dataset field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The data type of the field.
         * </p>
         * 
         * @param attributeType
         *        The data type of the field.
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * The data type of the field.
         * </p>
         * 
         * @param attributeType
         *        The data type of the field.
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder attributeType(AttributeType attributeType);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeType;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaAttribute model) {
            attributeName(model.attributeName);
            attributeType(model.attributeType);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeType() {
            return attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(AttributeType attributeType) {
            this.attributeType(attributeType == null ? null : attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        @Override
        public SchemaAttribute build() {
            return new SchemaAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
