/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateForecastExportJobResponse extends ForecastResponse implements
        ToCopyableBuilder<CreateForecastExportJobResponse.Builder, CreateForecastExportJobResponse> {
    private static final SdkField<String> FORECAST_EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateForecastExportJobResponse::forecastExportJobArn)).setter(setter(Builder::forecastExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FORECAST_EXPORT_JOB_ARN_FIELD));

    private final String forecastExportJobArn;

    private CreateForecastExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.forecastExportJobArn = builder.forecastExportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the export job.
     */
    public String forecastExportJobArn() {
        return forecastExportJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forecastExportJobArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateForecastExportJobResponse)) {
            return false;
        }
        CreateForecastExportJobResponse other = (CreateForecastExportJobResponse) obj;
        return Objects.equals(forecastExportJobArn(), other.forecastExportJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateForecastExportJobResponse").add("ForecastExportJobArn", forecastExportJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastExportJobArn":
            return Optional.ofNullable(clazz.cast(forecastExportJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateForecastExportJobResponse, T> g) {
        return obj -> g.apply((CreateForecastExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateForecastExportJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the export job.
         * </p>
         * 
         * @param forecastExportJobArn
         *        The Amazon Resource Name (ARN) of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastExportJobArn(String forecastExportJobArn);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String forecastExportJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateForecastExportJobResponse model) {
            super(model);
            forecastExportJobArn(model.forecastExportJobArn);
        }

        public final String getForecastExportJobArn() {
            return forecastExportJobArn;
        }

        @Override
        public final Builder forecastExportJobArn(String forecastExportJobArn) {
            this.forecastExportJobArn = forecastExportJobArn;
            return this;
        }

        public final void setForecastExportJobArn(String forecastExportJobArn) {
            this.forecastExportJobArn = forecastExportJobArn;
        }

        @Override
        public CreateForecastExportJobResponse build() {
            return new CreateForecastExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
