/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.SupplementaryFeature;
import software.amazon.awssdk.services.forecast.model.SupplementaryFeaturesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDataConfig> {
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupArn").getter(InputDataConfig.getter(InputDataConfig::datasetGroupArn)).setter(InputDataConfig.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()}).build();
    private static final SdkField<List<SupplementaryFeature>> SUPPLEMENTARY_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupplementaryFeatures").getter(InputDataConfig.getter(InputDataConfig::supplementaryFeatures)).setter(InputDataConfig.setter(Builder::supplementaryFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementaryFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupplementaryFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_ARN_FIELD, SUPPLEMENTARY_FEATURES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String datasetGroupArn;
    private final List<SupplementaryFeature> supplementaryFeatures;

    private InputDataConfig(BuilderImpl builder) {
        this.datasetGroupArn = builder.datasetGroupArn;
        this.supplementaryFeatures = builder.supplementaryFeatures;
    }

    public String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public boolean hasSupplementaryFeatures() {
        return this.supplementaryFeatures != null && !(this.supplementaryFeatures instanceof SdkAutoConstructList);
    }

    public List<SupplementaryFeature> supplementaryFeatures() {
        return this.supplementaryFeatures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementaryFeatures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig)obj;
        return Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.supplementaryFeatures(), other.supplementaryFeatures());
    }

    public String toString() {
        return ToString.builder((String)"InputDataConfig").add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("SupplementaryFeatures", this.supplementaryFeatures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "SupplementaryFeatures": {
                return Optional.ofNullable(clazz.cast(this.supplementaryFeatures()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetGroupArn;
        private List<SupplementaryFeature> supplementaryFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            this.datasetGroupArn(model.datasetGroupArn);
            this.supplementaryFeatures(model.supplementaryFeatures);
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        public final Collection<SupplementaryFeature.Builder> getSupplementaryFeatures() {
            return this.supplementaryFeatures != null ? (Collection)this.supplementaryFeatures.stream().map(SupplementaryFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supplementaryFeatures(Collection<SupplementaryFeature> supplementaryFeatures) {
            this.supplementaryFeatures = SupplementaryFeaturesCopier.copy(supplementaryFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementaryFeatures(SupplementaryFeature ... supplementaryFeatures) {
            this.supplementaryFeatures(Arrays.asList(supplementaryFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supplementaryFeatures(Consumer<SupplementaryFeature.Builder> ... supplementaryFeatures) {
            this.supplementaryFeatures(Stream.of(supplementaryFeatures).map(c -> (SupplementaryFeature)((SupplementaryFeature.Builder)SupplementaryFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupplementaryFeatures(Collection<SupplementaryFeature.BuilderImpl> supplementaryFeatures) {
            this.supplementaryFeatures = SupplementaryFeaturesCopier.copyFromBuilder(supplementaryFeatures);
        }

        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDataConfig> {
        public Builder datasetGroupArn(String var1);

        public Builder supplementaryFeatures(Collection<SupplementaryFeature> var1);

        public Builder supplementaryFeatures(SupplementaryFeature ... var1);

        public Builder supplementaryFeatures(Consumer<SupplementaryFeature.Builder> ... var1);
    }
}

