/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary;
import software.amazon.awssdk.services.forecast.model.DatasetImportJobsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetImportJobsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, ListDatasetImportJobsResponse> {
    private static final SdkField<List<DatasetImportJobSummary>> DATASET_IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatasetImportJobs").getter(ListDatasetImportJobsResponse.getter(ListDatasetImportJobsResponse::datasetImportJobs)).setter(ListDatasetImportJobsResponse.setter(Builder::datasetImportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetImportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDatasetImportJobsResponse.getter(ListDatasetImportJobsResponse::nextToken)).setter(ListDatasetImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatasetImportJobSummary> datasetImportJobs;
    private final String nextToken;

    private ListDatasetImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobs = builder.datasetImportJobs;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDatasetImportJobs() {
        return this.datasetImportJobs != null && !(this.datasetImportJobs instanceof SdkAutoConstructList);
    }

    public List<DatasetImportJobSummary> datasetImportJobs() {
        return this.datasetImportJobs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetImportJobs() ? this.datasetImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetImportJobsResponse)) {
            return false;
        }
        ListDatasetImportJobsResponse other = (ListDatasetImportJobsResponse)((Object)obj);
        return this.hasDatasetImportJobs() == other.hasDatasetImportJobs() && Objects.equals(this.datasetImportJobs(), other.datasetImportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatasetImportJobsResponse").add("DatasetImportJobs", this.hasDatasetImportJobs() ? this.datasetImportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetImportJobs": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetImportJobsResponse, T> g) {
        return obj -> g.apply((ListDatasetImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<DatasetImportJobSummary> datasetImportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetImportJobsResponse model) {
            super(model);
            this.datasetImportJobs(model.datasetImportJobs);
            this.nextToken(model.nextToken);
        }

        public final Collection<DatasetImportJobSummary.Builder> getDatasetImportJobs() {
            if (this.datasetImportJobs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datasetImportJobs != null ? (Collection)this.datasetImportJobs.stream().map(DatasetImportJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasetImportJobs(Collection<DatasetImportJobSummary> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copy(datasetImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobs(DatasetImportJobSummary ... datasetImportJobs) {
            this.datasetImportJobs(Arrays.asList(datasetImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder> ... datasetImportJobs) {
            this.datasetImportJobs(Stream.of(datasetImportJobs).map(c -> (DatasetImportJobSummary)((DatasetImportJobSummary.Builder)DatasetImportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatasetImportJobs(Collection<DatasetImportJobSummary.BuilderImpl> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copyFromBuilder(datasetImportJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetImportJobsResponse build() {
            return new ListDatasetImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetImportJobsResponse> {
        public Builder datasetImportJobs(Collection<DatasetImportJobSummary> var1);

        public Builder datasetImportJobs(DatasetImportJobSummary ... var1);

        public Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

