/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePredictorBacktestExportJobRequest extends ForecastRequest implements
        ToCopyableBuilder<DeletePredictorBacktestExportJobRequest.Builder, DeletePredictorBacktestExportJobRequest> {
    private static final SdkField<String> PREDICTOR_BACKTEST_EXPORT_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredictorBacktestExportJobArn")
            .getter(getter(DeletePredictorBacktestExportJobRequest::predictorBacktestExportJobArn))
            .setter(setter(Builder::predictorBacktestExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PREDICTOR_BACKTEST_EXPORT_JOB_ARN_FIELD));

    private final String predictorBacktestExportJobArn;

    private DeletePredictorBacktestExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.predictorBacktestExportJobArn = builder.predictorBacktestExportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor backtest export job to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor backtest export job to delete.
     */
    public String predictorBacktestExportJobArn() {
        return predictorBacktestExportJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorBacktestExportJobArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePredictorBacktestExportJobRequest)) {
            return false;
        }
        DeletePredictorBacktestExportJobRequest other = (DeletePredictorBacktestExportJobRequest) obj;
        return Objects.equals(predictorBacktestExportJobArn(), other.predictorBacktestExportJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePredictorBacktestExportJobRequest")
                .add("PredictorBacktestExportJobArn", predictorBacktestExportJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorBacktestExportJobArn":
            return Optional.ofNullable(clazz.cast(predictorBacktestExportJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePredictorBacktestExportJobRequest, T> g) {
        return obj -> g.apply((DeletePredictorBacktestExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePredictorBacktestExportJobRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor backtest export job to delete.
         * </p>
         * 
         * @param predictorBacktestExportJobArn
         *        The Amazon Resource Name (ARN) of the predictor backtest export job to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorBacktestExportJobArn(String predictorBacktestExportJobArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String predictorBacktestExportJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePredictorBacktestExportJobRequest model) {
            super(model);
            predictorBacktestExportJobArn(model.predictorBacktestExportJobArn);
        }

        public final String getPredictorBacktestExportJobArn() {
            return predictorBacktestExportJobArn;
        }

        @Override
        public final Builder predictorBacktestExportJobArn(String predictorBacktestExportJobArn) {
            this.predictorBacktestExportJobArn = predictorBacktestExportJobArn;
            return this;
        }

        public final void setPredictorBacktestExportJobArn(String predictorBacktestExportJobArn) {
            this.predictorBacktestExportJobArn = predictorBacktestExportJobArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePredictorBacktestExportJobRequest build() {
            return new DeletePredictorBacktestExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
