/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetsResponse extends ForecastResponse implements
        ToCopyableBuilder<ListDatasetsResponse.Builder, ListDatasetsResponse> {
    private static final SdkField<List<DatasetSummary>> DATASETS_FIELD = SdkField
            .<List<DatasetSummary>> builder(MarshallingType.LIST)
            .memberName("Datasets")
            .getter(getter(ListDatasetsResponse::datasets))
            .setter(setter(Builder::datasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datasets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDatasetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DatasetSummary> datasets;

    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Datasets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDatasets() {
        return datasets != null && !(datasets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that summarize each dataset's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDatasets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that summarize each dataset's properties.
     */
    public final List<DatasetSummary> datasets() {
        return datasets;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the
     * token in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
     *         use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasets() ? datasets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse) obj;
        return hasDatasets() == other.hasDatasets() && Objects.equals(datasets(), other.datasets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDatasetsResponse").add("Datasets", hasDatasets() ? datasets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Datasets":
            return Optional.ofNullable(clazz.cast(datasets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetsResponse, T> g) {
        return obj -> g.apply((ListDatasetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDatasetsResponse> {
        /**
         * <p>
         * An array of objects that summarize each dataset's properties.
         * </p>
         * 
         * @param datasets
         *        An array of objects that summarize each dataset's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(Collection<DatasetSummary> datasets);

        /**
         * <p>
         * An array of objects that summarize each dataset's properties.
         * </p>
         * 
         * @param datasets
         *        An array of objects that summarize each dataset's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasets(DatasetSummary... datasets);

        /**
         * <p>
         * An array of objects that summarize each dataset's properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetSummary>.Builder} avoiding the need
         * to create one manually via {@link List<DatasetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #datasets(List<DatasetSummary>)}.
         * 
         * @param datasets
         *        a consumer that will call methods on {@link List<DatasetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasets(List<DatasetSummary>)
         */
        Builder datasets(Consumer<DatasetSummary.Builder>... datasets);

        /**
         * <p>
         * If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results,
         *        use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<DatasetSummary> datasets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            super(model);
            datasets(model.datasets);
            nextToken(model.nextToken);
        }

        public final Collection<DatasetSummary.Builder> getDatasets() {
            if (datasets instanceof SdkAutoConstructList) {
                return null;
            }
            return datasets != null ? datasets.stream().map(DatasetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasets(Collection<DatasetSummary> datasets) {
            this.datasets = DatasetsCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DatasetSummary... datasets) {
            datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DatasetSummary.Builder>... datasets) {
            datasets(Stream.of(datasets).map(c -> DatasetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatasets(Collection<DatasetSummary.BuilderImpl> datasets) {
            this.datasets = DatasetsCopier.copyFromBuilder(datasets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
