/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccuracyMetricsResponse extends ForecastResponse implements
        ToCopyableBuilder<GetAccuracyMetricsResponse.Builder, GetAccuracyMetricsResponse> {
    private static final SdkField<List<EvaluationResult>> PREDICTOR_EVALUATION_RESULTS_FIELD = SdkField
            .<List<EvaluationResult>> builder(MarshallingType.LIST)
            .memberName("PredictorEvaluationResults")
            .getter(getter(GetAccuracyMetricsResponse::predictorEvaluationResults))
            .setter(setter(Builder::predictorEvaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorEvaluationResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PREDICTOR_EVALUATION_RESULTS_FIELD));

    private final List<EvaluationResult> predictorEvaluationResults;

    private GetAccuracyMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.predictorEvaluationResults = builder.predictorEvaluationResults;
    }

    /**
     * Returns true if the PredictorEvaluationResults property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasPredictorEvaluationResults() {
        return predictorEvaluationResults != null && !(predictorEvaluationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of results from evaluating the predictor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPredictorEvaluationResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of results from evaluating the predictor.
     */
    public final List<EvaluationResult> predictorEvaluationResults() {
        return predictorEvaluationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictorEvaluationResults() ? predictorEvaluationResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccuracyMetricsResponse)) {
            return false;
        }
        GetAccuracyMetricsResponse other = (GetAccuracyMetricsResponse) obj;
        return hasPredictorEvaluationResults() == other.hasPredictorEvaluationResults()
                && Objects.equals(predictorEvaluationResults(), other.predictorEvaluationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccuracyMetricsResponse")
                .add("PredictorEvaluationResults", hasPredictorEvaluationResults() ? predictorEvaluationResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorEvaluationResults":
            return Optional.ofNullable(clazz.cast(predictorEvaluationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccuracyMetricsResponse, T> g) {
        return obj -> g.apply((GetAccuracyMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccuracyMetricsResponse> {
        /**
         * <p>
         * An array of results from evaluating the predictor.
         * </p>
         * 
         * @param predictorEvaluationResults
         *        An array of results from evaluating the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorEvaluationResults(Collection<EvaluationResult> predictorEvaluationResults);

        /**
         * <p>
         * An array of results from evaluating the predictor.
         * </p>
         * 
         * @param predictorEvaluationResults
         *        An array of results from evaluating the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorEvaluationResults(EvaluationResult... predictorEvaluationResults);

        /**
         * <p>
         * An array of results from evaluating the predictor.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EvaluationResult>.Builder} avoiding the
         * need to create one manually via {@link List<EvaluationResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluationResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #predictorEvaluationResults(List<EvaluationResult>)}.
         * 
         * @param predictorEvaluationResults
         *        a consumer that will call methods on {@link List<EvaluationResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictorEvaluationResults(List<EvaluationResult>)
         */
        Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder>... predictorEvaluationResults);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private List<EvaluationResult> predictorEvaluationResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccuracyMetricsResponse model) {
            super(model);
            predictorEvaluationResults(model.predictorEvaluationResults);
        }

        public final List<EvaluationResult.Builder> getPredictorEvaluationResults() {
            List<EvaluationResult.Builder> result = PredictorEvaluationResultsCopier
                    .copyToBuilder(this.predictorEvaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder predictorEvaluationResults(Collection<EvaluationResult> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copy(predictorEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorEvaluationResults(EvaluationResult... predictorEvaluationResults) {
            predictorEvaluationResults(Arrays.asList(predictorEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder>... predictorEvaluationResults) {
            predictorEvaluationResults(Stream.of(predictorEvaluationResults)
                    .map(c -> EvaluationResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPredictorEvaluationResults(Collection<EvaluationResult.BuilderImpl> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copyFromBuilder(predictorEvaluationResults);
        }

        @Override
        public GetAccuracyMetricsResponse build() {
            return new GetAccuracyMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
