/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateDatasetRequest.Builder, CreateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(CreateDatasetRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(CreateDatasetRequest::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(CreateDatasetRequest::datasetTypeAsString))
            .setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> DATA_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFrequency").getter(getter(CreateDatasetRequest::dataFrequency))
            .setter(setter(Builder::dataFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFrequency").build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(CreateDatasetRequest::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfig")
            .getter(getter(CreateDatasetRequest::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDatasetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            DOMAIN_FIELD, DATASET_TYPE_FIELD, DATA_FREQUENCY_FIELD, SCHEMA_FIELD, ENCRYPTION_CONFIG_FIELD, TAGS_FIELD));

    private final String datasetName;

    private final String domain;

    private final String datasetType;

    private final String dataFrequency;

    private final Schema schema;

    private final EncryptionConfig encryptionConfig;

    private final List<Tag> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.domain = builder.domain;
        this.datasetType = builder.datasetType;
        this.dataFrequency = builder.dataFrequency;
        this.schema = builder.schema;
        this.encryptionConfig = builder.encryptionConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the dataset.
     * </p>
     * 
     * @return A name for the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value
     * specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.
     * </p>
     * <p>
     * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be present in
     * the training data that you import to the dataset. For example, if you choose the <code>RETAIL</code> domain and
     * <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires <code>item_id</code>,
     * <code>timestamp</code>, and <code>demand</code> fields to be present in your data. For more information, see
     * <a>howitworks-datasets-groups</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset. When you add a dataset to a dataset group, this value and the
     *         value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must
     *         match.</p>
     *         <p>
     *         The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
     *         present in the training data that you import to the dataset. For example, if you choose the
     *         <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
     *         Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be
     *         present in your data. For more information, see <a>howitworks-datasets-groups</a>.
     * @see Domain
     */
    public final Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value
     * specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.
     * </p>
     * <p>
     * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be present in
     * the training data that you import to the dataset. For example, if you choose the <code>RETAIL</code> domain and
     * <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires <code>item_id</code>,
     * <code>timestamp</code>, and <code>demand</code> fields to be present in your data. For more information, see
     * <a>howitworks-datasets-groups</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return The domain associated with the dataset. When you add a dataset to a dataset group, this value and the
     *         value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must
     *         match.</p>
     *         <p>
     *         The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
     *         present in the training data that you import to the dataset. For example, if you choose the
     *         <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
     *         Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be
     *         present in your data. For more information, see <a>howitworks-datasets-groups</a>.
     * @see Domain
     */
    public final String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * The dataset type. Valid values depend on the chosen <code>Domain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type. Valid values depend on the chosen <code>Domain</code>.
     * @see DatasetType
     */
    public final DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The dataset type. Valid values depend on the chosen <code>Domain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The dataset type. Valid values depend on the chosen <code>Domain</code>.
     * @see DatasetType
     */
    public final String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.
     * </p>
     * <p>
     * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
     * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "D" indicates every day and "15min"
     * indicates every 15 minutes.
     * </p>
     * 
     * @return The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.</p>
     *         <p>
     *         Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
     *         minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "D" indicates every day
     *         and "15min" indicates every 15 minutes.
     */
    public final String dataFrequency() {
        return dataFrequency;
    }

    /**
     * <p>
     * The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset
     * <code>Domain</code> and <code>DatasetType</code> that you choose determine the minimum required fields in your
     * training data. For information about the required fields for a specific dataset domain and type, see
     * <a>howitworks-domains-ds-types</a>.
     * </p>
     * 
     * @return The schema for the dataset. The schema attributes and their order must match the fields in your data. The
     *         dataset <code>Domain</code> and <code>DatasetType</code> that you choose determine the minimum required
     *         fields in your training data. For information about the required fields for a specific dataset domain and
     *         type, see <a>howitworks-domains-ds-types</a>.
     */
    public final Schema schema() {
        return schema;
    }

    /**
     * <p>
     * An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
     * Forecast can assume to access the key.
     * </p>
     * 
     * @return An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
     *         Forecast can assume to access the key.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
     * prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be
     * a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not
     * count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix.
     *         Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then
     *         Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the
     *         key prefix of <code>aws</code> do not count against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(domainAsString(), other.domainAsString())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(dataFrequency(), other.dataFrequency()) && Objects.equals(schema(), other.schema())
                && Objects.equals(encryptionConfig(), other.encryptionConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetRequest").add("DatasetName", datasetName()).add("Domain", domainAsString())
                .add("DatasetType", datasetTypeAsString()).add("DataFrequency", dataFrequency()).add("Schema", schema())
                .add("EncryptionConfig", encryptionConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "DataFrequency":
            return Optional.ofNullable(clazz.cast(dataFrequency()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetRequest> {
        /**
         * <p>
         * A name for the dataset.
         * </p>
         * 
         * @param datasetName
         *        A name for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value
         * specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.
         * </p>
         * <p>
         * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         * present in the training data that you import to the dataset. For example, if you choose the
         * <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
         * Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be present
         * in your data. For more information, see <a>howitworks-datasets-groups</a>.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset. When you add a dataset to a dataset group, this value and the
         *        value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must
         *        match.</p>
         *        <p>
         *        The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         *        present in the training data that you import to the dataset. For example, if you choose the
         *        <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
         *        Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be
         *        present in your data. For more information, see <a>howitworks-datasets-groups</a>.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value
         * specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.
         * </p>
         * <p>
         * The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         * present in the training data that you import to the dataset. For example, if you choose the
         * <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
         * Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be present
         * in your data. For more information, see <a>howitworks-datasets-groups</a>.
         * </p>
         * 
         * @param domain
         *        The domain associated with the dataset. When you add a dataset to a dataset group, this value and the
         *        value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must
         *        match.</p>
         *        <p>
         *        The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be
         *        present in the training data that you import to the dataset. For example, if you choose the
         *        <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon
         *        Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be
         *        present in your data. For more information, see <a>howitworks-datasets-groups</a>.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        /**
         * <p>
         * The dataset type. Valid values depend on the chosen <code>Domain</code>.
         * </p>
         * 
         * @param datasetType
         *        The dataset type. Valid values depend on the chosen <code>Domain</code>.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The dataset type. Valid values depend on the chosen <code>Domain</code>.
         * </p>
         * 
         * @param datasetType
         *        The dataset type. Valid values depend on the chosen <code>Domain</code>.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.
         * </p>
         * <p>
         * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
         * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "D" indicates every day and "15min"
         * indicates every 15 minutes.
         * </p>
         * 
         * @param dataFrequency
         *        The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.</p>
         *        <p>
         *        Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
         *        minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "D" indicates every
         *        day and "15min" indicates every 15 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFrequency(String dataFrequency);

        /**
         * <p>
         * The schema for the dataset. The schema attributes and their order must match the fields in your data. The
         * dataset <code>Domain</code> and <code>DatasetType</code> that you choose determine the minimum required
         * fields in your training data. For information about the required fields for a specific dataset domain and
         * type, see <a>howitworks-domains-ds-types</a>.
         * </p>
         * 
         * @param schema
         *        The schema for the dataset. The schema attributes and their order must match the fields in your data.
         *        The dataset <code>Domain</code> and <code>DatasetType</code> that you choose determine the minimum
         *        required fields in your training data. For information about the required fields for a specific
         *        dataset domain and type, see <a>howitworks-domains-ds-types</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * <p>
         * The schema for the dataset. The schema attributes and their order must match the fields in your data. The
         * dataset <code>Domain</code> and <code>DatasetType</code> that you choose determine the minimum required
         * fields in your training data. For information about the required fields for a specific dataset domain and
         * type, see <a>howitworks-domains-ds-types</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link Schema.Builder} avoiding the need to create one
         * manually via {@link Schema#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the key.
         * </p>
         * 
         * @param encryptionConfig
         *        An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * <p>
         * An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the key.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }

        /**
         * <p>
         * The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have
         * this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers
         * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix.
         *        Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
         *        then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with
         *        only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have
         * this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers
         * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix.
         *        Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
         *        then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with
         *        only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have
         * this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers
         * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String datasetName;

        private String domain;

        private String datasetType;

        private String dataFrequency;

        private Schema schema;

        private EncryptionConfig encryptionConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            datasetName(model.datasetName);
            domain(model.domain);
            datasetType(model.datasetType);
            dataFrequency(model.dataFrequency);
            schema(model.schema);
            encryptionConfig(model.encryptionConfig);
            tags(model.tags);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        public final String getDataFrequency() {
            return dataFrequency;
        }

        @Override
        public final Builder dataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
            return this;
        }

        public final void setDataFrequency(String dataFrequency) {
            this.dataFrequency = dataFrequency;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
