/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExplainabilityExportRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateExplainabilityExportRequest.Builder, CreateExplainabilityExportRequest> {
    private static final SdkField<String> EXPLAINABILITY_EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityExportName").getter(getter(CreateExplainabilityExportRequest::explainabilityExportName))
            .setter(setter(Builder::explainabilityExportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityExportName").build())
            .build();

    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityArn").getter(getter(CreateExplainabilityExportRequest::explainabilityArn))
            .setter(setter(Builder::explainabilityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()).build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(CreateExplainabilityExportRequest::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateExplainabilityExportRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPLAINABILITY_EXPORT_NAME_FIELD, EXPLAINABILITY_ARN_FIELD, DESTINATION_FIELD, TAGS_FIELD));

    private final String explainabilityExportName;

    private final String explainabilityArn;

    private final DataDestination destination;

    private final List<Tag> tags;

    private CreateExplainabilityExportRequest(BuilderImpl builder) {
        super(builder);
        this.explainabilityExportName = builder.explainabilityExportName;
        this.explainabilityArn = builder.explainabilityArn;
        this.destination = builder.destination;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name for the Explainability export.
     * </p>
     * 
     * @return A unique name for the Explainability export.
     */
    public final String explainabilityExportName() {
        return explainabilityExportName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Explainability to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Explainability to export.
     */
    public final String explainabilityArn() {
        return explainabilityArn;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an optional
     * value, both of which you define. Tag keys and values are case sensitive.
     * </p>
     * <p>
     * The following restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For each resource, each tag key must be unique and each tag key must have one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum number of tags per resource: 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging
     * schema is used across other services and resources, the character restrictions of those services also apply.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>. Values
     * can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast considers
     * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
     * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with this
     * prefix.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
     *         optional value, both of which you define. Tag keys and values are case sensitive.</p>
     *         <p>
     *         The following restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique and each tag key must have one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource: 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
     *         tagging schema is used across other services and resources, the character restrictions of those services
     *         also apply.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
     *         Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
     *         Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the
     *         key prefix of <code>aws</code> do not count against your tags per resource limit. You cannot edit or
     *         delete tag keys with this prefix.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityExportName());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExplainabilityExportRequest)) {
            return false;
        }
        CreateExplainabilityExportRequest other = (CreateExplainabilityExportRequest) obj;
        return Objects.equals(explainabilityExportName(), other.explainabilityExportName())
                && Objects.equals(explainabilityArn(), other.explainabilityArn())
                && Objects.equals(destination(), other.destination()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExplainabilityExportRequest").add("ExplainabilityExportName", explainabilityExportName())
                .add("ExplainabilityArn", explainabilityArn()).add("Destination", destination())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplainabilityExportName":
            return Optional.ofNullable(clazz.cast(explainabilityExportName()));
        case "ExplainabilityArn":
            return Optional.ofNullable(clazz.cast(explainabilityArn()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExplainabilityExportRequest, T> g) {
        return obj -> g.apply((CreateExplainabilityExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateExplainabilityExportRequest> {
        /**
         * <p>
         * A unique name for the Explainability export.
         * </p>
         * 
         * @param explainabilityExportName
         *        A unique name for the Explainability export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityExportName(String explainabilityExportName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Explainability to export.
         * </p>
         * 
         * @param explainabilityArn
         *        The Amazon Resource Name (ARN) of the Explainability to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityArn(String explainabilityArn);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataDestination.Builder} avoiding the need to
         * create one manually via {@link DataDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your resources. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your resources. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your resources. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String explainabilityExportName;

        private String explainabilityArn;

        private DataDestination destination;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExplainabilityExportRequest model) {
            super(model);
            explainabilityExportName(model.explainabilityExportName);
            explainabilityArn(model.explainabilityArn);
            destination(model.destination);
            tags(model.tags);
        }

        public final String getExplainabilityExportName() {
            return explainabilityExportName;
        }

        public final void setExplainabilityExportName(String explainabilityExportName) {
            this.explainabilityExportName = explainabilityExportName;
        }

        @Override
        @Transient
        public final Builder explainabilityExportName(String explainabilityExportName) {
            this.explainabilityExportName = explainabilityExportName;
            return this;
        }

        public final String getExplainabilityArn() {
            return explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        @Transient
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExplainabilityExportRequest build() {
            return new CreateExplainabilityExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
