/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class TestWindowDetailsCopier {
    static List<TestWindowSummary> copy(Collection<? extends TestWindowSummary> testWindowDetailsParam) {
        List<TestWindowSummary> list;
        if (testWindowDetailsParam == null || testWindowDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TestWindowSummary> modifiableList = new ArrayList<>();
            testWindowDetailsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TestWindowSummary> copyFromBuilder(Collection<? extends TestWindowSummary.Builder> testWindowDetailsParam) {
        List<TestWindowSummary> list;
        if (testWindowDetailsParam == null || testWindowDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TestWindowSummary> modifiableList = new ArrayList<>();
            testWindowDetailsParam.forEach(entry -> {
                TestWindowSummary member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TestWindowSummary.Builder> copyToBuilder(Collection<? extends TestWindowSummary> testWindowDetailsParam) {
        List<TestWindowSummary.Builder> list;
        if (testWindowDetailsParam == null || testWindowDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TestWindowSummary.Builder> modifiableList = new ArrayList<>();
            testWindowDetailsParam.forEach(entry -> {
                TestWindowSummary.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
