/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.DataConfig;
import software.amazon.awssdk.services.forecast.model.EncryptionConfig;
import software.amazon.awssdk.services.forecast.model.ForecastDimensionsCopier;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.ForecastTypesCopier;
import software.amazon.awssdk.services.forecast.model.OptimizationMetric;
import software.amazon.awssdk.services.forecast.model.Tag;
import software.amazon.awssdk.services.forecast.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutoPredictorRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateAutoPredictorRequest> {
    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PredictorName").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::predictorName)).setter(CreateAutoPredictorRequest.setter(Builder::predictorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()}).build();
    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ForecastHorizon").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::forecastHorizon)).setter(CreateAutoPredictorRequest.setter(Builder::forecastHorizon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()}).build();
    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastTypes").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::forecastTypes)).setter(CreateAutoPredictorRequest.setter(Builder::forecastTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FORECAST_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastDimensions").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::forecastDimensions)).setter(CreateAutoPredictorRequest.setter(Builder::forecastDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FORECAST_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastFrequency").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::forecastFrequency)).setter(CreateAutoPredictorRequest.setter(Builder::forecastFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastFrequency").build()}).build();
    private static final SdkField<DataConfig> DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataConfig").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::dataConfig)).setter(CreateAutoPredictorRequest.setter(Builder::dataConfig)).constructor(DataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataConfig").build()}).build();
    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfig").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::encryptionConfig)).setter(CreateAutoPredictorRequest.setter(Builder::encryptionConfig)).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()}).build();
    private static final SdkField<String> REFERENCE_PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReferencePredictorArn").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::referencePredictorArn)).setter(CreateAutoPredictorRequest.setter(Builder::referencePredictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePredictorArn").build()}).build();
    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationMetric").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::optimizationMetricAsString)).setter(CreateAutoPredictorRequest.setter(Builder::optimizationMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build()}).build();
    private static final SdkField<Boolean> EXPLAIN_PREDICTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExplainPredictor").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::explainPredictor)).setter(CreateAutoPredictorRequest.setter(Builder::explainPredictor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainPredictor").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAutoPredictorRequest.getter(CreateAutoPredictorRequest::tags)).setter(CreateAutoPredictorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_NAME_FIELD, FORECAST_HORIZON_FIELD, FORECAST_TYPES_FIELD, FORECAST_DIMENSIONS_FIELD, FORECAST_FREQUENCY_FIELD, DATA_CONFIG_FIELD, ENCRYPTION_CONFIG_FIELD, REFERENCE_PREDICTOR_ARN_FIELD, OPTIMIZATION_METRIC_FIELD, EXPLAIN_PREDICTOR_FIELD, TAGS_FIELD));
    private final String predictorName;
    private final Integer forecastHorizon;
    private final List<String> forecastTypes;
    private final List<String> forecastDimensions;
    private final String forecastFrequency;
    private final DataConfig dataConfig;
    private final EncryptionConfig encryptionConfig;
    private final String referencePredictorArn;
    private final String optimizationMetric;
    private final Boolean explainPredictor;
    private final List<Tag> tags;

    private CreateAutoPredictorRequest(BuilderImpl builder) {
        super(builder);
        this.predictorName = builder.predictorName;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastTypes = builder.forecastTypes;
        this.forecastDimensions = builder.forecastDimensions;
        this.forecastFrequency = builder.forecastFrequency;
        this.dataConfig = builder.dataConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.referencePredictorArn = builder.referencePredictorArn;
        this.optimizationMetric = builder.optimizationMetric;
        this.explainPredictor = builder.explainPredictor;
        this.tags = builder.tags;
    }

    public final String predictorName() {
        return this.predictorName;
    }

    public final Integer forecastHorizon() {
        return this.forecastHorizon;
    }

    public final boolean hasForecastTypes() {
        return this.forecastTypes != null && !(this.forecastTypes instanceof SdkAutoConstructList);
    }

    public final List<String> forecastTypes() {
        return this.forecastTypes;
    }

    public final boolean hasForecastDimensions() {
        return this.forecastDimensions != null && !(this.forecastDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> forecastDimensions() {
        return this.forecastDimensions;
    }

    public final String forecastFrequency() {
        return this.forecastFrequency;
    }

    public final DataConfig dataConfig() {
        return this.dataConfig;
    }

    public final EncryptionConfig encryptionConfig() {
        return this.encryptionConfig;
    }

    public final String referencePredictorArn() {
        return this.referencePredictorArn;
    }

    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(this.optimizationMetric);
    }

    public final String optimizationMetricAsString() {
        return this.optimizationMetric;
    }

    public final Boolean explainPredictor() {
        return this.explainPredictor;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastTypes() ? this.forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastDimensions() ? this.forecastDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.referencePredictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainPredictor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoPredictorRequest)) {
            return false;
        }
        CreateAutoPredictorRequest other = (CreateAutoPredictorRequest)((Object)obj);
        return Objects.equals(this.predictorName(), other.predictorName()) && Objects.equals(this.forecastHorizon(), other.forecastHorizon()) && this.hasForecastTypes() == other.hasForecastTypes() && Objects.equals(this.forecastTypes(), other.forecastTypes()) && this.hasForecastDimensions() == other.hasForecastDimensions() && Objects.equals(this.forecastDimensions(), other.forecastDimensions()) && Objects.equals(this.forecastFrequency(), other.forecastFrequency()) && Objects.equals(this.dataConfig(), other.dataConfig()) && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.referencePredictorArn(), other.referencePredictorArn()) && Objects.equals(this.optimizationMetricAsString(), other.optimizationMetricAsString()) && Objects.equals(this.explainPredictor(), other.explainPredictor()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAutoPredictorRequest").add("PredictorName", (Object)this.predictorName()).add("ForecastHorizon", (Object)this.forecastHorizon()).add("ForecastTypes", this.hasForecastTypes() ? this.forecastTypes() : null).add("ForecastDimensions", this.hasForecastDimensions() ? this.forecastDimensions() : null).add("ForecastFrequency", (Object)this.forecastFrequency()).add("DataConfig", (Object)this.dataConfig()).add("EncryptionConfig", (Object)this.encryptionConfig()).add("ReferencePredictorArn", (Object)this.referencePredictorArn()).add("OptimizationMetric", (Object)this.optimizationMetricAsString()).add("ExplainPredictor", (Object)this.explainPredictor()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorName": {
                return Optional.ofNullable(clazz.cast(this.predictorName()));
            }
            case "ForecastHorizon": {
                return Optional.ofNullable(clazz.cast(this.forecastHorizon()));
            }
            case "ForecastTypes": {
                return Optional.ofNullable(clazz.cast(this.forecastTypes()));
            }
            case "ForecastDimensions": {
                return Optional.ofNullable(clazz.cast(this.forecastDimensions()));
            }
            case "ForecastFrequency": {
                return Optional.ofNullable(clazz.cast(this.forecastFrequency()));
            }
            case "DataConfig": {
                return Optional.ofNullable(clazz.cast(this.dataConfig()));
            }
            case "EncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "ReferencePredictorArn": {
                return Optional.ofNullable(clazz.cast(this.referencePredictorArn()));
            }
            case "OptimizationMetric": {
                return Optional.ofNullable(clazz.cast(this.optimizationMetricAsString()));
            }
            case "ExplainPredictor": {
                return Optional.ofNullable(clazz.cast(this.explainPredictor()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoPredictorRequest, T> g) {
        return obj -> g.apply((CreateAutoPredictorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String predictorName;
        private Integer forecastHorizon;
        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> forecastDimensions = DefaultSdkAutoConstructList.getInstance();
        private String forecastFrequency;
        private DataConfig dataConfig;
        private EncryptionConfig encryptionConfig;
        private String referencePredictorArn;
        private String optimizationMetric;
        private Boolean explainPredictor;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoPredictorRequest model) {
            super(model);
            this.predictorName(model.predictorName);
            this.forecastHorizon(model.forecastHorizon);
            this.forecastTypes(model.forecastTypes);
            this.forecastDimensions(model.forecastDimensions);
            this.forecastFrequency(model.forecastFrequency);
            this.dataConfig(model.dataConfig);
            this.encryptionConfig(model.encryptionConfig);
            this.referencePredictorArn(model.referencePredictorArn);
            this.optimizationMetric(model.optimizationMetric);
            this.explainPredictor(model.explainPredictor);
            this.tags(model.tags);
        }

        public final String getPredictorName() {
            return this.predictorName;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        @Override
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final Integer getForecastHorizon() {
            return this.forecastHorizon;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        @Override
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (this.forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastTypes(String ... forecastTypes) {
            this.forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final Collection<String> getForecastDimensions() {
            if (this.forecastDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastDimensions;
        }

        public final void setForecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
        }

        @Override
        public final Builder forecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastDimensions(String ... forecastDimensions) {
            this.forecastDimensions(Arrays.asList(forecastDimensions));
            return this;
        }

        public final String getForecastFrequency() {
            return this.forecastFrequency;
        }

        public final void setForecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
        }

        @Override
        public final Builder forecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
            return this;
        }

        public final DataConfig.Builder getDataConfig() {
            return this.dataConfig != null ? this.dataConfig.toBuilder() : null;
        }

        public final void setDataConfig(DataConfig.BuilderImpl dataConfig) {
            this.dataConfig = dataConfig != null ? dataConfig.build() : null;
        }

        @Override
        public final Builder dataConfig(DataConfig dataConfig) {
            this.dataConfig = dataConfig;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return this.encryptionConfig != null ? this.encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final String getReferencePredictorArn() {
            return this.referencePredictorArn;
        }

        public final void setReferencePredictorArn(String referencePredictorArn) {
            this.referencePredictorArn = referencePredictorArn;
        }

        @Override
        public final Builder referencePredictorArn(String referencePredictorArn) {
            this.referencePredictorArn = referencePredictorArn;
            return this;
        }

        public final String getOptimizationMetric() {
            return this.optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        public final Boolean getExplainPredictor() {
            return this.explainPredictor;
        }

        public final void setExplainPredictor(Boolean explainPredictor) {
            this.explainPredictor = explainPredictor;
        }

        @Override
        public final Builder explainPredictor(Boolean explainPredictor) {
            this.explainPredictor = explainPredictor;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoPredictorRequest build() {
            return new CreateAutoPredictorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutoPredictorRequest> {
        public Builder predictorName(String var1);

        public Builder forecastHorizon(Integer var1);

        public Builder forecastTypes(Collection<String> var1);

        public Builder forecastTypes(String ... var1);

        public Builder forecastDimensions(Collection<String> var1);

        public Builder forecastDimensions(String ... var1);

        public Builder forecastFrequency(String var1);

        public Builder dataConfig(DataConfig var1);

        default public Builder dataConfig(Consumer<DataConfig.Builder> dataConfig) {
            return this.dataConfig((DataConfig)((DataConfig.Builder)DataConfig.builder().applyMutation(dataConfig)).build());
        }

        public Builder encryptionConfig(EncryptionConfig var1);

        default public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return this.encryptionConfig((EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation(encryptionConfig)).build());
        }

        public Builder referencePredictorArn(String var1);

        public Builder optimizationMetric(String var1);

        public Builder optimizationMetric(OptimizationMetric var1);

        public Builder explainPredictor(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

