/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest;
import software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse;
import software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest;
import software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse;
import software.amazon.awssdk.services.forecast.model.CreateDatasetRequest;
import software.amazon.awssdk.services.forecast.model.CreateDatasetResponse;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse;
import software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest;
import software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse;
import software.amazon.awssdk.services.forecast.model.CreateForecastRequest;
import software.amazon.awssdk.services.forecast.model.CreateForecastResponse;
import software.amazon.awssdk.services.forecast.model.CreateMonitorRequest;
import software.amazon.awssdk.services.forecast.model.CreateMonitorResponse;
import software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest;
import software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse;
import software.amazon.awssdk.services.forecast.model.CreatePredictorRequest;
import software.amazon.awssdk.services.forecast.model.CreatePredictorResponse;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobResponse;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportResponse;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityResponse;
import software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DeleteForecastRequest;
import software.amazon.awssdk.services.forecast.model.DeleteForecastResponse;
import software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.forecast.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DeletePredictorRequest;
import software.amazon.awssdk.services.forecast.model.DeletePredictorResponse;
import software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest;
import software.amazon.awssdk.services.forecast.model.DeleteResourceTreeResponse;
import software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest;
import software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse;
import software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DescribeForecastRequest;
import software.amazon.awssdk.services.forecast.model.DescribeForecastResponse;
import software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest;
import software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse;
import software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DescribePredictorRequest;
import software.amazon.awssdk.services.forecast.model.DescribePredictorResponse;
import software.amazon.awssdk.services.forecast.model.ForecastException;
import software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest;
import software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse;
import software.amazon.awssdk.services.forecast.model.InvalidInputException;
import software.amazon.awssdk.services.forecast.model.InvalidNextTokenException;
import software.amazon.awssdk.services.forecast.model.LimitExceededException;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse;
import software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsResponse;
import software.amazon.awssdk.services.forecast.model.ListDatasetsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetsResponse;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse;
import software.amazon.awssdk.services.forecast.model.ListForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastsResponse;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse;
import software.amazon.awssdk.services.forecast.model.ListMonitorsRequest;
import software.amazon.awssdk.services.forecast.model.ListMonitorsResponse;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse;
import software.amazon.awssdk.services.forecast.model.ListPredictorsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorsResponse;
import software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.forecast.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.forecast.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.forecast.model.ResourceInUseException;
import software.amazon.awssdk.services.forecast.model.ResourceNotFoundException;
import software.amazon.awssdk.services.forecast.model.ResumeResourceRequest;
import software.amazon.awssdk.services.forecast.model.ResumeResourceResponse;
import software.amazon.awssdk.services.forecast.model.StopResourceRequest;
import software.amazon.awssdk.services.forecast.model.StopResourceResponse;
import software.amazon.awssdk.services.forecast.model.TagResourceRequest;
import software.amazon.awssdk.services.forecast.model.TagResourceResponse;
import software.amazon.awssdk.services.forecast.model.UntagResourceRequest;
import software.amazon.awssdk.services.forecast.model.UntagResourceResponse;
import software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable;
import software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable;

/**
 * Service client for accessing Amazon Forecast Service. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Provides APIs for creating and managing Amazon Forecast resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ForecastClient extends SdkClient {
    String SERVICE_NAME = "forecast";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "forecast";

    /**
     * Create a {@link ForecastClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ForecastClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ForecastClient}.
     */
    static ForecastClientBuilder builder() {
        return new DefaultForecastClientBuilder();
    }

    /**
     * <p>
     * Creates an Amazon Forecast predictor.
     * </p>
     * <p>
     * Amazon Forecast creates predictors with AutoPredictor, which involves applying the optimal combination of
     * algorithms to each time series in your datasets. You can use <a>CreateAutoPredictor</a> to create new predictors
     * or upgrade/retrain existing predictors.
     * </p>
     * <p>
     * <b>Creating new predictors</b>
     * </p>
     * <p>
     * The following parameters are required when creating a new predictor:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PredictorName</code> - A unique name for the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DatasetGroupArn</code> - The ARN of the dataset group used to train the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ForecastFrequency</code> - The granularity of your forecasts (hourly, daily, weekly, etc).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ForecastHorizon</code> - The number of time-steps that the model predicts. The forecast horizon is also
     * called the prediction length.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating a new predictor, do not specify a value for <code>ReferencePredictorArn</code>.
     * </p>
     * <p>
     * <b>Upgrading and retraining predictors</b>
     * </p>
     * <p>
     * The following parameters are required when retraining or upgrading a predictor:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PredictorName</code> - A unique name for the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReferencePredictorArn</code> - The ARN of the predictor to retrain or upgrade.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When upgrading or retraining a predictor, only specify values for the <code>ReferencePredictorArn</code> and
     * <code>PredictorName</code>.
     * </p>
     *
     * @param createAutoPredictorRequest
     * @return Result of the CreateAutoPredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateAutoPredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateAutoPredictor" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAutoPredictorResponse createAutoPredictor(CreateAutoPredictorRequest createAutoPredictorRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Forecast predictor.
     * </p>
     * <p>
     * Amazon Forecast creates predictors with AutoPredictor, which involves applying the optimal combination of
     * algorithms to each time series in your datasets. You can use <a>CreateAutoPredictor</a> to create new predictors
     * or upgrade/retrain existing predictors.
     * </p>
     * <p>
     * <b>Creating new predictors</b>
     * </p>
     * <p>
     * The following parameters are required when creating a new predictor:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PredictorName</code> - A unique name for the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DatasetGroupArn</code> - The ARN of the dataset group used to train the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ForecastFrequency</code> - The granularity of your forecasts (hourly, daily, weekly, etc).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ForecastHorizon</code> - The number of time-steps that the model predicts. The forecast horizon is also
     * called the prediction length.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating a new predictor, do not specify a value for <code>ReferencePredictorArn</code>.
     * </p>
     * <p>
     * <b>Upgrading and retraining predictors</b>
     * </p>
     * <p>
     * The following parameters are required when retraining or upgrading a predictor:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PredictorName</code> - A unique name for the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReferencePredictorArn</code> - The ARN of the predictor to retrain or upgrade.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When upgrading or retraining a predictor, only specify values for the <code>ReferencePredictorArn</code> and
     * <code>PredictorName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoPredictorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAutoPredictorRequest#builder()}
     * </p>
     *
     * @param createAutoPredictorRequest
     *        A {@link Consumer} that will call methods on {@link CreateAutoPredictorRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAutoPredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateAutoPredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateAutoPredictor" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAutoPredictorResponse createAutoPredictor(
            Consumer<CreateAutoPredictorRequest.Builder> createAutoPredictorRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        return createAutoPredictor(CreateAutoPredictorRequest.builder().applyMutation(createAutoPredictorRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand
     * how to consume the data for model training. This includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i> <code>DataFrequency</code> </i> - How frequently your historical time-series data is collected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i> <code>Domain</code> </i> and <i> <code>DatasetType</code> </i> - Each dataset has an associated dataset
     * domain and a type within the domain. Amazon Forecast provides a list of predefined domains and types within each
     * domain. For each unique dataset domain and type within the domain, Amazon Forecast requires your data to include
     * a minimum set of predefined fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i> <code>Schema</code> </i> - A schema specifies the fields in the dataset, including the field name and data
     * type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After creating a dataset, you import your training data into it and add the dataset to a dataset group. You use
     * the dataset group to create a predictor. For more information, see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html">Importing datasets</a>.
     * </p>
     * <p>
     * To get a list of all your datasets, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasets.html">ListDatasets</a> operation.
     * </p>
     * <p>
     * For example Forecast datasets, see the <a href="https://github.com/aws-samples/amazon-forecast-samples">Amazon
     * Forecast Sample GitHub repository</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of a dataset must be <code>ACTIVE</code> before you can import training data. Use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a> operation to
     * get the status.
     * </p>
     * </note>
     *
     * @param createDatasetRequest
     * @return Result of the CreateDataset operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand
     * how to consume the data for model training. This includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i> <code>DataFrequency</code> </i> - How frequently your historical time-series data is collected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i> <code>Domain</code> </i> and <i> <code>DatasetType</code> </i> - Each dataset has an associated dataset
     * domain and a type within the domain. Amazon Forecast provides a list of predefined domains and types within each
     * domain. For each unique dataset domain and type within the domain, Amazon Forecast requires your data to include
     * a minimum set of predefined fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i> <code>Schema</code> </i> - A schema specifies the fields in the dataset, including the field name and data
     * type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After creating a dataset, you import your training data into it and add the dataset to a dataset group. You use
     * the dataset group to create a predictor. For more information, see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html">Importing datasets</a>.
     * </p>
     * <p>
     * To get a list of all your datasets, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasets.html">ListDatasets</a> operation.
     * </p>
     * <p>
     * For example Forecast datasets, see the <a href="https://github.com/aws-samples/amazon-forecast-samples">Amazon
     * Forecast Sample GitHub repository</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of a dataset must be <code>ACTIVE</code> before you can import training data. Use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a> operation to
     * get the status.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDatasetRequest#builder()}
     * </p>
     *
     * @param createDatasetRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetRequest.Builder} to create a request.
     * @return Result of the CreateDataset operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDatasetResponse createDataset(Consumer<CreateDatasetRequest.Builder> createDatasetRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, AwsServiceException,
            SdkClientException, ForecastException {
        return createDataset(CreateDatasetRequest.builder().applyMutation(createDatasetRequest).build());
    }

    /**
     * <p>
     * Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group
     * when you create the dataset group, or later by using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html">UpdateDatasetGroup</a>
     * operation.
     * </p>
     * <p>
     * After creating a dataset group and adding datasets, you use the dataset group when you create a predictor. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html">Dataset groups</a>.
     * </p>
     * <p>
     * To get a list of all your datasets groups, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetGroups.html">ListDatasetGroups</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of a dataset group must be <code>ACTIVE</code> before you can use the dataset group to
     * create a predictor. To get the status, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * </note>
     *
     * @param createDatasetGroupRequest
     * @return Result of the CreateDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDatasetGroupResponse createDatasetGroup(CreateDatasetGroupRequest createDatasetGroupRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group
     * when you create the dataset group, or later by using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html">UpdateDatasetGroup</a>
     * operation.
     * </p>
     * <p>
     * After creating a dataset group and adding datasets, you use the dataset group when you create a predictor. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html">Dataset groups</a>.
     * </p>
     * <p>
     * To get a list of all your datasets groups, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetGroups.html">ListDatasetGroups</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of a dataset group must be <code>ACTIVE</code> before you can use the dataset group to
     * create a predictor. To get the status, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDatasetGroupRequest#builder()}
     * </p>
     *
     * @param createDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDatasetGroupResponse createDatasetGroup(Consumer<CreateDatasetGroupRequest.Builder> createDatasetGroupRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        return createDatasetGroup(CreateDatasetGroupRequest.builder().applyMutation(createDatasetGroupRequest).build());
    }

    /**
     * <p>
     * Imports your training data to an Amazon Forecast dataset. You provide the location of your training data in an
     * Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want
     * to import the data to.
     * </p>
     * <p>
     * You must specify a <a href="https://docs.aws.amazon.com/forecast/latest/dg/API_DataSource.html">DataSource</a>
     * object that includes an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
     * the data, as Amazon Forecast makes a copy of your data and processes it in an internal AWS system. For more
     * information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/aws-forecast-iam-roles.html">Set up
     * permissions</a>.
     * </p>
     * <p>
     * The training data must be in CSV format. The delimiter must be a comma (,).
     * </p>
     * <p>
     * You can specify the path to a specific CSV file, the S3 bucket, or to a folder in the S3 bucket. For the latter
     * two cases, Amazon Forecast imports all files up to the limit of 10,000 files.
     * </p>
     * <p>
     * Because dataset imports are not aggregated, your most recent dataset import is the one that is used when training
     * a predictor or generating a forecast. Make sure that your most recent dataset import contains all of the data you
     * want to model off of, and not just the new data collected since the previous import.
     * </p>
     * <p>
     * To get a list of all your dataset import jobs, filtered by specified criteria, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a>
     * operation.
     * </p>
     *
     * @param createDatasetImportJobRequest
     * @return Result of the CreateDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetImportJobResponse createDatasetImportJob(CreateDatasetImportJobRequest createDatasetImportJobRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports your training data to an Amazon Forecast dataset. You provide the location of your training data in an
     * Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want
     * to import the data to.
     * </p>
     * <p>
     * You must specify a <a href="https://docs.aws.amazon.com/forecast/latest/dg/API_DataSource.html">DataSource</a>
     * object that includes an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access
     * the data, as Amazon Forecast makes a copy of your data and processes it in an internal AWS system. For more
     * information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/aws-forecast-iam-roles.html">Set up
     * permissions</a>.
     * </p>
     * <p>
     * The training data must be in CSV format. The delimiter must be a comma (,).
     * </p>
     * <p>
     * You can specify the path to a specific CSV file, the S3 bucket, or to a folder in the S3 bucket. For the latter
     * two cases, Amazon Forecast imports all files up to the limit of 10,000 files.
     * </p>
     * <p>
     * Because dataset imports are not aggregated, your most recent dataset import is the one that is used when training
     * a predictor or generating a forecast. Make sure that your most recent dataset import contains all of the data you
     * want to model off of, and not just the new data collected since the previous import.
     * </p>
     * <p>
     * To get a list of all your dataset import jobs, filtered by specified criteria, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDatasetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDatasetImportJobRequest#builder()}
     * </p>
     *
     * @param createDatasetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateDatasetImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDatasetImportJobResponse createDatasetImportJob(
            Consumer<CreateDatasetImportJobRequest.Builder> createDatasetImportJobRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        return createDatasetImportJob(CreateDatasetImportJobRequest.builder().applyMutation(createDatasetImportJobRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * Explainability is only available for Forecasts and Predictors generated from an AutoPredictor
     * (<a>CreateAutoPredictor</a>)
     * </p>
     * </note>
     * <p>
     * Creates an Amazon Forecast Explainability.
     * </p>
     * <p>
     * Explainability helps you better understand how the attributes in your datasets impact forecast. Amazon Forecast
     * uses a metric called Impact scores to quantify the relative impact of each attribute and determine whether they
     * increase or decrease forecast values.
     * </p>
     * <p>
     * To enable Forecast Explainability, your predictor must include at least one of the following: related time
     * series, item metadata, or additional datasets like Holidays and the Weather Index.
     * </p>
     * <p>
     * CreateExplainability accepts either a Predictor ARN or Forecast ARN. To receive aggregated Impact scores for all
     * time series and time points in your datasets, provide a Predictor ARN. To receive Impact scores for specific time
     * series and time points, provide a Forecast ARN.
     * </p>
     * <p>
     * <b>CreateExplainability with a Predictor ARN</b>
     * </p>
     * <note>
     * <p>
     * You can only have one Explainability resource per predictor. If you already enabled <code>ExplainPredictor</code>
     * in <a>CreateAutoPredictor</a>, that predictor already has an Explainability resource.
     * </p>
     * </note>
     * <p>
     * The following parameters are required when providing a Predictor ARN:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ExplainabilityName</code> - A unique name for the Explainability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - The Arn of the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimePointGranularity</code> - Must be set to “ALL”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimeSeriesGranularity</code> - Must be set to “ALL”.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Do not specify a value for the following parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DataSource</code> - Only valid when TimeSeriesGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Schema</code> - Only valid when TimeSeriesGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StartDateTime</code> - Only valid when TimePointGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EndDateTime</code> - Only valid when TimePointGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>CreateExplainability with a Forecast ARN</b>
     * </p>
     * <note>
     * <p>
     * You can specify a maximum of 50 time series and 500 time points.
     * </p>
     * </note>
     * <p>
     * The following parameters are required when providing a Predictor ARN:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ExplainabilityName</code> - A unique name for the Explainability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - The Arn of the forecast.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimePointGranularity</code> - Either “ALL” or “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimeSeriesGranularity</code> - Either “ALL” or “SPECIFIC”.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set TimeSeriesGranularity to “SPECIFIC”, you must also provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DataSource</code> - The S3 location of the CSV file specifying your time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Schema</code> - The Schema defines the attributes and attribute types listed in the Data Source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set TimePointGranularity to “SPECIFIC”, you must also provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>StartDateTime</code> - The first timestamp in the range of time points.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EndDateTime</code> - The last timestamp in the range of time points.
     * </p>
     * </li>
     * </ul>
     *
     * @param createExplainabilityRequest
     * @return Result of the CreateExplainability operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateExplainability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateExplainability" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExplainabilityResponse createExplainability(CreateExplainabilityRequest createExplainabilityRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Explainability is only available for Forecasts and Predictors generated from an AutoPredictor
     * (<a>CreateAutoPredictor</a>)
     * </p>
     * </note>
     * <p>
     * Creates an Amazon Forecast Explainability.
     * </p>
     * <p>
     * Explainability helps you better understand how the attributes in your datasets impact forecast. Amazon Forecast
     * uses a metric called Impact scores to quantify the relative impact of each attribute and determine whether they
     * increase or decrease forecast values.
     * </p>
     * <p>
     * To enable Forecast Explainability, your predictor must include at least one of the following: related time
     * series, item metadata, or additional datasets like Holidays and the Weather Index.
     * </p>
     * <p>
     * CreateExplainability accepts either a Predictor ARN or Forecast ARN. To receive aggregated Impact scores for all
     * time series and time points in your datasets, provide a Predictor ARN. To receive Impact scores for specific time
     * series and time points, provide a Forecast ARN.
     * </p>
     * <p>
     * <b>CreateExplainability with a Predictor ARN</b>
     * </p>
     * <note>
     * <p>
     * You can only have one Explainability resource per predictor. If you already enabled <code>ExplainPredictor</code>
     * in <a>CreateAutoPredictor</a>, that predictor already has an Explainability resource.
     * </p>
     * </note>
     * <p>
     * The following parameters are required when providing a Predictor ARN:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ExplainabilityName</code> - A unique name for the Explainability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - The Arn of the predictor.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimePointGranularity</code> - Must be set to “ALL”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimeSeriesGranularity</code> - Must be set to “ALL”.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Do not specify a value for the following parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DataSource</code> - Only valid when TimeSeriesGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Schema</code> - Only valid when TimeSeriesGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StartDateTime</code> - Only valid when TimePointGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EndDateTime</code> - Only valid when TimePointGranularity is “SPECIFIC”.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>CreateExplainability with a Forecast ARN</b>
     * </p>
     * <note>
     * <p>
     * You can specify a maximum of 50 time series and 500 time points.
     * </p>
     * </note>
     * <p>
     * The following parameters are required when providing a Predictor ARN:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ExplainabilityName</code> - A unique name for the Explainability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceArn</code> - The Arn of the forecast.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimePointGranularity</code> - Either “ALL” or “SPECIFIC”.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimeSeriesGranularity</code> - Either “ALL” or “SPECIFIC”.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set TimeSeriesGranularity to “SPECIFIC”, you must also provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DataSource</code> - The S3 location of the CSV file specifying your time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Schema</code> - The Schema defines the attributes and attribute types listed in the Data Source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set TimePointGranularity to “SPECIFIC”, you must also provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>StartDateTime</code> - The first timestamp in the range of time points.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EndDateTime</code> - The last timestamp in the range of time points.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExplainabilityRequest.Builder} avoiding the
     * need to create one manually via {@link CreateExplainabilityRequest#builder()}
     * </p>
     *
     * @param createExplainabilityRequest
     *        A {@link Consumer} that will call methods on {@link CreateExplainabilityRequest.Builder} to create a
     *        request.
     * @return Result of the CreateExplainability operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateExplainability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateExplainability" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateExplainabilityResponse createExplainability(
            Consumer<CreateExplainabilityRequest.Builder> createExplainabilityRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        return createExplainability(CreateExplainabilityRequest.builder().applyMutation(createExplainabilityRequest).build());
    }

    /**
     * <p>
     * Exports an Explainability resource created by the <a>CreateExplainability</a> operation. Exported files are
     * exported to an Amazon Simple Storage Service (Amazon S3) bucket.
     * </p>
     * <p>
     * You must specify a <a>DataDestination</a> object that includes an Amazon S3 bucket and an AWS Identity and Access
     * Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
     * <a>aws-forecast-iam-roles</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the export job must be <code>ACTIVE</code> before you can access the export in your
     * Amazon S3 bucket. To get the status, use the <a>DescribeExplainabilityExport</a> operation.
     * </p>
     * </note>
     *
     * @param createExplainabilityExportRequest
     * @return Result of the CreateExplainabilityExport operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateExplainabilityExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateExplainabilityExport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateExplainabilityExportResponse createExplainabilityExport(
            CreateExplainabilityExportRequest createExplainabilityExportRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports an Explainability resource created by the <a>CreateExplainability</a> operation. Exported files are
     * exported to an Amazon Simple Storage Service (Amazon S3) bucket.
     * </p>
     * <p>
     * You must specify a <a>DataDestination</a> object that includes an Amazon S3 bucket and an AWS Identity and Access
     * Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
     * <a>aws-forecast-iam-roles</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the export job must be <code>ACTIVE</code> before you can access the export in your
     * Amazon S3 bucket. To get the status, use the <a>DescribeExplainabilityExport</a> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExplainabilityExportRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExplainabilityExportRequest#builder()}
     * </p>
     *
     * @param createExplainabilityExportRequest
     *        A {@link Consumer} that will call methods on {@link CreateExplainabilityExportRequest.Builder} to create a
     *        request.
     * @return Result of the CreateExplainabilityExport operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateExplainabilityExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateExplainabilityExport"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateExplainabilityExportResponse createExplainabilityExport(
            Consumer<CreateExplainabilityExportRequest.Builder> createExplainabilityExportRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        return createExplainabilityExport(CreateExplainabilityExportRequest.builder()
                .applyMutation(createExplainabilityExportRequest).build());
    }

    /**
     * <p>
     * Creates a forecast for each item in the <code>TARGET_TIME_SERIES</code> dataset that was used to train the
     * predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the
     * operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the
     * <a>CreateForecastExportJob</a> operation.
     * </p>
     * <p>
     * The range of the forecast is determined by the <code>ForecastHorizon</code> value, which you specify in the
     * <a>CreatePredictor</a> request. When you query a forecast, you can request a specific date range within the
     * forecast.
     * </p>
     * <p>
     * To get a list of all your forecasts, use the <a>ListForecasts</a> operation.
     * </p>
     * <note>
     * <p>
     * The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was used to create the
     * predictor.
     * </p>
     * </note>
     * <p>
     * For more information, see <a>howitworks-forecast</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.
     * Use the <a>DescribeForecast</a> operation to get the status.
     * </p>
     * </note>
     *
     * @param createForecastRequest
     * @return Result of the CreateForecast operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateForecastResponse createForecast(CreateForecastRequest createForecastRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a forecast for each item in the <code>TARGET_TIME_SERIES</code> dataset that was used to train the
     * predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the
     * operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the
     * <a>CreateForecastExportJob</a> operation.
     * </p>
     * <p>
     * The range of the forecast is determined by the <code>ForecastHorizon</code> value, which you specify in the
     * <a>CreatePredictor</a> request. When you query a forecast, you can request a specific date range within the
     * forecast.
     * </p>
     * <p>
     * To get a list of all your forecasts, use the <a>ListForecasts</a> operation.
     * </p>
     * <note>
     * <p>
     * The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was used to create the
     * predictor.
     * </p>
     * </note>
     * <p>
     * For more information, see <a>howitworks-forecast</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.
     * Use the <a>DescribeForecast</a> operation to get the status.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateForecastRequest.Builder} avoiding the need to
     * create one manually via {@link CreateForecastRequest#builder()}
     * </p>
     *
     * @param createForecastRequest
     *        A {@link Consumer} that will call methods on {@link CreateForecastRequest.Builder} to create a request.
     * @return Result of the CreateForecast operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateForecastResponse createForecast(Consumer<CreateForecastRequest.Builder> createForecastRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        return createForecast(CreateForecastRequest.builder().applyMutation(createForecastRequest).build());
    }

    /**
     * <p>
     * Exports a forecast created by the <a>CreateForecast</a> operation to your Amazon Simple Storage Service (Amazon
     * S3) bucket. The forecast file name will match the following conventions:
     * </p>
     * <p>
     * &lt;ForecastExportJobName&gt;_&lt;ExportTimestamp&gt;_&lt;PartNumber&gt;
     * </p>
     * <p>
     * where the &lt;ExportTimestamp&gt; component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
     * </p>
     * <p>
     * You must specify a <a>DataDestination</a> object that includes an AWS Identity and Access Management (IAM) role
     * that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
     * <a>aws-forecast-iam-roles</a>.
     * </p>
     * <p>
     * For more information, see <a>howitworks-forecast</a>.
     * </p>
     * <p>
     * To get a list of all your forecast export jobs, use the <a>ListForecastExportJobs</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast
     * in your Amazon S3 bucket. To get the status, use the <a>DescribeForecastExportJob</a> operation.
     * </p>
     * </note>
     *
     * @param createForecastExportJobRequest
     * @return Result of the CreateForecastExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateForecastExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecastExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateForecastExportJobResponse createForecastExportJob(CreateForecastExportJobRequest createForecastExportJobRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a forecast created by the <a>CreateForecast</a> operation to your Amazon Simple Storage Service (Amazon
     * S3) bucket. The forecast file name will match the following conventions:
     * </p>
     * <p>
     * &lt;ForecastExportJobName&gt;_&lt;ExportTimestamp&gt;_&lt;PartNumber&gt;
     * </p>
     * <p>
     * where the &lt;ExportTimestamp&gt; component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
     * </p>
     * <p>
     * You must specify a <a>DataDestination</a> object that includes an AWS Identity and Access Management (IAM) role
     * that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
     * <a>aws-forecast-iam-roles</a>.
     * </p>
     * <p>
     * For more information, see <a>howitworks-forecast</a>.
     * </p>
     * <p>
     * To get a list of all your forecast export jobs, use the <a>ListForecastExportJobs</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast
     * in your Amazon S3 bucket. To get the status, use the <a>DescribeForecastExportJob</a> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateForecastExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateForecastExportJobRequest#builder()}
     * </p>
     *
     * @param createForecastExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateForecastExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateForecastExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateForecastExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecastExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateForecastExportJobResponse createForecastExportJob(
            Consumer<CreateForecastExportJobRequest.Builder> createForecastExportJobRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        return createForecastExportJob(CreateForecastExportJobRequest.builder().applyMutation(createForecastExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a predictor monitor resource for an existing auto predictor. Predictor monitoring allows you to see how
     * your predictor's performance changes over time. For more information, see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html">Predictor Monitoring</a>.
     * </p>
     *
     * @param createMonitorRequest
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a predictor monitor resource for an existing auto predictor. Predictor monitoring allows you to see how
     * your predictor's performance changes over time. For more information, see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html">Predictor Monitoring</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMonitorRequest#builder()}
     * </p>
     *
     * @param createMonitorRequest
     *        A {@link Consumer} that will call methods on {@link CreateMonitorRequest.Builder} to create a request.
     * @return Result of the CreateMonitor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreateMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMonitorResponse createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        return createMonitor(CreateMonitorRequest.builder().applyMutation(createMonitorRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation creates a legacy predictor that does not include all the predictor functionalities provided by
     * Amazon Forecast. To create a predictor that is compatible with all aspects of Forecast, use
     * <a>CreateAutoPredictor</a>.
     * </p>
     * </note>
     * <p>
     * Creates an Amazon Forecast predictor.
     * </p>
     * <p>
     * In the request, provide a dataset group and either specify an algorithm or let Amazon Forecast choose an
     * algorithm for you using AutoML. If you specify an algorithm, you also can override algorithm-specific
     * hyperparameters.
     * </p>
     * <p>
     * Amazon Forecast uses the algorithm to train a predictor using the latest version of the datasets in the specified
     * dataset group. You can then generate a forecast using the <a>CreateForecast</a> operation.
     * </p>
     * <p>
     * To see the evaluation metrics, use the <a>GetAccuracyMetrics</a> operation.
     * </p>
     * <p>
     * You can specify a featurization configuration to fill and aggregate the data fields in the
     * <code>TARGET_TIME_SERIES</code> dataset to improve model training. For more information, see
     * <a>FeaturizationConfig</a>.
     * </p>
     * <p>
     * For RELATED_TIME_SERIES datasets, <code>CreatePredictor</code> verifies that the <code>DataFrequency</code>
     * specified when the dataset was created matches the <code>ForecastFrequency</code>. TARGET_TIME_SERIES datasets
     * don't have this restriction. Amazon Forecast also verifies the delimiter and timestamp format. For more
     * information, see <a>howitworks-datasets-groups</a>.
     * </p>
     * <p>
     * By default, predictors are trained and evaluated at the 0.1 (P10), 0.5 (P50), and 0.9 (P90) quantiles. You can
     * choose custom forecast types to train and evaluate your predictor by setting the <code>ForecastTypes</code>.
     * </p>
     * <p>
     * <b>AutoML</b>
     * </p>
     * <p>
     * If you want Amazon Forecast to evaluate each algorithm and choose the one that minimizes the
     * <code>objective function</code>, set <code>PerformAutoML</code> to <code>true</code>. The
     * <code>objective function</code> is defined as the mean of the weighted losses over the forecast types. By
     * default, these are the p10, p50, and p90 quantile losses. For more information, see <a>EvaluationResult</a>.
     * </p>
     * <p>
     * When AutoML is enabled, the following properties are disallowed:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HPOConfig</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PerformHPO</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TrainingParameters</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a list of all of your predictors, use the <a>ListPredictors</a> operation.
     * </p>
     * <note>
     * <p>
     * Before you can use the predictor to create a forecast, the <code>Status</code> of the predictor must be
     * <code>ACTIVE</code>, signifying that training has completed. To get the status, use the <a>DescribePredictor</a>
     * operation.
     * </p>
     * </note>
     *
     * @param createPredictorRequest
     * @return Result of the CreatePredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreatePredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreatePredictor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePredictorResponse createPredictor(CreatePredictorRequest createPredictorRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation creates a legacy predictor that does not include all the predictor functionalities provided by
     * Amazon Forecast. To create a predictor that is compatible with all aspects of Forecast, use
     * <a>CreateAutoPredictor</a>.
     * </p>
     * </note>
     * <p>
     * Creates an Amazon Forecast predictor.
     * </p>
     * <p>
     * In the request, provide a dataset group and either specify an algorithm or let Amazon Forecast choose an
     * algorithm for you using AutoML. If you specify an algorithm, you also can override algorithm-specific
     * hyperparameters.
     * </p>
     * <p>
     * Amazon Forecast uses the algorithm to train a predictor using the latest version of the datasets in the specified
     * dataset group. You can then generate a forecast using the <a>CreateForecast</a> operation.
     * </p>
     * <p>
     * To see the evaluation metrics, use the <a>GetAccuracyMetrics</a> operation.
     * </p>
     * <p>
     * You can specify a featurization configuration to fill and aggregate the data fields in the
     * <code>TARGET_TIME_SERIES</code> dataset to improve model training. For more information, see
     * <a>FeaturizationConfig</a>.
     * </p>
     * <p>
     * For RELATED_TIME_SERIES datasets, <code>CreatePredictor</code> verifies that the <code>DataFrequency</code>
     * specified when the dataset was created matches the <code>ForecastFrequency</code>. TARGET_TIME_SERIES datasets
     * don't have this restriction. Amazon Forecast also verifies the delimiter and timestamp format. For more
     * information, see <a>howitworks-datasets-groups</a>.
     * </p>
     * <p>
     * By default, predictors are trained and evaluated at the 0.1 (P10), 0.5 (P50), and 0.9 (P90) quantiles. You can
     * choose custom forecast types to train and evaluate your predictor by setting the <code>ForecastTypes</code>.
     * </p>
     * <p>
     * <b>AutoML</b>
     * </p>
     * <p>
     * If you want Amazon Forecast to evaluate each algorithm and choose the one that minimizes the
     * <code>objective function</code>, set <code>PerformAutoML</code> to <code>true</code>. The
     * <code>objective function</code> is defined as the mean of the weighted losses over the forecast types. By
     * default, these are the p10, p50, and p90 quantile losses. For more information, see <a>EvaluationResult</a>.
     * </p>
     * <p>
     * When AutoML is enabled, the following properties are disallowed:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HPOConfig</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PerformHPO</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TrainingParameters</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a list of all of your predictors, use the <a>ListPredictors</a> operation.
     * </p>
     * <note>
     * <p>
     * Before you can use the predictor to create a forecast, the <code>Status</code> of the predictor must be
     * <code>ACTIVE</code>, signifying that training has completed. To get the status, use the <a>DescribePredictor</a>
     * operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePredictorRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePredictorRequest#builder()}
     * </p>
     *
     * @param createPredictorRequest
     *        A {@link Consumer} that will call methods on {@link CreatePredictorRequest.Builder} to create a request.
     * @return Result of the CreatePredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreatePredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreatePredictor" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePredictorResponse createPredictor(Consumer<CreatePredictorRequest.Builder> createPredictorRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        return createPredictor(CreatePredictorRequest.builder().applyMutation(createPredictorRequest).build());
    }

    /**
     * <p>
     * Exports backtest forecasts and accuracy metrics generated by the <a>CreateAutoPredictor</a> or
     * <a>CreatePredictor</a> operations. Two folders containing CSV files are exported to your specified S3 bucket.
     * </p>
     * <p>
     * The export file names will match the following conventions:
     * </p>
     * <p>
     * <code>&lt;ExportJobName&gt;_&lt;ExportTimestamp&gt;_&lt;PartNumber&gt;.csv</code>
     * </p>
     * <p>
     * The &lt;ExportTimestamp&gt; component is in Java SimpleDate format (yyyy-MM-ddTHH-mm-ssZ).
     * </p>
     * <p>
     * You must specify a <a>DataDestination</a> object that includes an Amazon S3 bucket and an AWS Identity and Access
     * Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
     * <a>aws-forecast-iam-roles</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the export job must be <code>ACTIVE</code> before you can access the export in your
     * Amazon S3 bucket. To get the status, use the <a>DescribePredictorBacktestExportJob</a> operation.
     * </p>
     * </note>
     *
     * @param createPredictorBacktestExportJobRequest
     * @return Result of the CreatePredictorBacktestExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreatePredictorBacktestExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreatePredictorBacktestExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePredictorBacktestExportJobResponse createPredictorBacktestExportJob(
            CreatePredictorBacktestExportJobRequest createPredictorBacktestExportJobRequest) throws InvalidInputException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports backtest forecasts and accuracy metrics generated by the <a>CreateAutoPredictor</a> or
     * <a>CreatePredictor</a> operations. Two folders containing CSV files are exported to your specified S3 bucket.
     * </p>
     * <p>
     * The export file names will match the following conventions:
     * </p>
     * <p>
     * <code>&lt;ExportJobName&gt;_&lt;ExportTimestamp&gt;_&lt;PartNumber&gt;.csv</code>
     * </p>
     * <p>
     * The &lt;ExportTimestamp&gt; component is in Java SimpleDate format (yyyy-MM-ddTHH-mm-ssZ).
     * </p>
     * <p>
     * You must specify a <a>DataDestination</a> object that includes an Amazon S3 bucket and an AWS Identity and Access
     * Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see
     * <a>aws-forecast-iam-roles</a>.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the export job must be <code>ACTIVE</code> before you can access the export in your
     * Amazon S3 bucket. To get the status, use the <a>DescribePredictorBacktestExportJob</a> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePredictorBacktestExportJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePredictorBacktestExportJobRequest#builder()}
     * </p>
     *
     * @param createPredictorBacktestExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreatePredictorBacktestExportJobRequest.Builder} to
     *        create a request.
     * @return Result of the CreatePredictorBacktestExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceAlreadyExistsException
     *         There is already a resource with this name. Try again with a different name.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.CreatePredictorBacktestExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreatePredictorBacktestExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePredictorBacktestExportJobResponse createPredictorBacktestExportJob(
            Consumer<CreatePredictorBacktestExportJobRequest.Builder> createPredictorBacktestExportJobRequest)
            throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        return createPredictorBacktestExportJob(CreatePredictorBacktestExportJobRequest.builder()
                .applyMutation(createPredictorBacktestExportJobRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Forecast dataset that was created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation. You can
     * only delete datasets that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status
     * use the <a href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * Forecast does not automatically update any dataset groups that contain the deleted dataset. In order to update
     * the dataset group, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html">UpdateDatasetGroup</a>
     * operation, omitting the deleted dataset's ARN.
     * </p>
     * </note>
     *
     * @param deleteDatasetRequest
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Forecast dataset that was created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation. You can
     * only delete datasets that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status
     * use the <a href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * Forecast does not automatically update any dataset groups that contain the deleted dataset. In order to update
     * the dataset group, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_UpdateDatasetGroup.html">UpdateDatasetGroup</a>
     * operation, omitting the deleted dataset's ARN.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDatasetRequest#builder()}
     * </p>
     *
     * @param deleteDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetRequest.Builder} to create a request.
     * @return Result of the DeleteDataset operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDatasetResponse deleteDataset(Consumer<DeleteDatasetRequest.Builder> deleteDatasetRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deleteDataset(DeleteDatasetRequest.builder().applyMutation(deleteDatasetRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset group created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation. You can only delete dataset groups that have a status of <code>ACTIVE</code>,
     * <code>CREATE_FAILED</code>, or <code>UPDATE_FAILED</code>. To get the status, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * <p>
     * This operation deletes only the dataset group, not the datasets in the group.
     * </p>
     *
     * @param deleteDatasetGroupRequest
     * @return Result of the DeleteDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDatasetGroupResponse deleteDatasetGroup(DeleteDatasetGroupRequest deleteDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset group created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation. You can only delete dataset groups that have a status of <code>ACTIVE</code>,
     * <code>CREATE_FAILED</code>, or <code>UPDATE_FAILED</code>. To get the status, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * <p>
     * This operation deletes only the dataset group, not the datasets in the group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDatasetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDatasetGroupResponse deleteDatasetGroup(Consumer<DeleteDatasetGroupRequest.Builder> deleteDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deleteDatasetGroup(DeleteDatasetGroupRequest.builder().applyMutation(deleteDatasetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a dataset import job created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation. You can delete only dataset import jobs that have a status of <code>ACTIVE</code> or
     * <code>CREATE_FAILED</code>. To get the status, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a> operation.
     * </p>
     *
     * @param deleteDatasetImportJobRequest
     * @return Result of the DeleteDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatasetImportJobResponse deleteDatasetImportJob(DeleteDatasetImportJobRequest deleteDatasetImportJobRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dataset import job created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation. You can delete only dataset import jobs that have a status of <code>ACTIVE</code> or
     * <code>CREATE_FAILED</code>. To get the status, use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDatasetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDatasetImportJobRequest#builder()}
     * </p>
     *
     * @param deleteDatasetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDatasetImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDatasetImportJobResponse deleteDatasetImportJob(
            Consumer<DeleteDatasetImportJobRequest.Builder> deleteDatasetImportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        return deleteDatasetImportJob(DeleteDatasetImportJobRequest.builder().applyMutation(deleteDatasetImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Explainability resource.
     * </p>
     * <p>
     * You can delete only predictor that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the
     * status, use the <a>DescribeExplainability</a> operation.
     * </p>
     *
     * @param deleteExplainabilityRequest
     * @return Result of the DeleteExplainability operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteExplainability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteExplainability" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExplainabilityResponse deleteExplainability(DeleteExplainabilityRequest deleteExplainabilityRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Explainability resource.
     * </p>
     * <p>
     * You can delete only predictor that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the
     * status, use the <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExplainabilityRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteExplainabilityRequest#builder()}
     * </p>
     *
     * @param deleteExplainabilityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExplainabilityRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteExplainability operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteExplainability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteExplainability" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteExplainabilityResponse deleteExplainability(
            Consumer<DeleteExplainabilityRequest.Builder> deleteExplainabilityRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        return deleteExplainability(DeleteExplainabilityRequest.builder().applyMutation(deleteExplainabilityRequest).build());
    }

    /**
     * <p>
     * Deletes an Explainability export.
     * </p>
     *
     * @param deleteExplainabilityExportRequest
     * @return Result of the DeleteExplainabilityExport operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteExplainabilityExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteExplainabilityExport"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteExplainabilityExportResponse deleteExplainabilityExport(
            DeleteExplainabilityExportRequest deleteExplainabilityExportRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Explainability export.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExplainabilityExportRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteExplainabilityExportRequest#builder()}
     * </p>
     *
     * @param deleteExplainabilityExportRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExplainabilityExportRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteExplainabilityExport operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteExplainabilityExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteExplainabilityExport"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteExplainabilityExportResponse deleteExplainabilityExport(
            Consumer<DeleteExplainabilityExportRequest.Builder> deleteExplainabilityExportRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        return deleteExplainabilityExport(DeleteExplainabilityExportRequest.builder()
                .applyMutation(deleteExplainabilityExportRequest).build());
    }

    /**
     * <p>
     * Deletes a forecast created using the <a>CreateForecast</a> operation. You can delete only forecasts that have a
     * status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeForecast</a>
     * operation.
     * </p>
     * <p>
     * You can't delete a forecast while it is being exported. After a forecast is deleted, you can no longer query the
     * forecast.
     * </p>
     *
     * @param deleteForecastRequest
     * @return Result of the DeleteForecast operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteForecastResponse deleteForecast(DeleteForecastRequest deleteForecastRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a forecast created using the <a>CreateForecast</a> operation. You can delete only forecasts that have a
     * status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeForecast</a>
     * operation.
     * </p>
     * <p>
     * You can't delete a forecast while it is being exported. After a forecast is deleted, you can no longer query the
     * forecast.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteForecastRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteForecastRequest#builder()}
     * </p>
     *
     * @param deleteForecastRequest
     *        A {@link Consumer} that will call methods on {@link DeleteForecastRequest.Builder} to create a request.
     * @return Result of the DeleteForecast operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteForecastResponse deleteForecast(Consumer<DeleteForecastRequest.Builder> deleteForecastRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deleteForecast(DeleteForecastRequest.builder().applyMutation(deleteForecastRequest).build());
    }

    /**
     * <p>
     * Deletes a forecast export job created using the <a>CreateForecastExportJob</a> operation. You can delete only
     * export jobs that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the
     * <a>DescribeForecastExportJob</a> operation.
     * </p>
     *
     * @param deleteForecastExportJobRequest
     * @return Result of the DeleteForecastExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteForecastExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecastExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteForecastExportJobResponse deleteForecastExportJob(DeleteForecastExportJobRequest deleteForecastExportJobRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a forecast export job created using the <a>CreateForecastExportJob</a> operation. You can delete only
     * export jobs that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the
     * <a>DescribeForecastExportJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteForecastExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteForecastExportJobRequest#builder()}
     * </p>
     *
     * @param deleteForecastExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteForecastExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteForecastExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteForecastExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteForecastExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteForecastExportJobResponse deleteForecastExportJob(
            Consumer<DeleteForecastExportJobRequest.Builder> deleteForecastExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        return deleteForecastExportJob(DeleteForecastExportJobRequest.builder().applyMutation(deleteForecastExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a monitor resource. You can only delete a monitor resource with a status of <code>ACTIVE</code>,
     * <code>ACTIVE_STOPPED</code>, <code>CREATE_FAILED</code>, or <code>CREATE_STOPPED</code>.
     * </p>
     *
     * @param deleteMonitorRequest
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a monitor resource. You can only delete a monitor resource with a status of <code>ACTIVE</code>,
     * <code>ACTIVE_STOPPED</code>, <code>CREATE_FAILED</code>, or <code>CREATE_STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMonitorRequest#builder()}
     * </p>
     *
     * @param deleteMonitorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMonitorRequest.Builder} to create a request.
     * @return Result of the DeleteMonitor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMonitorResponse deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deleteMonitor(DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest).build());
    }

    /**
     * <p>
     * Deletes a predictor created using the <a>DescribePredictor</a> or <a>CreatePredictor</a> operations. You can
     * delete only predictor that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status,
     * use the <a>DescribePredictor</a> operation.
     * </p>
     *
     * @param deletePredictorRequest
     * @return Result of the DeletePredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeletePredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeletePredictor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePredictorResponse deletePredictor(DeletePredictorRequest deletePredictorRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a predictor created using the <a>DescribePredictor</a> or <a>CreatePredictor</a> operations. You can
     * delete only predictor that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status,
     * use the <a>DescribePredictor</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePredictorRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePredictorRequest#builder()}
     * </p>
     *
     * @param deletePredictorRequest
     *        A {@link Consumer} that will call methods on {@link DeletePredictorRequest.Builder} to create a request.
     * @return Result of the DeletePredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeletePredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeletePredictor" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePredictorResponse deletePredictor(Consumer<DeletePredictorRequest.Builder> deletePredictorRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deletePredictor(DeletePredictorRequest.builder().applyMutation(deletePredictorRequest).build());
    }

    /**
     * <p>
     * Deletes a predictor backtest export job.
     * </p>
     *
     * @param deletePredictorBacktestExportJobRequest
     * @return Result of the DeletePredictorBacktestExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeletePredictorBacktestExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeletePredictorBacktestExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePredictorBacktestExportJobResponse deletePredictorBacktestExportJob(
            DeletePredictorBacktestExportJobRequest deletePredictorBacktestExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a predictor backtest export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePredictorBacktestExportJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePredictorBacktestExportJobRequest#builder()}
     * </p>
     *
     * @param deletePredictorBacktestExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DeletePredictorBacktestExportJobRequest.Builder} to
     *        create a request.
     * @return Result of the DeletePredictorBacktestExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeletePredictorBacktestExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeletePredictorBacktestExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePredictorBacktestExportJobResponse deletePredictorBacktestExportJob(
            Consumer<DeletePredictorBacktestExportJobRequest.Builder> deletePredictorBacktestExportJobRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deletePredictorBacktestExportJob(DeletePredictorBacktestExportJobRequest.builder()
                .applyMutation(deletePredictorBacktestExportJobRequest).build());
    }

    /**
     * <p>
     * Deletes an entire resource tree. This operation will delete the parent resource and its child resources.
     * </p>
     * <p>
     * Child resources are resources that were created from another resource. For example, when a forecast is generated
     * from a predictor, the forecast is the child resource and the predictor is the parent resource.
     * </p>
     * <p>
     * Amazon Forecast resources possess the following parent-child resource hierarchies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Dataset</b>: dataset import jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Dataset Group</b>: predictors, predictor backtest export jobs, forecasts, forecast export jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Predictor</b>: predictor backtest export jobs, forecasts, forecast export jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Forecast</b>: forecast export jobs
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <code>DeleteResourceTree</code> will only delete Amazon Forecast resources, and will not delete datasets or
     * exported files stored in Amazon S3.
     * </p>
     * </note>
     *
     * @param deleteResourceTreeRequest
     * @return Result of the DeleteResourceTree operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteResourceTree
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteResourceTree" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourceTreeResponse deleteResourceTree(DeleteResourceTreeRequest deleteResourceTreeRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entire resource tree. This operation will delete the parent resource and its child resources.
     * </p>
     * <p>
     * Child resources are resources that were created from another resource. For example, when a forecast is generated
     * from a predictor, the forecast is the child resource and the predictor is the parent resource.
     * </p>
     * <p>
     * Amazon Forecast resources possess the following parent-child resource hierarchies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Dataset</b>: dataset import jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Dataset Group</b>: predictors, predictor backtest export jobs, forecasts, forecast export jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Predictor</b>: predictor backtest export jobs, forecasts, forecast export jobs
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Forecast</b>: forecast export jobs
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <code>DeleteResourceTree</code> will only delete Amazon Forecast resources, and will not delete datasets or
     * exported files stored in Amazon S3.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceTreeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceTreeRequest#builder()}
     * </p>
     *
     * @param deleteResourceTreeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceTreeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceTree operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DeleteResourceTree
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DeleteResourceTree" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourceTreeResponse deleteResourceTree(Consumer<DeleteResourceTreeRequest.Builder> deleteResourceTreeRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return deleteResourceTree(DeleteResourceTreeRequest.builder().applyMutation(deleteResourceTreeRequest).build());
    }

    /**
     * <p>
     * Describes a predictor created using the CreateAutoPredictor operation.
     * </p>
     *
     * @param describeAutoPredictorRequest
     * @return Result of the DescribeAutoPredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeAutoPredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeAutoPredictor"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoPredictorResponse describeAutoPredictor(DescribeAutoPredictorRequest describeAutoPredictorRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a predictor created using the CreateAutoPredictor operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoPredictorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAutoPredictorRequest#builder()}
     * </p>
     *
     * @param describeAutoPredictorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutoPredictorRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAutoPredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeAutoPredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeAutoPredictor"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoPredictorResponse describeAutoPredictor(
            Consumer<DescribeAutoPredictorRequest.Builder> describeAutoPredictorRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeAutoPredictor(DescribeAutoPredictorRequest.builder().applyMutation(describeAutoPredictorRequest).build());
    }

    /**
     * <p>
     * Describes an Amazon Forecast dataset created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation.
     * </p>
     * <p>
     * In addition to listing the parameters specified in the <code>CreateDataset</code> request, this operation
     * includes the following dataset properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeDatasetRequest
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Amazon Forecast dataset created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation.
     * </p>
     * <p>
     * In addition to listing the parameters specified in the <code>CreateDataset</code> request, this operation
     * includes the following dataset properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDatasetRequest#builder()}
     * </p>
     *
     * @param describeDatasetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetRequest.Builder} to create a request.
     * @return Result of the DescribeDataset operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeDataset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDataset" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDatasetResponse describeDataset(Consumer<DescribeDatasetRequest.Builder> describeDatasetRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeDataset(DescribeDatasetRequest.builder().applyMutation(describeDatasetRequest).build());
    }

    /**
     * <p>
     * Describes a dataset group created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation.
     * </p>
     * <p>
     * In addition to listing the parameters provided in the <code>CreateDatasetGroup</code> request, this operation
     * includes the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatasetArns</code> - The datasets belonging to the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeDatasetGroupRequest
     * @return Result of the DescribeDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetGroupResponse describeDatasetGroup(DescribeDatasetGroupRequest describeDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a dataset group created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation.
     * </p>
     * <p>
     * In addition to listing the parameters provided in the <code>CreateDatasetGroup</code> request, this operation
     * includes the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatasetArns</code> - The datasets belonging to the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDatasetGroupRequest#builder()}
     * </p>
     *
     * @param describeDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDatasetGroupResponse describeDatasetGroup(
            Consumer<DescribeDatasetGroupRequest.Builder> describeDatasetGroupRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeDatasetGroup(DescribeDatasetGroupRequest.builder().applyMutation(describeDatasetGroupRequest).build());
    }

    /**
     * <p>
     * Describes a dataset import job created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation.
     * </p>
     * <p>
     * In addition to listing the parameters provided in the <code>CreateDatasetImportJob</code> request, this operation
     * includes the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FieldStatistics</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeDatasetImportJobRequest
     * @return Result of the DescribeDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetImportJobResponse describeDatasetImportJob(
            DescribeDatasetImportJobRequest describeDatasetImportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a dataset import job created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation.
     * </p>
     * <p>
     * In addition to listing the parameters provided in the <code>CreateDatasetImportJob</code> request, this operation
     * includes the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DataSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FieldStatistics</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDatasetImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDatasetImportJobRequest#builder()}
     * </p>
     *
     * @param describeDatasetImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDatasetImportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDatasetImportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeDatasetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDatasetImportJobResponse describeDatasetImportJob(
            Consumer<DescribeDatasetImportJobRequest.Builder> describeDatasetImportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeDatasetImportJob(DescribeDatasetImportJobRequest.builder().applyMutation(describeDatasetImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Describes an Explainability resource created using the <a>CreateExplainability</a> operation.
     * </p>
     *
     * @param describeExplainabilityRequest
     * @return Result of the DescribeExplainability operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeExplainability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeExplainability"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExplainabilityResponse describeExplainability(DescribeExplainabilityRequest describeExplainabilityRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Explainability resource created using the <a>CreateExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExplainabilityRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExplainabilityRequest#builder()}
     * </p>
     *
     * @param describeExplainabilityRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExplainabilityRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeExplainability operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeExplainability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeExplainability"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExplainabilityResponse describeExplainability(
            Consumer<DescribeExplainabilityRequest.Builder> describeExplainabilityRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeExplainability(DescribeExplainabilityRequest.builder().applyMutation(describeExplainabilityRequest)
                .build());
    }

    /**
     * <p>
     * Describes an Explainability export created using the <a>CreateExplainabilityExport</a> operation.
     * </p>
     *
     * @param describeExplainabilityExportRequest
     * @return Result of the DescribeExplainabilityExport operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeExplainabilityExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeExplainabilityExport"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExplainabilityExportResponse describeExplainabilityExport(
            DescribeExplainabilityExportRequest describeExplainabilityExportRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Explainability export created using the <a>CreateExplainabilityExport</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExplainabilityExportRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeExplainabilityExportRequest#builder()}
     * </p>
     *
     * @param describeExplainabilityExportRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExplainabilityExportRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeExplainabilityExport operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeExplainabilityExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeExplainabilityExport"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExplainabilityExportResponse describeExplainabilityExport(
            Consumer<DescribeExplainabilityExportRequest.Builder> describeExplainabilityExportRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeExplainabilityExport(DescribeExplainabilityExportRequest.builder()
                .applyMutation(describeExplainabilityExportRequest).build());
    }

    /**
     * <p>
     * Describes a forecast created using the <a>CreateForecast</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided in the <code>CreateForecast</code> request, this operation lists
     * the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatasetGroupArn</code> - The dataset group that provided the training data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeForecastRequest
     * @return Result of the DescribeForecast operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeForecastResponse describeForecast(DescribeForecastRequest describeForecastRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a forecast created using the <a>CreateForecast</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided in the <code>CreateForecast</code> request, this operation lists
     * the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatasetGroupArn</code> - The dataset group that provided the training data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeForecastRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeForecastRequest#builder()}
     * </p>
     *
     * @param describeForecastRequest
     *        A {@link Consumer} that will call methods on {@link DescribeForecastRequest.Builder} to create a request.
     * @return Result of the DescribeForecast operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeForecast
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecast" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeForecastResponse describeForecast(Consumer<DescribeForecastRequest.Builder> describeForecastRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeForecast(DescribeForecastRequest.builder().applyMutation(describeForecastRequest).build());
    }

    /**
     * <p>
     * Describes a forecast export job created using the <a>CreateForecastExportJob</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided by the user in the <code>CreateForecastExportJob</code> request,
     * this operation lists the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeForecastExportJobRequest
     * @return Result of the DescribeForecastExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeForecastExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecastExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeForecastExportJobResponse describeForecastExportJob(
            DescribeForecastExportJobRequest describeForecastExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a forecast export job created using the <a>CreateForecastExportJob</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided by the user in the <code>CreateForecastExportJob</code> request,
     * this operation lists the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeForecastExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeForecastExportJobRequest#builder()}
     * </p>
     *
     * @param describeForecastExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeForecastExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeForecastExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeForecastExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecastExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeForecastExportJobResponse describeForecastExportJob(
            Consumer<DescribeForecastExportJobRequest.Builder> describeForecastExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeForecastExportJob(DescribeForecastExportJobRequest.builder()
                .applyMutation(describeForecastExportJobRequest).build());
    }

    /**
     * <p>
     * Describes a monitor resource. In addition to listing the properties provided in the <a>CreateMonitor</a> request,
     * this operation lists the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Baseline</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastEvaluationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastEvaluationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeMonitorRequest
     * @return Result of the DescribeMonitor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeMonitorResponse describeMonitor(DescribeMonitorRequest describeMonitorRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a monitor resource. In addition to listing the properties provided in the <a>CreateMonitor</a> request,
     * this operation lists the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Baseline</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastEvaluationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastEvaluationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMonitorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMonitorRequest#builder()}
     * </p>
     *
     * @param describeMonitorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMonitorRequest.Builder} to create a request.
     * @return Result of the DescribeMonitor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribeMonitor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeMonitor" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeMonitorResponse describeMonitor(Consumer<DescribeMonitorRequest.Builder> describeMonitorRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describeMonitor(DescribeMonitorRequest.builder().applyMutation(describeMonitorRequest).build());
    }

    /**
     * <note>
     * <p>
     * This operation is only valid for legacy predictors created with CreatePredictor. If you are not using a legacy
     * predictor, use <a>DescribeAutoPredictor</a>.
     * </p>
     * </note>
     * <p>
     * Describes a predictor created using the <a>CreatePredictor</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided in the <code>CreatePredictor</code> request, this operation lists
     * the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatasetImportJobArns</code> - The dataset import jobs used to import training data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AutoMLAlgorithmArns</code> - If AutoML is performed, the algorithms that were evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     *
     * @param describePredictorRequest
     * @return Result of the DescribePredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribePredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictor" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePredictorResponse describePredictor(DescribePredictorRequest describePredictorRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * This operation is only valid for legacy predictors created with CreatePredictor. If you are not using a legacy
     * predictor, use <a>DescribeAutoPredictor</a>.
     * </p>
     * </note>
     * <p>
     * Describes a predictor created using the <a>CreatePredictor</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided in the <code>CreatePredictor</code> request, this operation lists
     * the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DatasetImportJobArns</code> - The dataset import jobs used to import training data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AutoMLAlgorithmArns</code> - If AutoML is performed, the algorithms that were evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> - If an error occurred, information about the error.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePredictorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePredictorRequest#builder()}
     * </p>
     *
     * @param describePredictorRequest
     *        A {@link Consumer} that will call methods on {@link DescribePredictorRequest.Builder} to create a request.
     * @return Result of the DescribePredictor operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribePredictor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictor" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePredictorResponse describePredictor(Consumer<DescribePredictorRequest.Builder> describePredictorRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describePredictor(DescribePredictorRequest.builder().applyMutation(describePredictorRequest).build());
    }

    /**
     * <p>
     * Describes a predictor backtest export job created using the <a>CreatePredictorBacktestExportJob</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided by the user in the <code>CreatePredictorBacktestExportJob</code>
     * request, this operation lists the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> (if an error occurred)
     * </p>
     * </li>
     * </ul>
     *
     * @param describePredictorBacktestExportJobRequest
     * @return Result of the DescribePredictorBacktestExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribePredictorBacktestExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictorBacktestExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePredictorBacktestExportJobResponse describePredictorBacktestExportJob(
            DescribePredictorBacktestExportJobRequest describePredictorBacktestExportJobRequest) throws InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a predictor backtest export job created using the <a>CreatePredictorBacktestExportJob</a> operation.
     * </p>
     * <p>
     * In addition to listing the properties provided by the user in the <code>CreatePredictorBacktestExportJob</code>
     * request, this operation lists the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastModificationTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Message</code> (if an error occurred)
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePredictorBacktestExportJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePredictorBacktestExportJobRequest#builder()}
     * </p>
     *
     * @param describePredictorBacktestExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribePredictorBacktestExportJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePredictorBacktestExportJob operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.DescribePredictorBacktestExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribePredictorBacktestExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePredictorBacktestExportJobResponse describePredictorBacktestExportJob(
            Consumer<DescribePredictorBacktestExportJobRequest.Builder> describePredictorBacktestExportJobRequest)
            throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return describePredictorBacktestExportJob(DescribePredictorBacktestExportJobRequest.builder()
                .applyMutation(describePredictorBacktestExportJobRequest).build());
    }

    /**
     * <p>
     * Provides metrics on the accuracy of the models that were trained by the <a>CreatePredictor</a> operation. Use
     * metrics to see how well the model performed and to decide whether to use the predictor to generate a forecast.
     * For more information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">Predictor
     * Metrics</a>.
     * </p>
     * <p>
     * This operation generates metrics for each backtest window that was evaluated. The number of backtest windows (
     * <code>NumberOfBacktestWindows</code>) is specified using the <a>EvaluationParameters</a> object, which is
     * optionally included in the <code>CreatePredictor</code> request. If <code>NumberOfBacktestWindows</code> isn't
     * specified, the number defaults to one.
     * </p>
     * <p>
     * The parameters of the <code>filling</code> method determine which items contribute to the metrics. If you want
     * all items to contribute, specify <code>zero</code>. If you want only those items that have complete data in the
     * range being evaluated to contribute, specify <code>nan</code>. For more information, see
     * <a>FeaturizationMethod</a>.
     * </p>
     * <note>
     * <p>
     * Before you can get accuracy metrics, the <code>Status</code> of the predictor must be <code>ACTIVE</code>,
     * signifying that training has completed. To get the status, use the <a>DescribePredictor</a> operation.
     * </p>
     * </note>
     *
     * @param getAccuracyMetricsRequest
     * @return Result of the GetAccuracyMetrics operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.GetAccuracyMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/GetAccuracyMetrics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccuracyMetricsResponse getAccuracyMetrics(GetAccuracyMetricsRequest getAccuracyMetricsRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metrics on the accuracy of the models that were trained by the <a>CreatePredictor</a> operation. Use
     * metrics to see how well the model performed and to decide whether to use the predictor to generate a forecast.
     * For more information, see <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">Predictor
     * Metrics</a>.
     * </p>
     * <p>
     * This operation generates metrics for each backtest window that was evaluated. The number of backtest windows (
     * <code>NumberOfBacktestWindows</code>) is specified using the <a>EvaluationParameters</a> object, which is
     * optionally included in the <code>CreatePredictor</code> request. If <code>NumberOfBacktestWindows</code> isn't
     * specified, the number defaults to one.
     * </p>
     * <p>
     * The parameters of the <code>filling</code> method determine which items contribute to the metrics. If you want
     * all items to contribute, specify <code>zero</code>. If you want only those items that have complete data in the
     * range being evaluated to contribute, specify <code>nan</code>. For more information, see
     * <a>FeaturizationMethod</a>.
     * </p>
     * <note>
     * <p>
     * Before you can get accuracy metrics, the <code>Status</code> of the predictor must be <code>ACTIVE</code>,
     * signifying that training has completed. To get the status, use the <a>DescribePredictor</a> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccuracyMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccuracyMetricsRequest#builder()}
     * </p>
     *
     * @param getAccuracyMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccuracyMetricsRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccuracyMetrics operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.GetAccuracyMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/GetAccuracyMetrics" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccuracyMetricsResponse getAccuracyMetrics(Consumer<GetAccuracyMetricsRequest.Builder> getAccuracyMetricsRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return getAccuracyMetrics(GetAccuracyMetricsRequest.builder().applyMutation(getAccuracyMetricsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset groups created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation. For each dataset group, this operation returns a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     *
     * @param listDatasetGroupsRequest
     * @return Result of the ListDatasetGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsResponse listDatasetGroups(ListDatasetGroupsRequest listDatasetGroupsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset groups created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation. For each dataset group, this operation returns a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDatasetGroupsRequest#builder()}
     * </p>
     *
     * @param listDatasetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetGroupsRequest.Builder} to create a request.
     * @return Result of the ListDatasetGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsResponse listDatasetGroups(Consumer<ListDatasetGroupsRequest.Builder> listDatasetGroupsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        return listDatasetGroups(ListDatasetGroupsRequest.builder().applyMutation(listDatasetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset groups created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation. For each dataset group, this operation returns a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetGroups(software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable responses = client
     *             .listDatasetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetGroups(software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsIterable listDatasetGroupsPaginator(ListDatasetGroupsRequest listDatasetGroupsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset groups created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>
     * operation. For each dataset group, this operation returns a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetGroups(software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable responses = client
     *             .listDatasetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable responses = client.listDatasetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetGroups(software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDatasetGroupsRequest#builder()}
     * </p>
     *
     * @param listDatasetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatasetGroupsIterable listDatasetGroupsPaginator(
            Consumer<ListDatasetGroupsRequest.Builder> listDatasetGroupsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, ForecastException {
        return listDatasetGroupsPaginator(ListDatasetGroupsRequest.builder().applyMutation(listDatasetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset import jobs created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource
     * Name (ARN). You can retrieve the complete set of properties by using the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a> operation. You can filter the list by providing an array of <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html">Filter</a> objects.
     * </p>
     *
     * @param listDatasetImportJobsRequest
     * @return Result of the ListDatasetImportJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsResponse listDatasetImportJobs(ListDatasetImportJobsRequest listDatasetImportJobsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset import jobs created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource
     * Name (ARN). You can retrieve the complete set of properties by using the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a> operation. You can filter the list by providing an array of <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html">Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetImportJobsRequest#builder()}
     * </p>
     *
     * @param listDatasetImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetImportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDatasetImportJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsResponse listDatasetImportJobs(
            Consumer<ListDatasetImportJobsRequest.Builder> listDatasetImportJobsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listDatasetImportJobs(ListDatasetImportJobsRequest.builder().applyMutation(listDatasetImportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of dataset import jobs created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource
     * Name (ARN). You can retrieve the complete set of properties by using the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a> operation. You can filter the list by providing an array of <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html">Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable responses = client
     *             .listDatasetImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDatasetImportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsIterable listDatasetImportJobsPaginator(ListDatasetImportJobsRequest listDatasetImportJobsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of dataset import jobs created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>
     * operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource
     * Name (ARN). You can retrieve the complete set of properties by using the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html"
     * >DescribeDatasetImportJob</a> operation. You can filter the list by providing an array of <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html">Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable responses = client
     *             .listDatasetImportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable responses = client.listDatasetImportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasetImportJobs(software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDatasetImportJobsRequest#builder()}
     * </p>
     *
     * @param listDatasetImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasetImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDatasetImportJobsIterable listDatasetImportJobsPaginator(
            Consumer<ListDatasetImportJobsRequest.Builder> listDatasetImportJobsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listDatasetImportJobsPaginator(ListDatasetImportJobsRequest.builder().applyMutation(listDatasetImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of datasets created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation. For
     * each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the
     * complete set of properties, use the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a> operation.
     * </p>
     *
     * @param listDatasetsRequest
     * @return Result of the ListDatasets operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of datasets created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation. For
     * each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the
     * complete set of properties, use the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return Result of the ListDatasets operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsResponse listDatasets(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        return listDatasets(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of datasets created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation. For
     * each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the
     * complete set of properties, use the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.forecast.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.forecast.model.ListDatasetsRequest)} operation.</b>
     * </p>
     *
     * @param listDatasetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of datasets created using the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_CreateDataset.html">CreateDataset</a> operation. For
     * each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the
     * complete set of properties, use the ARN with the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDataset.html">DescribeDataset</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDatasets(software.amazon.awssdk.services.forecast.model.ListDatasetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListDatasetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable responses = client.listDatasetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatasets(software.amazon.awssdk.services.forecast.model.ListDatasetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatasetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatasetsRequest#builder()}
     * </p>
     *
     * @param listDatasetsRequest
     *        A {@link Consumer} that will call methods on {@link ListDatasetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListDatasets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListDatasets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDatasetsIterable listDatasetsPaginator(Consumer<ListDatasetsRequest.Builder> listDatasetsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        return listDatasetsPaginator(ListDatasetsRequest.builder().applyMutation(listDatasetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Explainability resources created using the <a>CreateExplainability</a> operation. This
     * operation returns a summary for each Explainability. You can filter the list using an array of <a>Filter</a>
     * objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability resource, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     *
     * @param listExplainabilitiesRequest
     * @return Result of the ListExplainabilities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExplainabilitiesResponse listExplainabilities(ListExplainabilitiesRequest listExplainabilitiesRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Explainability resources created using the <a>CreateExplainability</a> operation. This
     * operation returns a summary for each Explainability. You can filter the list using an array of <a>Filter</a>
     * objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability resource, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExplainabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListExplainabilitiesRequest#builder()}
     * </p>
     *
     * @param listExplainabilitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListExplainabilitiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListExplainabilities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExplainabilitiesResponse listExplainabilities(
            Consumer<ListExplainabilitiesRequest.Builder> listExplainabilitiesRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listExplainabilities(ListExplainabilitiesRequest.builder().applyMutation(listExplainabilitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list of Explainability resources created using the <a>CreateExplainability</a> operation. This
     * operation returns a summary for each Explainability. You can filter the list using an array of <a>Filter</a>
     * objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability resource, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExplainabilities(software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable responses = client.listExplainabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable responses = client
     *             .listExplainabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable responses = client.listExplainabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExplainabilities(software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExplainabilitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExplainabilitiesIterable listExplainabilitiesPaginator(ListExplainabilitiesRequest listExplainabilitiesRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Explainability resources created using the <a>CreateExplainability</a> operation. This
     * operation returns a summary for each Explainability. You can filter the list using an array of <a>Filter</a>
     * objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability resource, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExplainabilities(software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable responses = client.listExplainabilitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable responses = client
     *             .listExplainabilitiesPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable responses = client.listExplainabilitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExplainabilities(software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExplainabilitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListExplainabilitiesRequest#builder()}
     * </p>
     *
     * @param listExplainabilitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListExplainabilitiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilities" target="_top">AWS
     *      API Documentation</a>
     */
    default ListExplainabilitiesIterable listExplainabilitiesPaginator(
            Consumer<ListExplainabilitiesRequest.Builder> listExplainabilitiesRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listExplainabilitiesPaginator(ListExplainabilitiesRequest.builder().applyMutation(listExplainabilitiesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Explainability exports created using the <a>CreateExplainabilityExport</a> operation. This
     * operation returns a summary for each Explainability export. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability export, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     *
     * @param listExplainabilityExportsRequest
     * @return Result of the ListExplainabilityExports operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilityExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilityExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExplainabilityExportsResponse listExplainabilityExports(
            ListExplainabilityExportsRequest listExplainabilityExportsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Explainability exports created using the <a>CreateExplainabilityExport</a> operation. This
     * operation returns a summary for each Explainability export. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability export, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExplainabilityExportsRequest.Builder} avoiding
     * the need to create one manually via {@link ListExplainabilityExportsRequest#builder()}
     * </p>
     *
     * @param listExplainabilityExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExplainabilityExportsRequest.Builder} to create a
     *        request.
     * @return Result of the ListExplainabilityExports operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilityExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilityExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExplainabilityExportsResponse listExplainabilityExports(
            Consumer<ListExplainabilityExportsRequest.Builder> listExplainabilityExportsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listExplainabilityExports(ListExplainabilityExportsRequest.builder()
                .applyMutation(listExplainabilityExportsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Explainability exports created using the <a>CreateExplainabilityExport</a> operation. This
     * operation returns a summary for each Explainability export. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability export, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExplainabilityExports(software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable responses = client.listExplainabilityExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable responses = client
     *             .listExplainabilityExportsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable responses = client.listExplainabilityExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExplainabilityExports(software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExplainabilityExportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilityExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilityExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExplainabilityExportsIterable listExplainabilityExportsPaginator(
            ListExplainabilityExportsRequest listExplainabilityExportsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Explainability exports created using the <a>CreateExplainabilityExport</a> operation. This
     * operation returns a summary for each Explainability export. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular Explainability export, use the ARN with the
     * <a>DescribeExplainability</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExplainabilityExports(software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable responses = client.listExplainabilityExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable responses = client
     *             .listExplainabilityExportsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable responses = client.listExplainabilityExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExplainabilityExports(software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExplainabilityExportsRequest.Builder} avoiding
     * the need to create one manually via {@link ListExplainabilityExportsRequest#builder()}
     * </p>
     *
     * @param listExplainabilityExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExplainabilityExportsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListExplainabilityExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListExplainabilityExports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExplainabilityExportsIterable listExplainabilityExportsPaginator(
            Consumer<ListExplainabilityExportsRequest.Builder> listExplainabilityExportsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listExplainabilityExportsPaginator(ListExplainabilityExportsRequest.builder()
                .applyMutation(listExplainabilityExportsRequest).build());
    }

    /**
     * <p>
     * Returns a list of forecast export jobs created using the <a>CreateForecastExportJob</a> operation. For each
     * forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name
     * (ARN). To retrieve the complete set of properties, use the ARN with the <a>DescribeForecastExportJob</a>
     * operation. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     *
     * @param listForecastExportJobsRequest
     * @return Result of the ListForecastExportJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecastExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecastExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListForecastExportJobsResponse listForecastExportJobs(ListForecastExportJobsRequest listForecastExportJobsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of forecast export jobs created using the <a>CreateForecastExportJob</a> operation. For each
     * forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name
     * (ARN). To retrieve the complete set of properties, use the ARN with the <a>DescribeForecastExportJob</a>
     * operation. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListForecastExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListForecastExportJobsRequest#builder()}
     * </p>
     *
     * @param listForecastExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListForecastExportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListForecastExportJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecastExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecastExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListForecastExportJobsResponse listForecastExportJobs(
            Consumer<ListForecastExportJobsRequest.Builder> listForecastExportJobsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listForecastExportJobs(ListForecastExportJobsRequest.builder().applyMutation(listForecastExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of forecast export jobs created using the <a>CreateForecastExportJob</a> operation. For each
     * forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name
     * (ARN). To retrieve the complete set of properties, use the ARN with the <a>DescribeForecastExportJob</a>
     * operation. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listForecastExportJobs(software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable responses = client.listForecastExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable responses = client
     *             .listForecastExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable responses = client.listForecastExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForecastExportJobs(software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listForecastExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecastExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecastExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListForecastExportJobsIterable listForecastExportJobsPaginator(
            ListForecastExportJobsRequest listForecastExportJobsRequest) throws InvalidNextTokenException, InvalidInputException,
            AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of forecast export jobs created using the <a>CreateForecastExportJob</a> operation. For each
     * forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name
     * (ARN). To retrieve the complete set of properties, use the ARN with the <a>DescribeForecastExportJob</a>
     * operation. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listForecastExportJobs(software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable responses = client.listForecastExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable responses = client
     *             .listForecastExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable responses = client.listForecastExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForecastExportJobs(software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListForecastExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListForecastExportJobsRequest#builder()}
     * </p>
     *
     * @param listForecastExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListForecastExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecastExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecastExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListForecastExportJobsIterable listForecastExportJobsPaginator(
            Consumer<ListForecastExportJobsRequest.Builder> listForecastExportJobsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listForecastExportJobsPaginator(ListForecastExportJobsRequest.builder()
                .applyMutation(listForecastExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of forecasts created using the <a>CreateForecast</a> operation. For each forecast, this operation
     * returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of
     * properties, specify the ARN with the <a>DescribeForecast</a> operation. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     *
     * @param listForecastsRequest
     * @return Result of the ListForecasts operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecasts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListForecastsResponse listForecasts(ListForecastsRequest listForecastsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of forecasts created using the <a>CreateForecast</a> operation. For each forecast, this operation
     * returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of
     * properties, specify the ARN with the <a>DescribeForecast</a> operation. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListForecastsRequest.Builder} avoiding the need to
     * create one manually via {@link ListForecastsRequest#builder()}
     * </p>
     *
     * @param listForecastsRequest
     *        A {@link Consumer} that will call methods on {@link ListForecastsRequest.Builder} to create a request.
     * @return Result of the ListForecasts operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecasts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListForecastsResponse listForecasts(Consumer<ListForecastsRequest.Builder> listForecastsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listForecasts(ListForecastsRequest.builder().applyMutation(listForecastsRequest).build());
    }

    /**
     * <p>
     * Returns a list of forecasts created using the <a>CreateForecast</a> operation. For each forecast, this operation
     * returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of
     * properties, specify the ARN with the <a>DescribeForecast</a> operation. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listForecasts(software.amazon.awssdk.services.forecast.model.ListForecastsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable responses = client.listForecastsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable responses = client.listForecastsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListForecastsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable responses = client.listForecastsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForecasts(software.amazon.awssdk.services.forecast.model.ListForecastsRequest)} operation.</b>
     * </p>
     *
     * @param listForecastsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecasts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListForecastsIterable listForecastsPaginator(ListForecastsRequest listForecastsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of forecasts created using the <a>CreateForecast</a> operation. For each forecast, this operation
     * returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of
     * properties, specify the ARN with the <a>DescribeForecast</a> operation. You can filter the list using an array of
     * <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listForecasts(software.amazon.awssdk.services.forecast.model.ListForecastsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable responses = client.listForecastsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable responses = client.listForecastsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListForecastsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable responses = client.listForecastsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForecasts(software.amazon.awssdk.services.forecast.model.ListForecastsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListForecastsRequest.Builder} avoiding the need to
     * create one manually via {@link ListForecastsRequest#builder()}
     * </p>
     *
     * @param listForecastsRequest
     *        A {@link Consumer} that will call methods on {@link ListForecastsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListForecasts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListForecastsIterable listForecastsPaginator(Consumer<ListForecastsRequest.Builder> listForecastsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listForecastsPaginator(ListForecastsRequest.builder().applyMutation(listForecastsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during
     * different windows of time.
     * </p>
     * <p>
     * For information about monitoring see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>. For more information about retrieving monitoring results see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>.
     * </p>
     *
     * @param listMonitorEvaluationsRequest
     * @return Result of the ListMonitorEvaluations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitorEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitorEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorEvaluationsResponse listMonitorEvaluations(ListMonitorEvaluationsRequest listMonitorEvaluationsRequest)
            throws InvalidNextTokenException, InvalidInputException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during
     * different windows of time.
     * </p>
     * <p>
     * For information about monitoring see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>. For more information about retrieving monitoring results see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorEvaluationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMonitorEvaluationsRequest#builder()}
     * </p>
     *
     * @param listMonitorEvaluationsRequest
     *        A {@link Consumer} that will call methods on {@link ListMonitorEvaluationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMonitorEvaluations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitorEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitorEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorEvaluationsResponse listMonitorEvaluations(
            Consumer<ListMonitorEvaluationsRequest.Builder> listMonitorEvaluationsRequest) throws InvalidNextTokenException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return listMonitorEvaluations(ListMonitorEvaluationsRequest.builder().applyMutation(listMonitorEvaluationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during
     * different windows of time.
     * </p>
     * <p>
     * For information about monitoring see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>. For more information about retrieving monitoring results see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitorEvaluations(software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable responses = client.listMonitorEvaluationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable responses = client
     *             .listMonitorEvaluationsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable responses = client.listMonitorEvaluationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitorEvaluations(software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitorEvaluationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitorEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitorEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorEvaluationsIterable listMonitorEvaluationsPaginator(
            ListMonitorEvaluationsRequest listMonitorEvaluationsRequest) throws InvalidNextTokenException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during
     * different windows of time.
     * </p>
     * <p>
     * For information about monitoring see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>. For more information about retrieving monitoring results see <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring-results.html">Viewing Monitoring
     * Results</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMonitorEvaluations(software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable responses = client.listMonitorEvaluationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable responses = client
     *             .listMonitorEvaluationsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable responses = client.listMonitorEvaluationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitorEvaluations(software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorEvaluationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMonitorEvaluationsRequest#builder()}
     * </p>
     *
     * @param listMonitorEvaluationsRequest
     *        A {@link Consumer} that will call methods on {@link ListMonitorEvaluationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitorEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitorEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitorEvaluationsIterable listMonitorEvaluationsPaginator(
            Consumer<ListMonitorEvaluationsRequest.Builder> listMonitorEvaluationsRequest) throws InvalidNextTokenException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return listMonitorEvaluationsPaginator(ListMonitorEvaluationsRequest.builder()
                .applyMutation(listMonitorEvaluationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of monitors created with the <a>CreateMonitor</a> operation and <a>CreateAutoPredictor</a>
     * operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's
     * ARN in the <a>DescribeMonitor</a> operation.
     * </p>
     *
     * @param listMonitorsRequest
     * @return Result of the ListMonitors operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of monitors created with the <a>CreateMonitor</a> operation and <a>CreateAutoPredictor</a>
     * operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's
     * ARN in the <a>DescribeMonitor</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on {@link ListMonitorsRequest.Builder} to create a request.
     * @return Result of the ListMonitors operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsResponse listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listMonitors(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of monitors created with the <a>CreateMonitor</a> operation and <a>CreateAutoPredictor</a>
     * operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's
     * ARN in the <a>DescribeMonitor</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMonitors(software.amazon.awssdk.services.forecast.model.ListMonitorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListMonitorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.forecast.model.ListMonitorsRequest)} operation.</b>
     * </p>
     *
     * @param listMonitorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsIterable listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of monitors created with the <a>CreateMonitor</a> operation and <a>CreateAutoPredictor</a>
     * operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon
     * Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's
     * ARN in the <a>DescribeMonitor</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMonitors(software.amazon.awssdk.services.forecast.model.ListMonitorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListMonitorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable responses = client.listMonitorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitors(software.amazon.awssdk.services.forecast.model.ListMonitorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListMonitorsRequest#builder()}
     * </p>
     *
     * @param listMonitorsRequest
     *        A {@link Consumer} that will call methods on {@link ListMonitorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListMonitors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListMonitors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMonitorsIterable listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listMonitorsPaginator(ListMonitorsRequest.builder().applyMutation(listMonitorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of predictor backtest export jobs created using the <a>CreatePredictorBacktestExportJob</a>
     * operation. This operation returns a summary for each backtest export job. You can filter the list using an array
     * of <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular backtest export job, use the ARN with the
     * <a>DescribePredictorBacktestExportJob</a> operation.
     * </p>
     *
     * @param listPredictorBacktestExportJobsRequest
     * @return Result of the ListPredictorBacktestExportJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictorBacktestExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictorBacktestExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredictorBacktestExportJobsResponse listPredictorBacktestExportJobs(
            ListPredictorBacktestExportJobsRequest listPredictorBacktestExportJobsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of predictor backtest export jobs created using the <a>CreatePredictorBacktestExportJob</a>
     * operation. This operation returns a summary for each backtest export job. You can filter the list using an array
     * of <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular backtest export job, use the ARN with the
     * <a>DescribePredictorBacktestExportJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPredictorBacktestExportJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPredictorBacktestExportJobsRequest#builder()}
     * </p>
     *
     * @param listPredictorBacktestExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListPredictorBacktestExportJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPredictorBacktestExportJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictorBacktestExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictorBacktestExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredictorBacktestExportJobsResponse listPredictorBacktestExportJobs(
            Consumer<ListPredictorBacktestExportJobsRequest.Builder> listPredictorBacktestExportJobsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsRequest.builder()
                .applyMutation(listPredictorBacktestExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of predictor backtest export jobs created using the <a>CreatePredictorBacktestExportJob</a>
     * operation. This operation returns a summary for each backtest export job. You can filter the list using an array
     * of <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular backtest export job, use the ARN with the
     * <a>DescribePredictorBacktestExportJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPredictorBacktestExportJobs(software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable responses = client.listPredictorBacktestExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable responses = client
     *             .listPredictorBacktestExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable responses = client.listPredictorBacktestExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPredictorBacktestExportJobs(software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPredictorBacktestExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictorBacktestExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictorBacktestExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredictorBacktestExportJobsIterable listPredictorBacktestExportJobsPaginator(
            ListPredictorBacktestExportJobsRequest listPredictorBacktestExportJobsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of predictor backtest export jobs created using the <a>CreatePredictorBacktestExportJob</a>
     * operation. This operation returns a summary for each backtest export job. You can filter the list using an array
     * of <a>Filter</a> objects.
     * </p>
     * <p>
     * To retrieve the complete set of properties for a particular backtest export job, use the ARN with the
     * <a>DescribePredictorBacktestExportJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPredictorBacktestExportJobs(software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable responses = client.listPredictorBacktestExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable responses = client
     *             .listPredictorBacktestExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable responses = client.listPredictorBacktestExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPredictorBacktestExportJobs(software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPredictorBacktestExportJobsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPredictorBacktestExportJobsRequest#builder()}
     * </p>
     *
     * @param listPredictorBacktestExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListPredictorBacktestExportJobsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictorBacktestExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictorBacktestExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredictorBacktestExportJobsIterable listPredictorBacktestExportJobsPaginator(
            Consumer<ListPredictorBacktestExportJobsRequest.Builder> listPredictorBacktestExportJobsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listPredictorBacktestExportJobsPaginator(ListPredictorBacktestExportJobsRequest.builder()
                .applyMutation(listPredictorBacktestExportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of predictors created using the <a>CreateAutoPredictor</a> or <a>CreatePredictor</a> operations.
     * For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
     * </p>
     * <p>
     * You can retrieve the complete set of properties by using the ARN with the <a>DescribeAutoPredictor</a> and
     * <a>DescribePredictor</a> operations. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     *
     * @param listPredictorsRequest
     * @return Result of the ListPredictors operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPredictorsResponse listPredictors(ListPredictorsRequest listPredictorsRequest) throws InvalidNextTokenException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of predictors created using the <a>CreateAutoPredictor</a> or <a>CreatePredictor</a> operations.
     * For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
     * </p>
     * <p>
     * You can retrieve the complete set of properties by using the ARN with the <a>DescribeAutoPredictor</a> and
     * <a>DescribePredictor</a> operations. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPredictorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPredictorsRequest#builder()}
     * </p>
     *
     * @param listPredictorsRequest
     *        A {@link Consumer} that will call methods on {@link ListPredictorsRequest.Builder} to create a request.
     * @return Result of the ListPredictors operation returned by the service.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPredictorsResponse listPredictors(Consumer<ListPredictorsRequest.Builder> listPredictorsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listPredictors(ListPredictorsRequest.builder().applyMutation(listPredictorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of predictors created using the <a>CreateAutoPredictor</a> or <a>CreatePredictor</a> operations.
     * For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
     * </p>
     * <p>
     * You can retrieve the complete set of properties by using the ARN with the <a>DescribeAutoPredictor</a> and
     * <a>DescribePredictor</a> operations. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPredictors(software.amazon.awssdk.services.forecast.model.ListPredictorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable responses = client.listPredictorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable responses = client
     *             .listPredictorsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListPredictorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable responses = client.listPredictorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPredictors(software.amazon.awssdk.services.forecast.model.ListPredictorsRequest)} operation.</b>
     * </p>
     *
     * @param listPredictorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPredictorsIterable listPredictorsPaginator(ListPredictorsRequest listPredictorsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of predictors created using the <a>CreateAutoPredictor</a> or <a>CreatePredictor</a> operations.
     * For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
     * </p>
     * <p>
     * You can retrieve the complete set of properties by using the ARN with the <a>DescribeAutoPredictor</a> and
     * <a>DescribePredictor</a> operations. You can filter the list using an array of <a>Filter</a> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPredictors(software.amazon.awssdk.services.forecast.model.ListPredictorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable responses = client.listPredictorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable responses = client
     *             .listPredictorsPaginator(request);
     *     for (software.amazon.awssdk.services.forecast.model.ListPredictorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable responses = client.listPredictorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPredictors(software.amazon.awssdk.services.forecast.model.ListPredictorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPredictorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPredictorsRequest#builder()}
     * </p>
     *
     * @param listPredictorsRequest
     *        A {@link Consumer} that will call methods on {@link ListPredictorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The token is not valid. Tokens expire after 24 hours.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListPredictors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListPredictors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPredictorsIterable listPredictorsPaginator(Consumer<ListPredictorsRequest.Builder> listPredictorsRequest)
            throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listPredictorsPaginator(ListPredictorsRequest.builder().applyMutation(listPredictorsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for an Amazon Forecast resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for an Amazon Forecast resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Resumes a stopped monitor resource.
     * </p>
     *
     * @param resumeResourceRequest
     * @return Result of the ResumeResource operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ResumeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ResumeResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ResumeResourceResponse resumeResource(ResumeResourceRequest resumeResourceRequest) throws InvalidInputException,
            LimitExceededException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException,
            ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resumes a stopped monitor resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeResourceRequest.Builder} avoiding the need to
     * create one manually via {@link ResumeResourceRequest#builder()}
     * </p>
     *
     * @param resumeResourceRequest
     *        A {@link Consumer} that will call methods on {@link ResumeResourceRequest.Builder} to create a request.
     * @return Result of the ResumeResource operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.ResumeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ResumeResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ResumeResourceResponse resumeResource(Consumer<ResumeResourceRequest.Builder> resumeResourceRequest)
            throws InvalidInputException, LimitExceededException, ResourceNotFoundException, ResourceInUseException,
            AwsServiceException, SdkClientException, ForecastException {
        return resumeResource(ResumeResourceRequest.builder().applyMutation(resumeResourceRequest).build());
    }

    /**
     * <p>
     * Stops a resource.
     * </p>
     * <p>
     * The resource undergoes the following states: <code>CREATE_STOPPING</code> and <code>CREATE_STOPPED</code>. You
     * cannot resume a resource once it has been stopped.
     * </p>
     * <p>
     * This operation can be applied to the following resources (and their corresponding child resources):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Dataset Import Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Predictor Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Forecast Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Forecast Export Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Predictor Backtest Export Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Explainability Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Explainability Export Job
     * </p>
     * </li>
     * </ul>
     *
     * @param stopResourceRequest
     * @return Result of the StopResource operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.StopResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/StopResource" target="_top">AWS API
     *      Documentation</a>
     */
    default StopResourceResponse stopResource(StopResourceRequest stopResourceRequest) throws InvalidInputException,
            LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a resource.
     * </p>
     * <p>
     * The resource undergoes the following states: <code>CREATE_STOPPING</code> and <code>CREATE_STOPPED</code>. You
     * cannot resume a resource once it has been stopped.
     * </p>
     * <p>
     * This operation can be applied to the following resources (and their corresponding child resources):
     * </p>
     * <ul>
     * <li>
     * <p>
     * Dataset Import Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Predictor Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Forecast Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Forecast Export Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Predictor Backtest Export Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Explainability Job
     * </p>
     * </li>
     * <li>
     * <p>
     * Explainability Export Job
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopResourceRequest.Builder} avoiding the need to
     * create one manually via {@link StopResourceRequest#builder()}
     * </p>
     *
     * @param stopResourceRequest
     *        A {@link Consumer} that will call methods on {@link StopResourceRequest.Builder} to create a request.
     * @return Result of the StopResource operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.StopResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/StopResource" target="_top">AWS API
     *      Documentation</a>
     */
    default StopResourceResponse stopResource(Consumer<StopResourceRequest.Builder> stopResourceRequest)
            throws InvalidInputException, LimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ForecastException {
        return stopResource(StopResourceRequest.builder().applyMutation(stopResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            LimitExceededException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws LimitExceededException
     *         The limit on the number of resources per account has been exceeded.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, LimitExceededException, InvalidInputException, AwsServiceException,
            SdkClientException, ForecastException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Replaces the datasets in a dataset group with the specified datasets.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset group to
     * create a predictor. Use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation to get the status.
     * </p>
     * </note>
     *
     * @param updateDatasetGroupRequest
     * @return Result of the UpdateDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.UpdateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UpdateDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDatasetGroupResponse updateDatasetGroup(UpdateDatasetGroupRequest updateDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the datasets in a dataset group with the specified datasets.
     * </p>
     * <note>
     * <p>
     * The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset group to
     * create a predictor. Use the <a
     * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>
     * operation to get the status.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDatasetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDatasetGroupRequest#builder()}
     * </p>
     *
     * @param updateDatasetGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDatasetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDatasetGroup operation returned by the service.
     * @throws InvalidInputException
     *         We can't process the request because it includes an invalid value or a value that exceeds the valid
     *         range.
     * @throws ResourceNotFoundException
     *         We can't find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ForecastException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ForecastClient.UpdateDatasetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UpdateDatasetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDatasetGroupResponse updateDatasetGroup(Consumer<UpdateDatasetGroupRequest.Builder> updateDatasetGroupRequest)
            throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException,
            SdkClientException, ForecastException {
        return updateDatasetGroup(UpdateDatasetGroupRequest.builder().applyMutation(updateDatasetGroupRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
