/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePredictorBacktestExportJobResponse extends ForecastResponse implements
        ToCopyableBuilder<DescribePredictorBacktestExportJobResponse.Builder, DescribePredictorBacktestExportJobResponse> {
    private static final SdkField<String> PREDICTOR_BACKTEST_EXPORT_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredictorBacktestExportJobArn")
            .getter(getter(DescribePredictorBacktestExportJobResponse::predictorBacktestExportJobArn))
            .setter(setter(Builder::predictorBacktestExportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobArn")
                    .build()).build();

    private static final SdkField<String> PREDICTOR_BACKTEST_EXPORT_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredictorBacktestExportJobName")
            .getter(getter(DescribePredictorBacktestExportJobResponse::predictorBacktestExportJobName))
            .setter(setter(Builder::predictorBacktestExportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobName")
                    .build()).build();

    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(DescribePredictorBacktestExportJobResponse::predictorArn))
            .setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(DescribePredictorBacktestExportJobResponse::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribePredictorBacktestExportJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribePredictorBacktestExportJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribePredictorBacktestExportJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribePredictorBacktestExportJobResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(DescribePredictorBacktestExportJobResponse::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDICTOR_BACKTEST_EXPORT_JOB_ARN_FIELD, PREDICTOR_BACKTEST_EXPORT_JOB_NAME_FIELD, PREDICTOR_ARN_FIELD,
            DESTINATION_FIELD, MESSAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, FORMAT_FIELD));

    private final String predictorBacktestExportJobArn;

    private final String predictorBacktestExportJobName;

    private final String predictorArn;

    private final DataDestination destination;

    private final String message;

    private final String status;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String format;

    private DescribePredictorBacktestExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.predictorBacktestExportJobArn = builder.predictorBacktestExportJobArn;
        this.predictorBacktestExportJobName = builder.predictorBacktestExportJobName;
        this.predictorArn = builder.predictorArn;
        this.destination = builder.destination;
        this.message = builder.message;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.format = builder.format;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor backtest export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor backtest export job.
     */
    public final String predictorBacktestExportJobArn() {
        return predictorBacktestExportJobArn;
    }

    /**
     * <p>
     * The name of the predictor backtest export job.
     * </p>
     * 
     * @return The name of the predictor backtest export job.
     */
    public final String predictorBacktestExportJobName() {
        return predictorBacktestExportJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * <p>
     * Information about any errors that may have occurred during the backtest export.
     * </p>
     * 
     * @return Information about any errors that may have occurred during the backtest export.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The status of the predictor backtest export job. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the predictor backtest export job. States include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * When the predictor backtest export job was created.
     * </p>
     * 
     * @return When the predictor backtest export job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     * 
     * @return The format of the exported data, CSV or PARQUET.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorBacktestExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(predictorBacktestExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePredictorBacktestExportJobResponse)) {
            return false;
        }
        DescribePredictorBacktestExportJobResponse other = (DescribePredictorBacktestExportJobResponse) obj;
        return Objects.equals(predictorBacktestExportJobArn(), other.predictorBacktestExportJobArn())
                && Objects.equals(predictorBacktestExportJobName(), other.predictorBacktestExportJobName())
                && Objects.equals(predictorArn(), other.predictorArn()) && Objects.equals(destination(), other.destination())
                && Objects.equals(message(), other.message()) && Objects.equals(status(), other.status())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePredictorBacktestExportJobResponse")
                .add("PredictorBacktestExportJobArn", predictorBacktestExportJobArn())
                .add("PredictorBacktestExportJobName", predictorBacktestExportJobName()).add("PredictorArn", predictorArn())
                .add("Destination", destination()).add("Message", message()).add("Status", status())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).add("Format", format())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorBacktestExportJobArn":
            return Optional.ofNullable(clazz.cast(predictorBacktestExportJobArn()));
        case "PredictorBacktestExportJobName":
            return Optional.ofNullable(clazz.cast(predictorBacktestExportJobName()));
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePredictorBacktestExportJobResponse, T> g) {
        return obj -> g.apply((DescribePredictorBacktestExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePredictorBacktestExportJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor backtest export job.
         * </p>
         * 
         * @param predictorBacktestExportJobArn
         *        The Amazon Resource Name (ARN) of the predictor backtest export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorBacktestExportJobArn(String predictorBacktestExportJobArn);

        /**
         * <p>
         * The name of the predictor backtest export job.
         * </p>
         * 
         * @param predictorBacktestExportJobName
         *        The name of the predictor backtest export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorBacktestExportJobName(String predictorBacktestExportJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor.
         * </p>
         * 
         * @param predictorArn
         *        The Amazon Resource Name (ARN) of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataDestination.Builder} avoiding the
         * need to create one manually via {@link DataDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Information about any errors that may have occurred during the backtest export.
         * </p>
         * 
         * @param message
         *        Information about any errors that may have occurred during the backtest export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The status of the predictor backtest export job. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the predictor backtest export job. States include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the predictor backtest export job was created.
         * </p>
         * 
         * @param creationTime
         *        When the predictor backtest export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The format of the exported data, CSV or PARQUET.
         * </p>
         * 
         * @param format
         *        The format of the exported data, CSV or PARQUET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String predictorBacktestExportJobArn;

        private String predictorBacktestExportJobName;

        private String predictorArn;

        private DataDestination destination;

        private String message;

        private String status;

        private Instant creationTime;

        private Instant lastModificationTime;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePredictorBacktestExportJobResponse model) {
            super(model);
            predictorBacktestExportJobArn(model.predictorBacktestExportJobArn);
            predictorBacktestExportJobName(model.predictorBacktestExportJobName);
            predictorArn(model.predictorArn);
            destination(model.destination);
            message(model.message);
            status(model.status);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            format(model.format);
        }

        public final String getPredictorBacktestExportJobArn() {
            return predictorBacktestExportJobArn;
        }

        public final void setPredictorBacktestExportJobArn(String predictorBacktestExportJobArn) {
            this.predictorBacktestExportJobArn = predictorBacktestExportJobArn;
        }

        @Override
        public final Builder predictorBacktestExportJobArn(String predictorBacktestExportJobArn) {
            this.predictorBacktestExportJobArn = predictorBacktestExportJobArn;
            return this;
        }

        public final String getPredictorBacktestExportJobName() {
            return predictorBacktestExportJobName;
        }

        public final void setPredictorBacktestExportJobName(String predictorBacktestExportJobName) {
            this.predictorBacktestExportJobName = predictorBacktestExportJobName;
        }

        @Override
        public final Builder predictorBacktestExportJobName(String predictorBacktestExportJobName) {
            this.predictorBacktestExportJobName = predictorBacktestExportJobName;
            return this;
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public DescribePredictorBacktestExportJobResponse build() {
            return new DescribePredictorBacktestExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
