/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWhatIfForecastExportRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateWhatIfForecastExportRequest.Builder, CreateWhatIfForecastExportRequest> {
    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastExportName").getter(getter(CreateWhatIfForecastExportRequest::whatIfForecastExportName))
            .setter(setter(Builder::whatIfForecastExportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportName").build())
            .build();

    private static final SdkField<List<String>> WHAT_IF_FORECAST_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WhatIfForecastArns")
            .getter(getter(CreateWhatIfForecastExportRequest::whatIfForecastArns))
            .setter(setter(Builder::whatIfForecastArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(CreateWhatIfForecastExportRequest::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWhatIfForecastExportRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(CreateWhatIfForecastExportRequest::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WHAT_IF_FORECAST_EXPORT_NAME_FIELD, WHAT_IF_FORECAST_ARNS_FIELD, DESTINATION_FIELD, TAGS_FIELD, FORMAT_FIELD));

    private final String whatIfForecastExportName;

    private final List<String> whatIfForecastArns;

    private final DataDestination destination;

    private final List<Tag> tags;

    private final String format;

    private CreateWhatIfForecastExportRequest(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastExportName = builder.whatIfForecastExportName;
        this.whatIfForecastArns = builder.whatIfForecastArns;
        this.destination = builder.destination;
        this.tags = builder.tags;
        this.format = builder.format;
    }

    /**
     * <p>
     * The name of the what-if forecast to export.
     * </p>
     * 
     * @return The name of the what-if forecast to export.
     */
    public final String whatIfForecastExportName() {
        return whatIfForecastExportName;
    }

    /**
     * For responses, this returns true if the service returned a value for the WhatIfForecastArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWhatIfForecastArns() {
        return whatIfForecastArns != null && !(whatIfForecastArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of what-if forecast Amazon Resource Names (ARNs) to export.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWhatIfForecastArns} method.
     * </p>
     * 
     * @return The list of what-if forecast Amazon Resource Names (ARNs) to export.
     */
    public final List<String> whatIfForecastArns() {
        return whatIfForecastArns;
    }

    /**
     * <p>
     * The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that Amazon
     * Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket.
     * </p>
     * <p>
     * If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The IAM
     * role must allow Amazon Forecast permission to access the key.
     * </p>
     * 
     * @return The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role
     *         that Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3
     *         bucket.</p>
     *         <p>
     *         If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The
     *         IAM role must allow Amazon Forecast permission to access the key.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
     * apply to the what if forecast.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a
     *         href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to apply
     *         to the what if forecast.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The format of the exported data, CSV or PARQUET.
     * </p>
     * 
     * @return The format of the exported data, CSV or PARQUET.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastExportName());
        hashCode = 31 * hashCode + Objects.hashCode(hasWhatIfForecastArns() ? whatIfForecastArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatIfForecastExportRequest)) {
            return false;
        }
        CreateWhatIfForecastExportRequest other = (CreateWhatIfForecastExportRequest) obj;
        return Objects.equals(whatIfForecastExportName(), other.whatIfForecastExportName())
                && hasWhatIfForecastArns() == other.hasWhatIfForecastArns()
                && Objects.equals(whatIfForecastArns(), other.whatIfForecastArns())
                && Objects.equals(destination(), other.destination()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWhatIfForecastExportRequest").add("WhatIfForecastExportName", whatIfForecastExportName())
                .add("WhatIfForecastArns", hasWhatIfForecastArns() ? whatIfForecastArns() : null)
                .add("Destination", destination()).add("Tags", hasTags() ? tags() : null).add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastExportName":
            return Optional.ofNullable(clazz.cast(whatIfForecastExportName()));
        case "WhatIfForecastArns":
            return Optional.ofNullable(clazz.cast(whatIfForecastArns()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatIfForecastExportRequest, T> g) {
        return obj -> g.apply((CreateWhatIfForecastExportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWhatIfForecastExportRequest> {
        /**
         * <p>
         * The name of the what-if forecast to export.
         * </p>
         * 
         * @param whatIfForecastExportName
         *        The name of the what-if forecast to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExportName(String whatIfForecastExportName);

        /**
         * <p>
         * The list of what-if forecast Amazon Resource Names (ARNs) to export.
         * </p>
         * 
         * @param whatIfForecastArns
         *        The list of what-if forecast Amazon Resource Names (ARNs) to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArns(Collection<String> whatIfForecastArns);

        /**
         * <p>
         * The list of what-if forecast Amazon Resource Names (ARNs) to export.
         * </p>
         * 
         * @param whatIfForecastArns
         *        The list of what-if forecast Amazon Resource Names (ARNs) to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArns(String... whatIfForecastArns);

        /**
         * <p>
         * The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that
         * Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket.
         * </p>
         * <p>
         * If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The IAM
         * role must allow Amazon Forecast permission to access the key.
         * </p>
         * 
         * @param destination
         *        The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role
         *        that Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3
         *        bucket.</p>
         *        <p>
         *        If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key.
         *        The IAM role must allow Amazon Forecast permission to access the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * <p>
         * The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that
         * Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket.
         * </p>
         * <p>
         * If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The IAM
         * role must allow Amazon Forecast permission to access the key.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataDestination.Builder} avoiding the
         * need to create one manually via {@link DataDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * 
         * @param tags
         *        A list of <a
         *        href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
         *        apply to the what if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * 
         * @param tags
         *        A list of <a
         *        href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
         *        apply to the what if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The format of the exported data, CSV or PARQUET.
         * </p>
         * 
         * @param format
         *        The format of the exported data, CSV or PARQUET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String whatIfForecastExportName;

        private List<String> whatIfForecastArns = DefaultSdkAutoConstructList.getInstance();

        private DataDestination destination;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatIfForecastExportRequest model) {
            super(model);
            whatIfForecastExportName(model.whatIfForecastExportName);
            whatIfForecastArns(model.whatIfForecastArns);
            destination(model.destination);
            tags(model.tags);
            format(model.format);
        }

        public final String getWhatIfForecastExportName() {
            return whatIfForecastExportName;
        }

        public final void setWhatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
        }

        @Override
        public final Builder whatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
            return this;
        }

        public final Collection<String> getWhatIfForecastArns() {
            if (whatIfForecastArns instanceof SdkAutoConstructList) {
                return null;
            }
            return whatIfForecastArns;
        }

        public final void setWhatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = WhatIfForecastArnListForExportCopier.copy(whatIfForecastArns);
        }

        @Override
        public final Builder whatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = WhatIfForecastArnListForExportCopier.copy(whatIfForecastArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecastArns(String... whatIfForecastArns) {
            whatIfForecastArns(Arrays.asList(whatIfForecastArns));
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatIfForecastExportRequest build() {
            return new CreateWhatIfForecastExportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
