/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the what-if forecast export properties used in the <a>ListWhatIfForecastExports</a> operation.
 * To get the complete set of properties, call the <a>DescribeWhatIfForecastExport</a> operation, and provide the
 * <code>WhatIfForecastExportArn</code> that is listed in the summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatIfForecastExportSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WhatIfForecastExportSummary.Builder, WhatIfForecastExportSummary> {
    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastExportArn").getter(getter(WhatIfForecastExportSummary::whatIfForecastExportArn))
            .setter(setter(Builder::whatIfForecastExportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportArn").build())
            .build();

    private static final SdkField<List<String>> WHAT_IF_FORECAST_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("WhatIfForecastArns")
            .getter(getter(WhatIfForecastExportSummary::whatIfForecastArns))
            .setter(setter(Builder::whatIfForecastArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WHAT_IF_FORECAST_EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastExportName").getter(getter(WhatIfForecastExportSummary::whatIfForecastExportName))
            .setter(setter(Builder::whatIfForecastExportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastExportName").build())
            .build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(WhatIfForecastExportSummary::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(WhatIfForecastExportSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(WhatIfForecastExportSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(WhatIfForecastExportSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(WhatIfForecastExportSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WHAT_IF_FORECAST_EXPORT_ARN_FIELD, WHAT_IF_FORECAST_ARNS_FIELD, WHAT_IF_FORECAST_EXPORT_NAME_FIELD,
            DESTINATION_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String whatIfForecastExportArn;

    private final List<String> whatIfForecastArns;

    private final String whatIfForecastExportName;

    private final DataDestination destination;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private WhatIfForecastExportSummary(BuilderImpl builder) {
        this.whatIfForecastExportArn = builder.whatIfForecastExportArn;
        this.whatIfForecastArns = builder.whatIfForecastArns;
        this.whatIfForecastExportName = builder.whatIfForecastExportName;
        this.destination = builder.destination;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if forecast export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if forecast export.
     */
    public final String whatIfForecastExportArn() {
        return whatIfForecastExportArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the WhatIfForecastArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWhatIfForecastArns() {
        return whatIfForecastArns != null && !(whatIfForecastArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWhatIfForecastArns} method.
     * </p>
     * 
     * @return An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
     */
    public final List<String> whatIfForecastArns() {
        return whatIfForecastArns;
    }

    /**
     * <p>
     * The what-if forecast export name.
     * </p>
     * 
     * @return The what-if forecast export name.
     */
    public final String whatIfForecastExportName() {
        return whatIfForecastExportName;
    }

    /**
     * <p>
     * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
     * </p>
     * 
     * @return The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The status of the what-if forecast export. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the analysis.
     * </p>
     * </note>
     * 
     * @return The status of the what-if forecast export. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the
     *         analysis.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the what-if forecast export was created.
     * </p>
     * 
     * @return When the what-if forecast export was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastExportArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasWhatIfForecastArns() ? whatIfForecastArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastExportName());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatIfForecastExportSummary)) {
            return false;
        }
        WhatIfForecastExportSummary other = (WhatIfForecastExportSummary) obj;
        return Objects.equals(whatIfForecastExportArn(), other.whatIfForecastExportArn())
                && hasWhatIfForecastArns() == other.hasWhatIfForecastArns()
                && Objects.equals(whatIfForecastArns(), other.whatIfForecastArns())
                && Objects.equals(whatIfForecastExportName(), other.whatIfForecastExportName())
                && Objects.equals(destination(), other.destination()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatIfForecastExportSummary").add("WhatIfForecastExportArn", whatIfForecastExportArn())
                .add("WhatIfForecastArns", hasWhatIfForecastArns() ? whatIfForecastArns() : null)
                .add("WhatIfForecastExportName", whatIfForecastExportName()).add("Destination", destination())
                .add("Status", status()).add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastExportArn":
            return Optional.ofNullable(clazz.cast(whatIfForecastExportArn()));
        case "WhatIfForecastArns":
            return Optional.ofNullable(clazz.cast(whatIfForecastArns()));
        case "WhatIfForecastExportName":
            return Optional.ofNullable(clazz.cast(whatIfForecastExportName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WhatIfForecastExportSummary, T> g) {
        return obj -> g.apply((WhatIfForecastExportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatIfForecastExportSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if forecast export.
         * </p>
         * 
         * @param whatIfForecastExportArn
         *        The Amazon Resource Name (ARN) of the what-if forecast export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExportArn(String whatIfForecastExportArn);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
         * </p>
         * 
         * @param whatIfForecastArns
         *        An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArns(Collection<String> whatIfForecastArns);

        /**
         * <p>
         * An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
         * </p>
         * 
         * @param whatIfForecastArns
         *        An array of Amazon Resource Names (ARNs) that define the what-if forecasts included in the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastArns(String... whatIfForecastArns);

        /**
         * <p>
         * The what-if forecast export name.
         * </p>
         * 
         * @param whatIfForecastExportName
         *        The what-if forecast export name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastExportName(String whatIfForecastExportName);

        /**
         * <p>
         * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         * </p>
         * 
         * @param destination
         *        The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * <p>
         * The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataDestination.Builder} avoiding the
         * need to create one manually via {@link DataDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The status of the what-if forecast export. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the
         * analysis.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the what-if forecast export. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the what-if analysis must be <code>ACTIVE</code> before you can access the
         *        analysis.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the what-if forecast export was created.
         * </p>
         * 
         * @param creationTime
         *        When the what-if forecast export was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String whatIfForecastExportArn;

        private List<String> whatIfForecastArns = DefaultSdkAutoConstructList.getInstance();

        private String whatIfForecastExportName;

        private DataDestination destination;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatIfForecastExportSummary model) {
            whatIfForecastExportArn(model.whatIfForecastExportArn);
            whatIfForecastArns(model.whatIfForecastArns);
            whatIfForecastExportName(model.whatIfForecastExportName);
            destination(model.destination);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getWhatIfForecastExportArn() {
            return whatIfForecastExportArn;
        }

        public final void setWhatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
        }

        @Override
        public final Builder whatIfForecastExportArn(String whatIfForecastExportArn) {
            this.whatIfForecastExportArn = whatIfForecastExportArn;
            return this;
        }

        public final Collection<String> getWhatIfForecastArns() {
            if (whatIfForecastArns instanceof SdkAutoConstructList) {
                return null;
            }
            return whatIfForecastArns;
        }

        public final void setWhatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = WhatIfForecastArnListForExportCopier.copy(whatIfForecastArns);
        }

        @Override
        public final Builder whatIfForecastArns(Collection<String> whatIfForecastArns) {
            this.whatIfForecastArns = WhatIfForecastArnListForExportCopier.copy(whatIfForecastArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whatIfForecastArns(String... whatIfForecastArns) {
            whatIfForecastArns(Arrays.asList(whatIfForecastArns));
            return this;
        }

        public final String getWhatIfForecastExportName() {
            return whatIfForecastExportName;
        }

        public final void setWhatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
        }

        @Override
        public final Builder whatIfForecastExportName(String whatIfForecastExportName) {
            this.whatIfForecastExportName = whatIfForecastExportName;
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public WhatIfForecastExportSummary build() {
            return new WhatIfForecastExportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
