/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the Explainability export properties used in the <a>ListExplainabilityExports</a> operation. To
 * get a complete set of properties, call the <a>DescribeExplainabilityExport</a> operation, and provide the
 * <code>ExplainabilityExportArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExplainabilityExportSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExplainabilityExportSummary.Builder, ExplainabilityExportSummary> {
    private static final SdkField<String> EXPLAINABILITY_EXPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityExportArn").getter(getter(ExplainabilityExportSummary::explainabilityExportArn))
            .setter(setter(Builder::explainabilityExportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityExportArn").build())
            .build();

    private static final SdkField<String> EXPLAINABILITY_EXPORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityExportName").getter(getter(ExplainabilityExportSummary::explainabilityExportName))
            .setter(setter(Builder::explainabilityExportName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityExportName").build())
            .build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(ExplainabilityExportSummary::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExplainabilityExportSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ExplainabilityExportSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ExplainabilityExportSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(ExplainabilityExportSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPLAINABILITY_EXPORT_ARN_FIELD, EXPLAINABILITY_EXPORT_NAME_FIELD, DESTINATION_FIELD, STATUS_FIELD, MESSAGE_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String explainabilityExportArn;

    private final String explainabilityExportName;

    private final DataDestination destination;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private ExplainabilityExportSummary(BuilderImpl builder) {
        this.explainabilityExportArn = builder.explainabilityExportArn;
        this.explainabilityExportName = builder.explainabilityExportName;
        this.destination = builder.destination;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Explainability export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Explainability export.
     */
    public final String explainabilityExportArn() {
        return explainabilityExportArn;
    }

    /**
     * <p>
     * The name of the Explainability export
     * </p>
     * 
     * @return The name of the Explainability export
     */
    public final String explainabilityExportName() {
        return explainabilityExportName;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * <p>
     * The status of the Explainability export. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the Explainability export. States include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Information about any errors that may have occurred during the Explainability export.
     * </p>
     * 
     * @return Information about any errors that may have occurred during the Explainability export.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the Explainability was created.
     * </p>
     * 
     * @return When the Explainability was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityExportArn());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityExportName());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplainabilityExportSummary)) {
            return false;
        }
        ExplainabilityExportSummary other = (ExplainabilityExportSummary) obj;
        return Objects.equals(explainabilityExportArn(), other.explainabilityExportArn())
                && Objects.equals(explainabilityExportName(), other.explainabilityExportName())
                && Objects.equals(destination(), other.destination()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExplainabilityExportSummary").add("ExplainabilityExportArn", explainabilityExportArn())
                .add("ExplainabilityExportName", explainabilityExportName()).add("Destination", destination())
                .add("Status", status()).add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplainabilityExportArn":
            return Optional.ofNullable(clazz.cast(explainabilityExportArn()));
        case "ExplainabilityExportName":
            return Optional.ofNullable(clazz.cast(explainabilityExportName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExplainabilityExportSummary, T> g) {
        return obj -> g.apply((ExplainabilityExportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExplainabilityExportSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Explainability export.
         * </p>
         * 
         * @param explainabilityExportArn
         *        The Amazon Resource Name (ARN) of the Explainability export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityExportArn(String explainabilityExportArn);

        /**
         * <p>
         * The name of the Explainability export
         * </p>
         * 
         * @param explainabilityExportName
         *        The name of the Explainability export
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityExportName(String explainabilityExportName);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataDestination.Builder} avoiding the
         * need to create one manually via {@link DataDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The status of the Explainability export. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Explainability export. States include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Information about any errors that may have occurred during the Explainability export.
         * </p>
         * 
         * @param message
         *        Information about any errors that may have occurred during the Explainability export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the Explainability was created.
         * </p>
         * 
         * @param creationTime
         *        When the Explainability was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String explainabilityExportArn;

        private String explainabilityExportName;

        private DataDestination destination;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplainabilityExportSummary model) {
            explainabilityExportArn(model.explainabilityExportArn);
            explainabilityExportName(model.explainabilityExportName);
            destination(model.destination);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getExplainabilityExportArn() {
            return explainabilityExportArn;
        }

        public final void setExplainabilityExportArn(String explainabilityExportArn) {
            this.explainabilityExportArn = explainabilityExportArn;
        }

        @Override
        public final Builder explainabilityExportArn(String explainabilityExportArn) {
            this.explainabilityExportArn = explainabilityExportArn;
            return this;
        }

        public final String getExplainabilityExportName() {
            return explainabilityExportName;
        }

        public final void setExplainabilityExportName(String explainabilityExportName) {
            this.explainabilityExportName = explainabilityExportName;
        }

        @Override
        public final Builder explainabilityExportName(String explainabilityExportName) {
            this.explainabilityExportName = explainabilityExportName;
            return this;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public ExplainabilityExportSummary build() {
            return new ExplainabilityExportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
