/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateForecastResponse extends ForecastResponse implements
        ToCopyableBuilder<CreateForecastResponse.Builder, CreateForecastResponse> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastArn").getter(getter(CreateForecastResponse::forecastArn)).setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD));

    private final String forecastArn;

    private CreateForecastResponse(BuilderImpl builder) {
        super(builder);
        this.forecastArn = builder.forecastArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the forecast.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the forecast.
     */
    public final String forecastArn() {
        return forecastArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateForecastResponse)) {
            return false;
        }
        CreateForecastResponse other = (CreateForecastResponse) obj;
        return Objects.equals(forecastArn(), other.forecastArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateForecastResponse").add("ForecastArn", forecastArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateForecastResponse, T> g) {
        return obj -> g.apply((CreateForecastResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateForecastResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the forecast.
         * </p>
         * 
         * @param forecastArn
         *        The Amazon Resource Name (ARN) of the forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String forecastArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateForecastResponse model) {
            super(model);
            forecastArn(model.forecastArn);
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        @Transient
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        @Override
        public CreateForecastResponse build() {
            return new CreateForecastResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
