/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ExplainabilityExportsCopier {
    static List<ExplainabilityExportSummary> copy(Collection<? extends ExplainabilityExportSummary> explainabilityExportsParam) {
        List<ExplainabilityExportSummary> list;
        if (explainabilityExportsParam == null || explainabilityExportsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExplainabilityExportSummary> modifiableList = new ArrayList<>();
            explainabilityExportsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExplainabilityExportSummary> copyFromBuilder(
            Collection<? extends ExplainabilityExportSummary.Builder> explainabilityExportsParam) {
        List<ExplainabilityExportSummary> list;
        if (explainabilityExportsParam == null || explainabilityExportsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExplainabilityExportSummary> modifiableList = new ArrayList<>();
            explainabilityExportsParam.forEach(entry -> {
                ExplainabilityExportSummary member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ExplainabilityExportSummary.Builder> copyToBuilder(
            Collection<? extends ExplainabilityExportSummary> explainabilityExportsParam) {
        List<ExplainabilityExportSummary.Builder> list;
        if (explainabilityExportsParam == null || explainabilityExportsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ExplainabilityExportSummary.Builder> modifiableList = new ArrayList<>();
            explainabilityExportsParam.forEach(entry -> {
                ExplainabilityExportSummary.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
