/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoPredictorRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateAutoPredictorRequest.Builder, CreateAutoPredictorRequest> {
    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorName").getter(getter(CreateAutoPredictorRequest::predictorName))
            .setter(setter(Builder::predictorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()).build();

    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ForecastHorizon").getter(getter(CreateAutoPredictorRequest::forecastHorizon))
            .setter(setter(Builder::forecastHorizon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()).build();

    private static final SdkField<List<String>> FORECAST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastTypes")
            .getter(getter(CreateAutoPredictorRequest::forecastTypes))
            .setter(setter(Builder::forecastTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FORECAST_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ForecastDimensions")
            .getter(getter(CreateAutoPredictorRequest::forecastDimensions))
            .setter(setter(Builder::forecastDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FORECAST_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastFrequency").getter(getter(CreateAutoPredictorRequest::forecastFrequency))
            .setter(setter(Builder::forecastFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastFrequency").build()).build();

    private static final SdkField<DataConfig> DATA_CONFIG_FIELD = SdkField.<DataConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DataConfig").getter(getter(CreateAutoPredictorRequest::dataConfig)).setter(setter(Builder::dataConfig))
            .constructor(DataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataConfig").build()).build();

    private static final SdkField<EncryptionConfig> ENCRYPTION_CONFIG_FIELD = SdkField
            .<EncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("EncryptionConfig")
            .getter(getter(CreateAutoPredictorRequest::encryptionConfig)).setter(setter(Builder::encryptionConfig))
            .constructor(EncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfig").build()).build();

    private static final SdkField<String> REFERENCE_PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferencePredictorArn").getter(getter(CreateAutoPredictorRequest::referencePredictorArn))
            .setter(setter(Builder::referencePredictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePredictorArn").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationMetric").getter(getter(CreateAutoPredictorRequest::optimizationMetricAsString))
            .setter(setter(Builder::optimizationMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build())
            .build();

    private static final SdkField<Boolean> EXPLAIN_PREDICTOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExplainPredictor").getter(getter(CreateAutoPredictorRequest::explainPredictor))
            .setter(setter(Builder::explainPredictor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainPredictor").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAutoPredictorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_NAME_FIELD,
            FORECAST_HORIZON_FIELD, FORECAST_TYPES_FIELD, FORECAST_DIMENSIONS_FIELD, FORECAST_FREQUENCY_FIELD, DATA_CONFIG_FIELD,
            ENCRYPTION_CONFIG_FIELD, REFERENCE_PREDICTOR_ARN_FIELD, OPTIMIZATION_METRIC_FIELD, EXPLAIN_PREDICTOR_FIELD,
            TAGS_FIELD));

    private final String predictorName;

    private final Integer forecastHorizon;

    private final List<String> forecastTypes;

    private final List<String> forecastDimensions;

    private final String forecastFrequency;

    private final DataConfig dataConfig;

    private final EncryptionConfig encryptionConfig;

    private final String referencePredictorArn;

    private final String optimizationMetric;

    private final Boolean explainPredictor;

    private final List<Tag> tags;

    private CreateAutoPredictorRequest(BuilderImpl builder) {
        super(builder);
        this.predictorName = builder.predictorName;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastTypes = builder.forecastTypes;
        this.forecastDimensions = builder.forecastDimensions;
        this.forecastFrequency = builder.forecastFrequency;
        this.dataConfig = builder.dataConfig;
        this.encryptionConfig = builder.encryptionConfig;
        this.referencePredictorArn = builder.referencePredictorArn;
        this.optimizationMetric = builder.optimizationMetric;
        this.explainPredictor = builder.explainPredictor;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name for the predictor
     * </p>
     * 
     * @return A unique name for the predictor
     */
    public final String predictorName() {
        return predictorName;
    }

    /**
     * <p>
     * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
     * </p>
     * 
     * @return The number of time-steps that the model predicts. The forecast horizon is also called the prediction
     *         length.
     */
    public final Integer forecastHorizon() {
        return forecastHorizon;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastTypes() {
        return forecastTypes != null && !(forecastTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can be
     * quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with
     * <code>mean</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastTypes} method.
     * </p>
     * 
     * @return The forecast types used to train a predictor. You can specify up to five forecast types. Forecast types
     *         can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean
     *         forecast with <code>mean</code>.
     */
    public final List<String> forecastTypes() {
        return forecastTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastDimensions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasForecastDimensions() {
        return forecastDimensions != null && !(forecastDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of dimension (field) names that specify how to group the generated forecast.
     * </p>
     * <p>
     * For example, if you are generating forecasts for item sales across all your stores, and your dataset contains a
     * <code>store_id</code> field, you would specify <code>store_id</code> as a dimension to group sales forecasts for
     * each store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastDimensions} method.
     * </p>
     * 
     * @return An array of dimension (field) names that specify how to group the generated forecast.</p>
     *         <p>
     *         For example, if you are generating forecasts for item sales across all your stores, and your dataset
     *         contains a <code>store_id</code> field, you would specify <code>store_id</code> as a dimension to group
     *         sales forecasts for each store.
     */
    public final List<String> forecastDimensions() {
        return forecastDimensions;
    }

    /**
     * <p>
     * The frequency of predictions in a forecast.
     * </p>
     * <p>
     * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
     * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min"
     * indicates every five minutes.
     * </p>
     * <p>
     * The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
     * </p>
     * <p>
     * When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset
     * frequency.
     * </p>
     * 
     * @return The frequency of predictions in a forecast.</p>
     *         <p>
     *         Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
     *         minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every
     *         year and "5min" indicates every five minutes.
     *         </p>
     *         <p>
     *         The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
     *         </p>
     *         <p>
     *         When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES
     *         dataset frequency.
     */
    public final String forecastFrequency() {
        return forecastFrequency;
    }

    /**
     * <p>
     * The data configuration for your dataset group and any additional datasets.
     * </p>
     * 
     * @return The data configuration for your dataset group and any additional datasets.
     */
    public final DataConfig dataConfig() {
        return dataConfig;
    }

    /**
     * Returns the value of the EncryptionConfig property for this object.
     * 
     * @return The value of the EncryptionConfig property for this object.
     */
    public final EncryptionConfig encryptionConfig() {
        return encryptionConfig;
    }

    /**
     * <p>
     * The ARN of the predictor to retrain or upgrade. This parameter is only used when retraining or upgrading a
     * predictor. When creating a new predictor, do not specify a value for this parameter.
     * </p>
     * <p>
     * When upgrading or retraining a predictor, only specify values for the <code>ReferencePredictorArn</code> and
     * <code>PredictorName</code>. The value for <code>PredictorName</code> must be a unique predictor name.
     * </p>
     * 
     * @return The ARN of the predictor to retrain or upgrade. This parameter is only used when retraining or upgrading
     *         a predictor. When creating a new predictor, do not specify a value for this parameter.</p>
     *         <p>
     *         When upgrading or retraining a predictor, only specify values for the <code>ReferencePredictorArn</code>
     *         and <code>PredictorName</code>. The value for <code>PredictorName</code> must be a unique predictor name.
     */
    public final String referencePredictorArn() {
        return referencePredictorArn;
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(optimizationMetric);
    }

    /**
     * <p>
     * The accuracy metric used to optimize the predictor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationMetric} will return {@link OptimizationMetric#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizationMetricAsString}.
     * </p>
     * 
     * @return The accuracy metric used to optimize the predictor.
     * @see OptimizationMetric
     */
    public final String optimizationMetricAsString() {
        return optimizationMetric;
    }

    /**
     * Returns the value of the ExplainPredictor property for this object.
     * 
     * @return The value of the ExplainPredictor property for this object.
     */
    public final Boolean explainPredictor() {
        return explainPredictor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an optional
     * value, both of which you define. Tag keys and values are case sensitive.
     * </p>
     * <p>
     * The following restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For each resource, each tag key must be unique and each tag key must have one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum number of tags per resource: 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging
     * schema is used across other services and resources, the character restrictions of those services also apply.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>. Values
     * can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast considers
     * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
     * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with this
     * prefix.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an
     *         optional value, both of which you define. Tag keys and values are case sensitive.</p>
     *         <p>
     *         The following restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique and each tag key must have one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource: 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
     *         tagging schema is used across other services and resources, the character restrictions of those services
     *         also apply.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
     *         Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
     *         Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the
     *         key prefix of <code>aws</code> do not count against your tags per resource limit. You cannot edit or
     *         delete tag keys with this prefix.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastTypes() ? forecastTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastDimensions() ? forecastDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(forecastFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(dataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(referencePredictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(explainPredictor());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoPredictorRequest)) {
            return false;
        }
        CreateAutoPredictorRequest other = (CreateAutoPredictorRequest) obj;
        return Objects.equals(predictorName(), other.predictorName())
                && Objects.equals(forecastHorizon(), other.forecastHorizon()) && hasForecastTypes() == other.hasForecastTypes()
                && Objects.equals(forecastTypes(), other.forecastTypes())
                && hasForecastDimensions() == other.hasForecastDimensions()
                && Objects.equals(forecastDimensions(), other.forecastDimensions())
                && Objects.equals(forecastFrequency(), other.forecastFrequency())
                && Objects.equals(dataConfig(), other.dataConfig())
                && Objects.equals(encryptionConfig(), other.encryptionConfig())
                && Objects.equals(referencePredictorArn(), other.referencePredictorArn())
                && Objects.equals(optimizationMetricAsString(), other.optimizationMetricAsString())
                && Objects.equals(explainPredictor(), other.explainPredictor()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutoPredictorRequest").add("PredictorName", predictorName())
                .add("ForecastHorizon", forecastHorizon()).add("ForecastTypes", hasForecastTypes() ? forecastTypes() : null)
                .add("ForecastDimensions", hasForecastDimensions() ? forecastDimensions() : null)
                .add("ForecastFrequency", forecastFrequency()).add("DataConfig", dataConfig())
                .add("EncryptionConfig", encryptionConfig()).add("ReferencePredictorArn", referencePredictorArn())
                .add("OptimizationMetric", optimizationMetricAsString()).add("ExplainPredictor", explainPredictor())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorName":
            return Optional.ofNullable(clazz.cast(predictorName()));
        case "ForecastHorizon":
            return Optional.ofNullable(clazz.cast(forecastHorizon()));
        case "ForecastTypes":
            return Optional.ofNullable(clazz.cast(forecastTypes()));
        case "ForecastDimensions":
            return Optional.ofNullable(clazz.cast(forecastDimensions()));
        case "ForecastFrequency":
            return Optional.ofNullable(clazz.cast(forecastFrequency()));
        case "DataConfig":
            return Optional.ofNullable(clazz.cast(dataConfig()));
        case "EncryptionConfig":
            return Optional.ofNullable(clazz.cast(encryptionConfig()));
        case "ReferencePredictorArn":
            return Optional.ofNullable(clazz.cast(referencePredictorArn()));
        case "OptimizationMetric":
            return Optional.ofNullable(clazz.cast(optimizationMetricAsString()));
        case "ExplainPredictor":
            return Optional.ofNullable(clazz.cast(explainPredictor()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoPredictorRequest, T> g) {
        return obj -> g.apply((CreateAutoPredictorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAutoPredictorRequest> {
        /**
         * <p>
         * A unique name for the predictor
         * </p>
         * 
         * @param predictorName
         *        A unique name for the predictor
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorName(String predictorName);

        /**
         * <p>
         * The number of time-steps that the model predicts. The forecast horizon is also called the prediction length.
         * </p>
         * 
         * @param forecastHorizon
         *        The number of time-steps that the model predicts. The forecast horizon is also called the prediction
         *        length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastHorizon(Integer forecastHorizon);

        /**
         * <p>
         * The forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can
         * be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with
         * <code>mean</code>.
         * </p>
         * 
         * @param forecastTypes
         *        The forecast types used to train a predictor. You can specify up to five forecast types. Forecast
         *        types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the
         *        mean forecast with <code>mean</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(Collection<String> forecastTypes);

        /**
         * <p>
         * The forecast types used to train a predictor. You can specify up to five forecast types. Forecast types can
         * be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the mean forecast with
         * <code>mean</code>.
         * </p>
         * 
         * @param forecastTypes
         *        The forecast types used to train a predictor. You can specify up to five forecast types. Forecast
         *        types can be quantiles from 0.01 to 0.99, by increments of 0.01 or higher. You can also specify the
         *        mean forecast with <code>mean</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastTypes(String... forecastTypes);

        /**
         * <p>
         * An array of dimension (field) names that specify how to group the generated forecast.
         * </p>
         * <p>
         * For example, if you are generating forecasts for item sales across all your stores, and your dataset contains
         * a <code>store_id</code> field, you would specify <code>store_id</code> as a dimension to group sales
         * forecasts for each store.
         * </p>
         * 
         * @param forecastDimensions
         *        An array of dimension (field) names that specify how to group the generated forecast.</p>
         *        <p>
         *        For example, if you are generating forecasts for item sales across all your stores, and your dataset
         *        contains a <code>store_id</code> field, you would specify <code>store_id</code> as a dimension to
         *        group sales forecasts for each store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastDimensions(Collection<String> forecastDimensions);

        /**
         * <p>
         * An array of dimension (field) names that specify how to group the generated forecast.
         * </p>
         * <p>
         * For example, if you are generating forecasts for item sales across all your stores, and your dataset contains
         * a <code>store_id</code> field, you would specify <code>store_id</code> as a dimension to group sales
         * forecasts for each store.
         * </p>
         * 
         * @param forecastDimensions
         *        An array of dimension (field) names that specify how to group the generated forecast.</p>
         *        <p>
         *        For example, if you are generating forecasts for item sales across all your stores, and your dataset
         *        contains a <code>store_id</code> field, you would specify <code>store_id</code> as a dimension to
         *        group sales forecasts for each store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastDimensions(String... forecastDimensions);

        /**
         * <p>
         * The frequency of predictions in a forecast.
         * </p>
         * <p>
         * Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes),
         * 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min"
         * indicates every five minutes.
         * </p>
         * <p>
         * The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
         * </p>
         * <p>
         * When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES
         * dataset frequency.
         * </p>
         * 
         * @param forecastFrequency
         *        The frequency of predictions in a forecast.</p>
         *        <p>
         *        Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15
         *        minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every
         *        year and "5min" indicates every five minutes.
         *        </p>
         *        <p>
         *        The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.
         *        </p>
         *        <p>
         *        When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES
         *        dataset frequency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastFrequency(String forecastFrequency);

        /**
         * <p>
         * The data configuration for your dataset group and any additional datasets.
         * </p>
         * 
         * @param dataConfig
         *        The data configuration for your dataset group and any additional datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataConfig(DataConfig dataConfig);

        /**
         * <p>
         * The data configuration for your dataset group and any additional datasets.
         * </p>
         * This is a convenience that creates an instance of the {@link DataConfig.Builder} avoiding the need to create
         * one manually via {@link DataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #dataConfig(DataConfig)}.
         * 
         * @param dataConfig
         *        a consumer that will call methods on {@link DataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataConfig(DataConfig)
         */
        default Builder dataConfig(Consumer<DataConfig.Builder> dataConfig) {
            return dataConfig(DataConfig.builder().applyMutation(dataConfig).build());
        }

        /**
         * Sets the value of the EncryptionConfig property for this object.
         *
         * @param encryptionConfig
         *        The new value for the EncryptionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfig(EncryptionConfig encryptionConfig);

        /**
         * Sets the value of the EncryptionConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link EncryptionConfig.Builder} avoiding the need to
         * create one manually via {@link EncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionConfig(EncryptionConfig)}.
         * 
         * @param encryptionConfig
         *        a consumer that will call methods on {@link EncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfig(EncryptionConfig)
         */
        default Builder encryptionConfig(Consumer<EncryptionConfig.Builder> encryptionConfig) {
            return encryptionConfig(EncryptionConfig.builder().applyMutation(encryptionConfig).build());
        }

        /**
         * <p>
         * The ARN of the predictor to retrain or upgrade. This parameter is only used when retraining or upgrading a
         * predictor. When creating a new predictor, do not specify a value for this parameter.
         * </p>
         * <p>
         * When upgrading or retraining a predictor, only specify values for the <code>ReferencePredictorArn</code> and
         * <code>PredictorName</code>. The value for <code>PredictorName</code> must be a unique predictor name.
         * </p>
         * 
         * @param referencePredictorArn
         *        The ARN of the predictor to retrain or upgrade. This parameter is only used when retraining or
         *        upgrading a predictor. When creating a new predictor, do not specify a value for this parameter.</p>
         *        <p>
         *        When upgrading or retraining a predictor, only specify values for the
         *        <code>ReferencePredictorArn</code> and <code>PredictorName</code>. The value for
         *        <code>PredictorName</code> must be a unique predictor name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencePredictorArn(String referencePredictorArn);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(String optimizationMetric);

        /**
         * <p>
         * The accuracy metric used to optimize the predictor.
         * </p>
         * 
         * @param optimizationMetric
         *        The accuracy metric used to optimize the predictor.
         * @see OptimizationMetric
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationMetric
         */
        Builder optimizationMetric(OptimizationMetric optimizationMetric);

        /**
         * Sets the value of the ExplainPredictor property for this object.
         *
         * @param explainPredictor
         *        The new value for the ExplainPredictor property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainPredictor(Boolean explainPredictor);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your predictors. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String predictorName;

        private Integer forecastHorizon;

        private List<String> forecastTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> forecastDimensions = DefaultSdkAutoConstructList.getInstance();

        private String forecastFrequency;

        private DataConfig dataConfig;

        private EncryptionConfig encryptionConfig;

        private String referencePredictorArn;

        private String optimizationMetric;

        private Boolean explainPredictor;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoPredictorRequest model) {
            super(model);
            predictorName(model.predictorName);
            forecastHorizon(model.forecastHorizon);
            forecastTypes(model.forecastTypes);
            forecastDimensions(model.forecastDimensions);
            forecastFrequency(model.forecastFrequency);
            dataConfig(model.dataConfig);
            encryptionConfig(model.encryptionConfig);
            referencePredictorArn(model.referencePredictorArn);
            optimizationMetric(model.optimizationMetric);
            explainPredictor(model.explainPredictor);
            tags(model.tags);
        }

        public final String getPredictorName() {
            return predictorName;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        @Override
        @Transient
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final Integer getForecastHorizon() {
            return forecastHorizon;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        @Override
        @Transient
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final Collection<String> getForecastTypes() {
            if (forecastTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastTypes;
        }

        public final void setForecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
        }

        @Override
        @Transient
        public final Builder forecastTypes(Collection<String> forecastTypes) {
            this.forecastTypes = ForecastTypesCopier.copy(forecastTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecastTypes(String... forecastTypes) {
            forecastTypes(Arrays.asList(forecastTypes));
            return this;
        }

        public final Collection<String> getForecastDimensions() {
            if (forecastDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return forecastDimensions;
        }

        public final void setForecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
        }

        @Override
        @Transient
        public final Builder forecastDimensions(Collection<String> forecastDimensions) {
            this.forecastDimensions = ForecastDimensionsCopier.copy(forecastDimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder forecastDimensions(String... forecastDimensions) {
            forecastDimensions(Arrays.asList(forecastDimensions));
            return this;
        }

        public final String getForecastFrequency() {
            return forecastFrequency;
        }

        public final void setForecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
        }

        @Override
        @Transient
        public final Builder forecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
            return this;
        }

        public final DataConfig.Builder getDataConfig() {
            return dataConfig != null ? dataConfig.toBuilder() : null;
        }

        public final void setDataConfig(DataConfig.BuilderImpl dataConfig) {
            this.dataConfig = dataConfig != null ? dataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder dataConfig(DataConfig dataConfig) {
            this.dataConfig = dataConfig;
            return this;
        }

        public final EncryptionConfig.Builder getEncryptionConfig() {
            return encryptionConfig != null ? encryptionConfig.toBuilder() : null;
        }

        public final void setEncryptionConfig(EncryptionConfig.BuilderImpl encryptionConfig) {
            this.encryptionConfig = encryptionConfig != null ? encryptionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfig(EncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
            return this;
        }

        public final String getReferencePredictorArn() {
            return referencePredictorArn;
        }

        public final void setReferencePredictorArn(String referencePredictorArn) {
            this.referencePredictorArn = referencePredictorArn;
        }

        @Override
        @Transient
        public final Builder referencePredictorArn(String referencePredictorArn) {
            this.referencePredictorArn = referencePredictorArn;
            return this;
        }

        public final String getOptimizationMetric() {
            return optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        @Transient
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        @Transient
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        public final Boolean getExplainPredictor() {
            return explainPredictor;
        }

        public final void setExplainPredictor(Boolean explainPredictor) {
            this.explainPredictor = explainPredictor;
        }

        @Override
        @Transient
        public final Builder explainPredictor(Boolean explainPredictor) {
            this.explainPredictor = explainPredictor;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoPredictorRequest build() {
            return new CreateAutoPredictorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
