/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.forecast.DefaultForecastAsyncClient;
import software.amazon.awssdk.services.forecast.DefaultForecastBaseClientBuilder;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.ForecastAsyncClientBuilder;
import software.amazon.awssdk.services.forecast.ForecastServiceClientConfiguration;
import software.amazon.awssdk.services.forecast.endpoints.ForecastEndpointProvider;

@SdkInternalApi
final class DefaultForecastAsyncClientBuilder
extends DefaultForecastBaseClientBuilder<ForecastAsyncClientBuilder, ForecastAsyncClient>
implements ForecastAsyncClientBuilder {
    DefaultForecastAsyncClientBuilder() {
    }

    @Override
    public DefaultForecastAsyncClientBuilder endpointProvider(ForecastEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ForecastAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultForecastAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ForecastServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultForecastAsyncClient client = new DefaultForecastAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ForecastServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ForecastServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

