/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastAsyncClient;
import software.amazon.awssdk.services.forecast.model.ExplainabilityExportSummary;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse;

public class ListExplainabilityExportsPublisher
implements SdkPublisher<ListExplainabilityExportsResponse> {
    private final ForecastAsyncClient client;
    private final ListExplainabilityExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExplainabilityExportsPublisher(ForecastAsyncClient client, ListExplainabilityExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExplainabilityExportsPublisher(ForecastAsyncClient client, ListExplainabilityExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExplainabilityExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExplainabilityExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExplainabilityExportSummary> explainabilityExports() {
        Function<ListExplainabilityExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.explainabilityExports() != null) {
                return response.explainabilityExports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExplainabilityExportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExplainabilityExportsResponseFetcher
    implements AsyncPageFetcher<ListExplainabilityExportsResponse> {
        private ListExplainabilityExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExplainabilityExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExplainabilityExportsResponse> nextPage(ListExplainabilityExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExplainabilityExportsPublisher.this.client.listExplainabilityExports(ListExplainabilityExportsPublisher.this.firstRequest);
            }
            return ListExplainabilityExportsPublisher.this.client.listExplainabilityExports((ListExplainabilityExportsRequest)((Object)ListExplainabilityExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

