/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.ForecastServiceClientConfiguration;
import software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest;
import software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse;
import software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.CreateDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest;
import software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobResponse;
import software.amazon.awssdk.services.forecast.model.CreateDatasetRequest;
import software.amazon.awssdk.services.forecast.model.CreateDatasetResponse;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportResponse;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest;
import software.amazon.awssdk.services.forecast.model.CreateExplainabilityResponse;
import software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest;
import software.amazon.awssdk.services.forecast.model.CreateForecastExportJobResponse;
import software.amazon.awssdk.services.forecast.model.CreateForecastRequest;
import software.amazon.awssdk.services.forecast.model.CreateForecastResponse;
import software.amazon.awssdk.services.forecast.model.CreateMonitorRequest;
import software.amazon.awssdk.services.forecast.model.CreateMonitorResponse;
import software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest;
import software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobResponse;
import software.amazon.awssdk.services.forecast.model.CreatePredictorRequest;
import software.amazon.awssdk.services.forecast.model.CreatePredictorResponse;
import software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest;
import software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisResponse;
import software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest;
import software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportResponse;
import software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest;
import software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastResponse;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobResponse;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.forecast.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportResponse;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest;
import software.amazon.awssdk.services.forecast.model.DeleteExplainabilityResponse;
import software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DeleteForecastRequest;
import software.amazon.awssdk.services.forecast.model.DeleteForecastResponse;
import software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.forecast.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DeletePredictorRequest;
import software.amazon.awssdk.services.forecast.model.DeletePredictorResponse;
import software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest;
import software.amazon.awssdk.services.forecast.model.DeleteResourceTreeResponse;
import software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest;
import software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisResponse;
import software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest;
import software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportResponse;
import software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest;
import software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastResponse;
import software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest;
import software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest;
import software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse;
import software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DescribeForecastRequest;
import software.amazon.awssdk.services.forecast.model.DescribeForecastResponse;
import software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest;
import software.amazon.awssdk.services.forecast.model.DescribeMonitorResponse;
import software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest;
import software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobResponse;
import software.amazon.awssdk.services.forecast.model.DescribePredictorRequest;
import software.amazon.awssdk.services.forecast.model.DescribePredictorResponse;
import software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest;
import software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisResponse;
import software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest;
import software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportResponse;
import software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest;
import software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastResponse;
import software.amazon.awssdk.services.forecast.model.ForecastException;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest;
import software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsResponse;
import software.amazon.awssdk.services.forecast.model.InvalidInputException;
import software.amazon.awssdk.services.forecast.model.InvalidNextTokenException;
import software.amazon.awssdk.services.forecast.model.LimitExceededException;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse;
import software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsResponse;
import software.amazon.awssdk.services.forecast.model.ListDatasetsRequest;
import software.amazon.awssdk.services.forecast.model.ListDatasetsResponse;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilitiesResponse;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsResponse;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse;
import software.amazon.awssdk.services.forecast.model.ListForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastsResponse;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest;
import software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse;
import software.amazon.awssdk.services.forecast.model.ListMonitorsRequest;
import software.amazon.awssdk.services.forecast.model.ListMonitorsResponse;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse;
import software.amazon.awssdk.services.forecast.model.ListPredictorsRequest;
import software.amazon.awssdk.services.forecast.model.ListPredictorsResponse;
import software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.forecast.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsResponse;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse;
import software.amazon.awssdk.services.forecast.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.forecast.model.ResourceInUseException;
import software.amazon.awssdk.services.forecast.model.ResourceNotFoundException;
import software.amazon.awssdk.services.forecast.model.ResumeResourceRequest;
import software.amazon.awssdk.services.forecast.model.ResumeResourceResponse;
import software.amazon.awssdk.services.forecast.model.StopResourceRequest;
import software.amazon.awssdk.services.forecast.model.StopResourceResponse;
import software.amazon.awssdk.services.forecast.model.TagResourceRequest;
import software.amazon.awssdk.services.forecast.model.TagResourceResponse;
import software.amazon.awssdk.services.forecast.model.UntagResourceRequest;
import software.amazon.awssdk.services.forecast.model.UntagResourceResponse;
import software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest;
import software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupResponse;
import software.amazon.awssdk.services.forecast.paginators.ListDatasetGroupsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListDatasetImportJobsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListExplainabilitiesIterable;
import software.amazon.awssdk.services.forecast.paginators.ListExplainabilityExportsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListForecastExportJobsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListForecastsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListMonitorEvaluationsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListMonitorsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListPredictorBacktestExportJobsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListPredictorsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListWhatIfAnalysesIterable;
import software.amazon.awssdk.services.forecast.paginators.ListWhatIfForecastExportsIterable;
import software.amazon.awssdk.services.forecast.paginators.ListWhatIfForecastsIterable;
import software.amazon.awssdk.services.forecast.transform.CreateAutoPredictorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateExplainabilityExportRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateExplainabilityRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateForecastExportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateForecastRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateMonitorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreatePredictorBacktestExportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreatePredictorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateWhatIfAnalysisRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateWhatIfForecastExportRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.CreateWhatIfForecastRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteExplainabilityExportRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteExplainabilityRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteForecastExportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteForecastRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteMonitorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeletePredictorBacktestExportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeletePredictorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteResourceTreeRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteWhatIfAnalysisRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteWhatIfForecastExportRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DeleteWhatIfForecastRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeAutoPredictorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeExplainabilityExportRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeExplainabilityRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeForecastExportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeForecastRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeMonitorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribePredictorBacktestExportJobRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribePredictorRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeWhatIfAnalysisRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeWhatIfForecastExportRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.DescribeWhatIfForecastRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.GetAccuracyMetricsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListDatasetGroupsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListDatasetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListExplainabilitiesRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListExplainabilityExportsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListForecastExportJobsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListForecastsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListMonitorEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListMonitorsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListPredictorBacktestExportJobsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListPredictorsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListWhatIfAnalysesRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListWhatIfForecastExportsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ListWhatIfForecastsRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.ResumeResourceRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.StopResourceRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.forecast.transform.UpdateDatasetGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultForecastClient
implements ForecastClient {
    private static final Logger log = Logger.loggerFor(DefaultForecastClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ForecastServiceClientConfiguration serviceClientConfiguration;

    protected DefaultForecastClient(ForecastServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAutoPredictorResponse createAutoPredictor(CreateAutoPredictorRequest createAutoPredictorRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAutoPredictorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createAutoPredictorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAutoPredictor");
            CreateAutoPredictorResponse createAutoPredictorResponse = (CreateAutoPredictorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAutoPredictor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAutoPredictorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAutoPredictorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAutoPredictorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createAutoPredictor$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataset");
            CreateDatasetResponse createDatasetResponse = (CreateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createDataset$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetGroupResponse createDatasetGroup(CreateDatasetGroupRequest createDatasetGroupRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatasetGroup");
            CreateDatasetGroupResponse createDatasetGroupResponse = (CreateDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createDatasetGroup$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetImportJobResponse createDatasetImportJob(CreateDatasetImportJobRequest createDatasetImportJobRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createDatasetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatasetImportJob");
            CreateDatasetImportJobResponse createDatasetImportJobResponse = (CreateDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createDatasetImportJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExplainabilityResponse createExplainability(CreateExplainabilityRequest createExplainabilityRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExplainabilityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createExplainabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExplainability");
            CreateExplainabilityResponse createExplainabilityResponse = (CreateExplainabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExplainability").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createExplainabilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExplainabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExplainabilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createExplainability$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateExplainabilityExportResponse createExplainabilityExport(CreateExplainabilityExportRequest createExplainabilityExportRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExplainabilityExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createExplainabilityExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExplainabilityExport");
            CreateExplainabilityExportResponse createExplainabilityExportResponse = (CreateExplainabilityExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExplainabilityExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createExplainabilityExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateExplainabilityExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createExplainabilityExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createExplainabilityExport$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateForecastResponse createForecast(CreateForecastRequest createForecastRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateForecast");
            CreateForecastResponse createForecastResponse = (CreateForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createForecast$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateForecastExportJobResponse createForecastExportJob(CreateForecastExportJobRequest createForecastExportJobRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateForecastExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createForecastExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateForecastExportJob");
            CreateForecastExportJobResponse createForecastExportJobResponse = (CreateForecastExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateForecastExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createForecastExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateForecastExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createForecastExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createForecastExportJob$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMonitorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMonitor");
            CreateMonitorResponse createMonitorResponse = (CreateMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMonitor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createMonitor$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePredictorResponse createPredictor(CreatePredictorRequest createPredictorRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePredictorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createPredictorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePredictor");
            CreatePredictorResponse createPredictorResponse = (CreatePredictorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePredictor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPredictorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePredictorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPredictorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createPredictor$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePredictorBacktestExportJobResponse createPredictorBacktestExportJob(CreatePredictorBacktestExportJobRequest createPredictorBacktestExportJobRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePredictorBacktestExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createPredictorBacktestExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePredictorBacktestExportJob");
            CreatePredictorBacktestExportJobResponse createPredictorBacktestExportJobResponse = (CreatePredictorBacktestExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePredictorBacktestExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPredictorBacktestExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePredictorBacktestExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPredictorBacktestExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createPredictorBacktestExportJob$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWhatIfAnalysisResponse createWhatIfAnalysis(CreateWhatIfAnalysisRequest createWhatIfAnalysisRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWhatIfAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createWhatIfAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWhatIfAnalysis");
            CreateWhatIfAnalysisResponse createWhatIfAnalysisResponse = (CreateWhatIfAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWhatIfAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWhatIfAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWhatIfAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWhatIfAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createWhatIfAnalysis$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWhatIfForecastResponse createWhatIfForecast(CreateWhatIfForecastRequest createWhatIfForecastRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWhatIfForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createWhatIfForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWhatIfForecast");
            CreateWhatIfForecastResponse createWhatIfForecastResponse = (CreateWhatIfForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWhatIfForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWhatIfForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWhatIfForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWhatIfForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createWhatIfForecast$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWhatIfForecastExportResponse createWhatIfForecastExport(CreateWhatIfForecastExportRequest createWhatIfForecastExportRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWhatIfForecastExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, createWhatIfForecastExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWhatIfForecastExport");
            CreateWhatIfForecastExportResponse createWhatIfForecastExportResponse = (CreateWhatIfForecastExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWhatIfForecastExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWhatIfForecastExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWhatIfForecastExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWhatIfForecastExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$createWhatIfForecastExport$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataset");
            DeleteDatasetResponse deleteDatasetResponse = (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteDataset$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetGroupResponse deleteDatasetGroup(DeleteDatasetGroupRequest deleteDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatasetGroup");
            DeleteDatasetGroupResponse deleteDatasetGroupResponse = (DeleteDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteDatasetGroup$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetImportJobResponse deleteDatasetImportJob(DeleteDatasetImportJobRequest deleteDatasetImportJobRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteDatasetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatasetImportJob");
            DeleteDatasetImportJobResponse deleteDatasetImportJobResponse = (DeleteDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteDatasetImportJob$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExplainabilityResponse deleteExplainability(DeleteExplainabilityRequest deleteExplainabilityRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteExplainabilityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteExplainabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteExplainability");
            DeleteExplainabilityResponse deleteExplainabilityResponse = (DeleteExplainabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteExplainability").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteExplainabilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteExplainabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteExplainabilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteExplainability$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExplainabilityExportResponse deleteExplainabilityExport(DeleteExplainabilityExportRequest deleteExplainabilityExportRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteExplainabilityExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteExplainabilityExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteExplainabilityExport");
            DeleteExplainabilityExportResponse deleteExplainabilityExportResponse = (DeleteExplainabilityExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteExplainabilityExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteExplainabilityExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteExplainabilityExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteExplainabilityExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteExplainabilityExport$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteForecastResponse deleteForecast(DeleteForecastRequest deleteForecastRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteForecast");
            DeleteForecastResponse deleteForecastResponse = (DeleteForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteForecast$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteForecastExportJobResponse deleteForecastExportJob(DeleteForecastExportJobRequest deleteForecastExportJobRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteForecastExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteForecastExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteForecastExportJob");
            DeleteForecastExportJobResponse deleteForecastExportJobResponse = (DeleteForecastExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteForecastExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteForecastExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteForecastExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteForecastExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteForecastExportJob$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMonitorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMonitor");
            DeleteMonitorResponse deleteMonitorResponse = (DeleteMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMonitor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteMonitor$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePredictorResponse deletePredictor(DeletePredictorRequest deletePredictorRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePredictorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deletePredictorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePredictor");
            DeletePredictorResponse deletePredictorResponse = (DeletePredictorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePredictor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePredictorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePredictorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePredictorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deletePredictor$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePredictorBacktestExportJobResponse deletePredictorBacktestExportJob(DeletePredictorBacktestExportJobRequest deletePredictorBacktestExportJobRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePredictorBacktestExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deletePredictorBacktestExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePredictorBacktestExportJob");
            DeletePredictorBacktestExportJobResponse deletePredictorBacktestExportJobResponse = (DeletePredictorBacktestExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePredictorBacktestExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePredictorBacktestExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePredictorBacktestExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePredictorBacktestExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deletePredictorBacktestExportJob$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceTreeResponse deleteResourceTree(DeleteResourceTreeRequest deleteResourceTreeRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceTreeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteResourceTreeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceTree");
            DeleteResourceTreeResponse deleteResourceTreeResponse = (DeleteResourceTreeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceTree").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourceTreeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceTreeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceTreeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteResourceTree$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWhatIfAnalysisResponse deleteWhatIfAnalysis(DeleteWhatIfAnalysisRequest deleteWhatIfAnalysisRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWhatIfAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteWhatIfAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWhatIfAnalysis");
            DeleteWhatIfAnalysisResponse deleteWhatIfAnalysisResponse = (DeleteWhatIfAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWhatIfAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWhatIfAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWhatIfAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWhatIfAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteWhatIfAnalysis$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWhatIfForecastResponse deleteWhatIfForecast(DeleteWhatIfForecastRequest deleteWhatIfForecastRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWhatIfForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteWhatIfForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWhatIfForecast");
            DeleteWhatIfForecastResponse deleteWhatIfForecastResponse = (DeleteWhatIfForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWhatIfForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWhatIfForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWhatIfForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWhatIfForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteWhatIfForecast$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWhatIfForecastExportResponse deleteWhatIfForecastExport(DeleteWhatIfForecastExportRequest deleteWhatIfForecastExportRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWhatIfForecastExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, deleteWhatIfForecastExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWhatIfForecastExport");
            DeleteWhatIfForecastExportResponse deleteWhatIfForecastExportResponse = (DeleteWhatIfForecastExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWhatIfForecastExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWhatIfForecastExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWhatIfForecastExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWhatIfForecastExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$deleteWhatIfForecastExport$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAutoPredictorResponse describeAutoPredictor(DescribeAutoPredictorRequest describeAutoPredictorRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAutoPredictorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeAutoPredictorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAutoPredictor");
            DescribeAutoPredictorResponse describeAutoPredictorResponse = (DescribeAutoPredictorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAutoPredictor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAutoPredictorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAutoPredictorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAutoPredictorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeAutoPredictor$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            DescribeDatasetResponse describeDatasetResponse = (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeDataset$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetGroupResponse describeDatasetGroup(DescribeDatasetGroupRequest describeDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatasetGroup");
            DescribeDatasetGroupResponse describeDatasetGroupResponse = (DescribeDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeDatasetGroup$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetImportJobResponse describeDatasetImportJob(DescribeDatasetImportJobRequest describeDatasetImportJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatasetImportJob");
            DescribeDatasetImportJobResponse describeDatasetImportJobResponse = (DescribeDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeDatasetImportJob$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExplainabilityResponse describeExplainability(DescribeExplainabilityRequest describeExplainabilityRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExplainabilityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeExplainabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExplainability");
            DescribeExplainabilityResponse describeExplainabilityResponse = (DescribeExplainabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExplainability").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExplainabilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExplainabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExplainabilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeExplainability$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExplainabilityExportResponse describeExplainabilityExport(DescribeExplainabilityExportRequest describeExplainabilityExportRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExplainabilityExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeExplainabilityExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExplainabilityExport");
            DescribeExplainabilityExportResponse describeExplainabilityExportResponse = (DescribeExplainabilityExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExplainabilityExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExplainabilityExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExplainabilityExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExplainabilityExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeExplainabilityExport$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeForecastResponse describeForecast(DescribeForecastRequest describeForecastRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeForecast");
            DescribeForecastResponse describeForecastResponse = (DescribeForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeForecast$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeForecastExportJobResponse describeForecastExportJob(DescribeForecastExportJobRequest describeForecastExportJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeForecastExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeForecastExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeForecastExportJob");
            DescribeForecastExportJobResponse describeForecastExportJobResponse = (DescribeForecastExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeForecastExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeForecastExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeForecastExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeForecastExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeForecastExportJob$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMonitorResponse describeMonitor(DescribeMonitorRequest describeMonitorRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMonitorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMonitor");
            DescribeMonitorResponse describeMonitorResponse = (DescribeMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMonitor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeMonitor$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePredictorResponse describePredictor(DescribePredictorRequest describePredictorRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePredictorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describePredictorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePredictor");
            DescribePredictorResponse describePredictorResponse = (DescribePredictorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePredictor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePredictorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePredictorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePredictorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describePredictor$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePredictorBacktestExportJobResponse describePredictorBacktestExportJob(DescribePredictorBacktestExportJobRequest describePredictorBacktestExportJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePredictorBacktestExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describePredictorBacktestExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePredictorBacktestExportJob");
            DescribePredictorBacktestExportJobResponse describePredictorBacktestExportJobResponse = (DescribePredictorBacktestExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePredictorBacktestExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePredictorBacktestExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePredictorBacktestExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePredictorBacktestExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describePredictorBacktestExportJob$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWhatIfAnalysisResponse describeWhatIfAnalysis(DescribeWhatIfAnalysisRequest describeWhatIfAnalysisRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWhatIfAnalysisResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeWhatIfAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWhatIfAnalysis");
            DescribeWhatIfAnalysisResponse describeWhatIfAnalysisResponse = (DescribeWhatIfAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWhatIfAnalysis").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWhatIfAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWhatIfAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWhatIfAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeWhatIfAnalysis$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWhatIfForecastResponse describeWhatIfForecast(DescribeWhatIfForecastRequest describeWhatIfForecastRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWhatIfForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeWhatIfForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWhatIfForecast");
            DescribeWhatIfForecastResponse describeWhatIfForecastResponse = (DescribeWhatIfForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWhatIfForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWhatIfForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWhatIfForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWhatIfForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeWhatIfForecast$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWhatIfForecastExportResponse describeWhatIfForecastExport(DescribeWhatIfForecastExportRequest describeWhatIfForecastExportRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWhatIfForecastExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, describeWhatIfForecastExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWhatIfForecastExport");
            DescribeWhatIfForecastExportResponse describeWhatIfForecastExportResponse = (DescribeWhatIfForecastExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWhatIfForecastExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWhatIfForecastExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeWhatIfForecastExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeWhatIfForecastExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$describeWhatIfForecastExport$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccuracyMetricsResponse getAccuracyMetrics(GetAccuracyMetricsRequest getAccuracyMetricsRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccuracyMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, getAccuracyMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccuracyMetrics");
            GetAccuracyMetricsResponse getAccuracyMetricsResponse = (GetAccuracyMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccuracyMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccuracyMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAccuracyMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccuracyMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$getAccuracyMetrics$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetGroupsResponse listDatasetGroups(ListDatasetGroupsRequest listDatasetGroupsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listDatasetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetGroups");
            ListDatasetGroupsResponse listDatasetGroupsResponse = (ListDatasetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listDatasetGroups$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetGroupsIterable listDatasetGroupsPaginator(ListDatasetGroupsRequest listDatasetGroupsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        return new ListDatasetGroupsIterable(this, this.applyPaginatorUserAgent(listDatasetGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetImportJobsResponse listDatasetImportJobs(ListDatasetImportJobsRequest listDatasetImportJobsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listDatasetImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetImportJobs");
            ListDatasetImportJobsResponse listDatasetImportJobsResponse = (ListDatasetImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listDatasetImportJobs$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetImportJobsIterable listDatasetImportJobsPaginator(ListDatasetImportJobsRequest listDatasetImportJobsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListDatasetImportJobsIterable(this, this.applyPaginatorUserAgent(listDatasetImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            ListDatasetsResponse listDatasetsResponse = (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listDatasets$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, ForecastException {
        return new ListDatasetsIterable(this, this.applyPaginatorUserAgent(listDatasetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExplainabilitiesResponse listExplainabilities(ListExplainabilitiesRequest listExplainabilitiesRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExplainabilitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listExplainabilitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExplainabilities");
            ListExplainabilitiesResponse listExplainabilitiesResponse = (ListExplainabilitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExplainabilities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExplainabilitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExplainabilitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExplainabilitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listExplainabilities$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExplainabilitiesIterable listExplainabilitiesPaginator(ListExplainabilitiesRequest listExplainabilitiesRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListExplainabilitiesIterable(this, this.applyPaginatorUserAgent(listExplainabilitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExplainabilityExportsResponse listExplainabilityExports(ListExplainabilityExportsRequest listExplainabilityExportsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExplainabilityExportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listExplainabilityExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExplainabilityExports");
            ListExplainabilityExportsResponse listExplainabilityExportsResponse = (ListExplainabilityExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExplainabilityExports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExplainabilityExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExplainabilityExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExplainabilityExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listExplainabilityExports$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExplainabilityExportsIterable listExplainabilityExportsPaginator(ListExplainabilityExportsRequest listExplainabilityExportsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListExplainabilityExportsIterable(this, this.applyPaginatorUserAgent(listExplainabilityExportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListForecastExportJobsResponse listForecastExportJobs(ListForecastExportJobsRequest listForecastExportJobsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListForecastExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listForecastExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListForecastExportJobs");
            ListForecastExportJobsResponse listForecastExportJobsResponse = (ListForecastExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListForecastExportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listForecastExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListForecastExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listForecastExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listForecastExportJobs$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListForecastExportJobsIterable listForecastExportJobsPaginator(ListForecastExportJobsRequest listForecastExportJobsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListForecastExportJobsIterable(this, this.applyPaginatorUserAgent(listForecastExportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListForecastsResponse listForecasts(ListForecastsRequest listForecastsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListForecastsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listForecastsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListForecasts");
            ListForecastsResponse listForecastsResponse = (ListForecastsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListForecasts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listForecastsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListForecastsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listForecastsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listForecasts$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListForecastsIterable listForecastsPaginator(ListForecastsRequest listForecastsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListForecastsIterable(this, this.applyPaginatorUserAgent(listForecastsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMonitorEvaluationsResponse listMonitorEvaluations(ListMonitorEvaluationsRequest listMonitorEvaluationsRequest) throws InvalidNextTokenException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMonitorEvaluationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listMonitorEvaluationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMonitorEvaluations");
            ListMonitorEvaluationsResponse listMonitorEvaluationsResponse = (ListMonitorEvaluationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMonitorEvaluations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMonitorEvaluationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMonitorEvaluationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMonitorEvaluationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listMonitorEvaluations$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMonitorEvaluationsIterable listMonitorEvaluationsPaginator(ListMonitorEvaluationsRequest listMonitorEvaluationsRequest) throws InvalidNextTokenException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        return new ListMonitorEvaluationsIterable(this, this.applyPaginatorUserAgent(listMonitorEvaluationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMonitorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listMonitorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMonitors");
            ListMonitorsResponse listMonitorsResponse = (ListMonitorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMonitors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMonitorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMonitorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMonitorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listMonitors$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMonitorsIterable listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListMonitorsIterable(this, this.applyPaginatorUserAgent(listMonitorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPredictorBacktestExportJobsResponse listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsRequest listPredictorBacktestExportJobsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPredictorBacktestExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listPredictorBacktestExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPredictorBacktestExportJobs");
            ListPredictorBacktestExportJobsResponse listPredictorBacktestExportJobsResponse = (ListPredictorBacktestExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPredictorBacktestExportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPredictorBacktestExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPredictorBacktestExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPredictorBacktestExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listPredictorBacktestExportJobs$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPredictorBacktestExportJobsIterable listPredictorBacktestExportJobsPaginator(ListPredictorBacktestExportJobsRequest listPredictorBacktestExportJobsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListPredictorBacktestExportJobsIterable(this, this.applyPaginatorUserAgent(listPredictorBacktestExportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPredictorsResponse listPredictors(ListPredictorsRequest listPredictorsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPredictorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listPredictorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPredictors");
            ListPredictorsResponse listPredictorsResponse = (ListPredictorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPredictors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPredictorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPredictorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPredictorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listPredictors$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPredictorsIterable listPredictorsPaginator(ListPredictorsRequest listPredictorsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListPredictorsIterable(this, this.applyPaginatorUserAgent(listPredictorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listTagsForResource$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWhatIfAnalysesResponse listWhatIfAnalyses(ListWhatIfAnalysesRequest listWhatIfAnalysesRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWhatIfAnalysesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listWhatIfAnalysesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWhatIfAnalyses");
            ListWhatIfAnalysesResponse listWhatIfAnalysesResponse = (ListWhatIfAnalysesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWhatIfAnalyses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWhatIfAnalysesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWhatIfAnalysesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWhatIfAnalysesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listWhatIfAnalyses$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWhatIfAnalysesIterable listWhatIfAnalysesPaginator(ListWhatIfAnalysesRequest listWhatIfAnalysesRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListWhatIfAnalysesIterable(this, this.applyPaginatorUserAgent(listWhatIfAnalysesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWhatIfForecastExportsResponse listWhatIfForecastExports(ListWhatIfForecastExportsRequest listWhatIfForecastExportsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWhatIfForecastExportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listWhatIfForecastExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWhatIfForecastExports");
            ListWhatIfForecastExportsResponse listWhatIfForecastExportsResponse = (ListWhatIfForecastExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWhatIfForecastExports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWhatIfForecastExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWhatIfForecastExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWhatIfForecastExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listWhatIfForecastExports$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWhatIfForecastExportsIterable listWhatIfForecastExportsPaginator(ListWhatIfForecastExportsRequest listWhatIfForecastExportsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListWhatIfForecastExportsIterable(this, this.applyPaginatorUserAgent(listWhatIfForecastExportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWhatIfForecastsResponse listWhatIfForecasts(ListWhatIfForecastsRequest listWhatIfForecastsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWhatIfForecastsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, listWhatIfForecastsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWhatIfForecasts");
            ListWhatIfForecastsResponse listWhatIfForecastsResponse = (ListWhatIfForecastsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWhatIfForecasts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWhatIfForecastsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWhatIfForecastsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWhatIfForecastsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$listWhatIfForecasts$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWhatIfForecastsIterable listWhatIfForecastsPaginator(ListWhatIfForecastsRequest listWhatIfForecastsRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        return new ListWhatIfForecastsIterable(this, this.applyPaginatorUserAgent(listWhatIfForecastsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeResourceResponse resumeResource(ResumeResourceRequest resumeResourceRequest) throws InvalidInputException, LimitExceededException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResumeResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, resumeResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeResource");
            ResumeResourceResponse resumeResourceResponse = (ResumeResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResumeResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resumeResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$resumeResource$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopResourceResponse stopResource(StopResourceRequest stopResourceRequest) throws InvalidInputException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, stopResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopResource");
            StopResourceResponse stopResourceResponse = (StopResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$stopResource$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, LimitExceededException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$tagResource$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$untagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDatasetGroupResponse updateDatasetGroup(UpdateDatasetGroupRequest updateDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ForecastException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultForecastClient.resolveMetricPublishers(this.clientConfiguration, updateDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"forecast");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDatasetGroup");
            UpdateDatasetGroupResponse updateDatasetGroupResponse = (UpdateDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultForecastClient.lambda$updateDatasetGroup$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends ForecastRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.87").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ForecastRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "forecast";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ForecastException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final ForecastServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateDatasetGroup$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopResource$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeResource$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWhatIfForecasts$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWhatIfForecastExports$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWhatIfAnalyses$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPredictors$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPredictorBacktestExportJobs$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMonitors$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMonitorEvaluations$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listForecasts$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listForecastExportJobs$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExplainabilityExports$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExplainabilities$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetImportJobs$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetGroups$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccuracyMetrics$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWhatIfForecastExport$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWhatIfForecast$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWhatIfAnalysis$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePredictorBacktestExportJob$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePredictor$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMonitor$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeForecastExportJob$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeForecast$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExplainabilityExport$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExplainability$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatasetImportJob$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatasetGroup$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAutoPredictor$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWhatIfForecastExport$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWhatIfForecast$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWhatIfAnalysis$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourceTree$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePredictorBacktestExportJob$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePredictor$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMonitor$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteForecastExportJob$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteForecast$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteExplainabilityExport$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteExplainability$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatasetImportJob$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatasetGroup$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataset$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWhatIfForecastExport$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWhatIfForecast$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWhatIfAnalysis$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPredictorBacktestExportJob$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPredictor$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMonitor$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createForecastExportJob$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createForecast$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExplainabilityExport$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExplainability$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatasetImportJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatasetGroup$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataset$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAutoPredictor$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

