/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the modifications that you are making to an attribute for a what-if forecast. For example, you can use this
 * operation to create a what-if forecast that investigates a 10% off sale on all shoes. To do this, you specify
 * <code>"AttributeName": "shoes"</code>, <code>"Operation": "MULTIPLY"</code>, and <code>"Value": "0.90"</code>. Pair
 * this operation with the <a>TimeSeriesCondition</a> operation within the
 * <a>CreateWhatIfForecastRequest$TimeSeriesTransformations</a> operation to define a subset of attribute items that are
 * modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(Action::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(Action::operationAsString)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(Action::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            OPERATION_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String operation;

    private final Double value;

    private Action(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.operation = builder.operation;
        this.value = builder.value;
    }

    /**
     * <p>
     * The related time series that you are modifying. This value is case insensitive.
     * </p>
     * 
     * @return The related time series that you are modifying. This value is case insensitive.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The operation that is applied to the provided attribute. Operations include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link Operation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The operation that is applied to the provided attribute. Operations include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
     *         </p>
     *         </li>
     * @see Operation
     */
    public final Operation operation() {
        return Operation.fromValue(operation);
    }

    /**
     * <p>
     * The operation that is applied to the provided attribute. Operations include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link Operation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The operation that is applied to the provided attribute. Operations include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
     *         </p>
     *         </li>
     * @see Operation
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * The value that is applied for the chosen <code>Operation</code>.
     * </p>
     * 
     * @return The value that is applied for the chosen <code>Operation</code>.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(operationAsString(), other.operationAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("AttributeName", attributeName()).add("Operation", operationAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The related time series that you are modifying. This value is case insensitive.
         * </p>
         * 
         * @param attributeName
         *        The related time series that you are modifying. This value is case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The operation that is applied to the provided attribute. Operations include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operation
         *        The operation that is applied to the provided attribute. Operations include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
         *        </p>
         *        </li>
         * @see Operation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operation
         */
        Builder operation(String operation);

        /**
         * <p>
         * The operation that is applied to the provided attribute. Operations include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operation
         *        The operation that is applied to the provided attribute. Operations include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADD</code> - adds <code>Value</code> to all rows of <code>AttributeName</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUBTRACT</code> - subtracts <code>Value</code> from all rows of <code>AttributeName</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTIPLY</code> - multiplies all rows of <code>AttributeName</code> by <code>Value</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DIVIDE</code> - divides all rows of <code>AttributeName</code> by <code>Value</code>.
         *        </p>
         *        </li>
         * @see Operation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operation
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * The value that is applied for the chosen <code>Operation</code>.
         * </p>
         * 
         * @param value
         *        The value that is applied for the chosen <code>Operation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String operation;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            attributeName(model.attributeName);
            operation(model.operation);
            value(model.value);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
