/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the dataset import job properties used in the <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a>
 * operation. To get the complete set of properties, call the <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/API_DescribeDatasetImportJob.html">DescribeDatasetImportJob</a>
 * operation, and provide the <code>DatasetImportJobArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetImportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetImportJobSummary.Builder, DatasetImportJobSummary> {
    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobArn").getter(getter(DatasetImportJobSummary::datasetImportJobArn))
            .setter(setter(Builder::datasetImportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArn").build())
            .build();

    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobName").getter(getter(DatasetImportJobSummary::datasetImportJobName))
            .setter(setter(Builder::datasetImportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build())
            .build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DatasetImportJobSummary::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DatasetImportJobSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DatasetImportJobSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DatasetImportJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DatasetImportJobSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportMode").getter(getter(DatasetImportJobSummary::importModeAsString))
            .setter(setter(Builder::importMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_ARN_FIELD,
            DATASET_IMPORT_JOB_NAME_FIELD, DATA_SOURCE_FIELD, STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD, IMPORT_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetImportJobArn;

    private final String datasetImportJobName;

    private final DataSource dataSource;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String importMode;

    private DatasetImportJobSummary(BuilderImpl builder) {
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.datasetImportJobName = builder.datasetImportJobName;
        this.dataSource = builder.dataSource;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.importMode = builder.importMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset import job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset import job.
     */
    public final String datasetImportJobArn() {
        return datasetImportJobArn;
    }

    /**
     * <p>
     * The name of the dataset import job.
     * </p>
     * 
     * @return The name of the dataset import job.
     */
    public final String datasetImportJobName() {
        return datasetImportJobName;
    }

    /**
     * <p>
     * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon Forecast
     * can assume to access the data. The training data must be stored in an Amazon S3 bucket.
     * </p>
     * <p>
     * If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
     * </p>
     * 
     * @return The location of the training data to import and an Identity and Access Management (IAM) role that Amazon
     *         Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p>
     *         <p>
     *         If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The status of the dataset import job. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the dataset import job. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the dataset import job was created.
     * </p>
     * 
     * @return When the dataset import job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The import mode of the dataset import job, FULL or INCREMENTAL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link ImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return The import mode of the dataset import job, FULL or INCREMENTAL.
     * @see ImportMode
     */
    public final ImportMode importMode() {
        return ImportMode.fromValue(importMode);
    }

    /**
     * <p>
     * The import mode of the dataset import job, FULL or INCREMENTAL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link ImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return The import mode of the dataset import job, FULL or INCREMENTAL.
     * @see ImportMode
     */
    public final String importModeAsString() {
        return importMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(importModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetImportJobSummary)) {
            return false;
        }
        DatasetImportJobSummary other = (DatasetImportJobSummary) obj;
        return Objects.equals(datasetImportJobArn(), other.datasetImportJobArn())
                && Objects.equals(datasetImportJobName(), other.datasetImportJobName())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(importModeAsString(), other.importModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetImportJobSummary").add("DatasetImportJobArn", datasetImportJobArn())
                .add("DatasetImportJobName", datasetImportJobName()).add("DataSource", dataSource()).add("Status", status())
                .add("Message", message()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("ImportMode", importModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobArn":
            return Optional.ofNullable(clazz.cast(datasetImportJobArn()));
        case "DatasetImportJobName":
            return Optional.ofNullable(clazz.cast(datasetImportJobName()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "ImportMode":
            return Optional.ofNullable(clazz.cast(importModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetImportJobArn", DATASET_IMPORT_JOB_ARN_FIELD);
        map.put("DatasetImportJobName", DATASET_IMPORT_JOB_NAME_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        map.put("ImportMode", IMPORT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetImportJobSummary, T> g) {
        return obj -> g.apply((DatasetImportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetImportJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobArn
         *        The Amazon Resource Name (ARN) of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArn(String datasetImportJobArn);

        /**
         * <p>
         * The name of the dataset import job.
         * </p>
         * 
         * @param datasetImportJobName
         *        The name of the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobName(String datasetImportJobName);

        /**
         * <p>
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
         * </p>
         * 
         * @param dataSource
         *        The location of the training data to import and an Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3
         *        bucket.</p>
         *        <p>
         *        If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The location of the training data to import and an Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> includes an Key Management Service (KMS) key.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The status of the dataset import job. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dataset import job. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the dataset import job was created.
         * </p>
         * 
         * @param creationTime
         *        When the dataset import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The import mode of the dataset import job, FULL or INCREMENTAL.
         * </p>
         * 
         * @param importMode
         *        The import mode of the dataset import job, FULL or INCREMENTAL.
         * @see ImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportMode
         */
        Builder importMode(String importMode);

        /**
         * <p>
         * The import mode of the dataset import job, FULL or INCREMENTAL.
         * </p>
         * 
         * @param importMode
         *        The import mode of the dataset import job, FULL or INCREMENTAL.
         * @see ImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportMode
         */
        Builder importMode(ImportMode importMode);
    }

    static final class BuilderImpl implements Builder {
        private String datasetImportJobArn;

        private String datasetImportJobName;

        private DataSource dataSource;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private String importMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetImportJobSummary model) {
            datasetImportJobArn(model.datasetImportJobArn);
            datasetImportJobName(model.datasetImportJobName);
            dataSource(model.dataSource);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            importMode(model.importMode);
        }

        public final String getDatasetImportJobArn() {
            return datasetImportJobArn;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        @Override
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final String getDatasetImportJobName() {
            return datasetImportJobName;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getImportMode() {
            return importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(ImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        @Override
        public DatasetImportJobSummary build() {
            return new DatasetImportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
